/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.OutputStream;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;

public class StreamWriterTriX
implements StreamRDF {
    private static final String rdfXMLLiteral = XMLLiteralType.theXMLLiteralType.getURI();
    private final IndentedWriter out;
    private Node gn = null;
    private boolean inGraph = false;
    private final PrefixMap pmap;
    private int depth = 0;

    public StreamWriterTriX(OutputStream out, PrefixMap prefixMap) {
        this(new IndentedWriter(out), prefixMap);
    }

    StreamWriterTriX(IndentedWriter out, PrefixMap prefixMap) {
        this.out = out;
        PrefixMap pm = null;
        if (pm != null && pm.containsPrefix("")) {
            pm = PrefixMapFactory.create(pm);
            pm.delete("");
        }
        this.pmap = pm;
    }

    @Override
    public void start() {
        if (this.depth == 0) {
            this.writeStart();
        }
        ++this.depth;
    }

    @Override
    public void finish() {
        --this.depth;
        if (this.depth != 0) {
            return;
        }
        this.writeFinish();
        this.out.flush();
    }

    @Override
    public void base(String base) {
    }

    @Override
    public void prefix(String prefix, String iri) {
    }

    @Override
    public void triple(Triple triple) {
        if (this.inGraph && this.gn != null) {
            StreamWriterTriX.endTag(this.out, "graph");
            this.out.println();
            this.inGraph = false;
        }
        if (!this.inGraph) {
            StreamWriterTriX.startTag(this.out, "graph");
            this.out.println();
        }
        this.inGraph = true;
        this.gn = null;
        StreamWriterTriX.write(this.out, triple, this.pmap);
    }

    @Override
    public void quad(Quad quad) {
        Node g2 = quad.getGraph();
        if (g2 == null || Quad.isDefaultGraph(g2)) {
            this.triple(quad.asTriple());
            return;
        }
        if (this.inGraph && !Objects.equals(g2, this.gn)) {
            StreamWriterTriX.endTag(this.out, "graph");
            this.out.println();
            this.inGraph = false;
        }
        if (!this.inGraph) {
            StreamWriterTriX.startTag(this.out, "graph");
            this.out.println();
            if (this.gn == null || !Quad.isDefaultGraph(this.gn)) {
                this.gn = quad.getGraph();
                StreamWriterTriX.write(this.out, this.gn, this.pmap);
            }
        }
        this.inGraph = true;
        this.gn = g2;
        StreamWriterTriX.write(this.out, quad.asTriple(), this.pmap);
    }

    private static void write(IndentedWriter out, Triple triple, PrefixMap prefixMap) {
        out.println("<triple>");
        out.incIndent();
        StreamWriterTriX.write(out, triple.getSubject(), prefixMap);
        StreamWriterTriX.write(out, triple.getPredicate(), prefixMap);
        StreamWriterTriX.write(out, triple.getObject(), prefixMap);
        out.decIndent();
        out.println("</triple>");
    }

    private static void write(IndentedWriter out, Node node, PrefixMap prefixMap) {
        if (node.isURI()) {
            String abbrev;
            String uri = node.getURI();
            if (prefixMap != null && (abbrev = prefixMap.abbreviate(uri)) != null) {
                StreamWriterTriX.startTag(out, "qname");
                StreamWriterTriX.writeText(out, abbrev);
                StreamWriterTriX.endTag(out, "qname");
                out.println();
                return;
            }
            StreamWriterTriX.startTag(out, "uri");
            StreamWriterTriX.writeText(out, node.getURI());
            StreamWriterTriX.endTag(out, "uri");
            out.println();
            return;
        }
        if (node.isBlank()) {
            StreamWriterTriX.startTag(out, "id");
            StreamWriterTriX.writeText(out, node.getBlankNodeLabel());
            StreamWriterTriX.endTag(out, "id");
            out.println();
            return;
        }
        if (node.isLiteral()) {
            if (Util.isSimpleString(node)) {
                StreamWriterTriX.startTag(out, "plainLiteral");
                StreamWriterTriX.writeTextNoIndent(out, node.getLiteralLexicalForm());
                StreamWriterTriX.endTag(out, "plainLiteral");
                out.println();
                return;
            }
            if (Util.isLangString(node)) {
                String lang = node.getLiteralLanguage();
                StreamWriterTriX.startTag(out, "plainLiteral", "xml:lang", lang);
                StreamWriterTriX.writeTextNoIndent(out, node.getLiteralLexicalForm());
                StreamWriterTriX.endTag(out, "plainLiteral");
                out.println();
                return;
            }
            String dt = node.getLiteralDatatypeURI();
            StreamWriterTriX.startTag(out, "typedLiteral", "datatype", dt);
            String lex = node.getLiteralLexicalForm();
            if (rdfXMLLiteral.equals(dt)) {
                int x = out.getAbsoluteIndent();
                out.setAbsoluteIndent(0);
                out.print(lex);
                out.setAbsoluteIndent(x);
            } else {
                StreamWriterTriX.writeTextNoIndent(out, lex);
            }
            StreamWriterTriX.endTag(out, "typedLiteral");
            out.println();
            return;
        }
        if (node.isNodeTriple()) {
            StreamWriterTriX.write(out, node.getTriple(), prefixMap);
            return;
        }
        throw new RiotException("Not a concrete node: " + node);
    }

    private static void writeText(IndentedWriter out, String string) {
        string = Util.substituteEntitiesInElementContent(string);
        out.print(string);
    }

    private static void writeTextNoIndent(IndentedWriter out, String string) {
        int x = out.getAbsoluteIndent();
        out.setAbsoluteIndent(0);
        StreamWriterTriX.writeText(out, string);
        out.setAbsoluteIndent(x);
    }

    private static void startXML(IndentedWriter out) {
    }

    void writeStart() {
        StreamWriterTriX.startXML(this.out);
        if (this.pmap == null || this.pmap.isEmpty()) {
            StreamWriterTriX.startTag(this.out, "trix", "xmlns", "http://www.w3.org/2004/03/trix/trix-1/");
        } else {
            StreamWriterTriX.startTagNS(this.out, "trix", "xmlns", "http://www.w3.org/2004/03/trix/trix-1/", this.pmap);
        }
        this.out.println();
    }

    private void writeFinish() {
        if (this.inGraph) {
            StreamWriterTriX.endTag(this.out, "graph");
            this.out.println();
        }
        StreamWriterTriX.endTag(this.out, "trix");
        this.out.println();
    }

    private static void startTag(IndentedWriter out, String text) {
        out.print("<");
        out.print(text);
        out.print(">");
        out.incIndent();
    }

    private static void startTag(IndentedWriter out, String text, String attr, String attrValue) {
        out.print("<");
        out.print(text);
        out.print(" ");
        out.print(attr);
        out.print("=\"");
        attrValue = Util.substituteStandardEntities(attrValue);
        out.print(attrValue);
        out.print("\"");
        out.print(">");
        out.incIndent();
    }

    private static void startTagNS(IndentedWriter out, String text, String attr, String attrValue, PrefixMap pmap) {
        out.print("<");
        out.print(text);
        out.print(" ");
        int offset = out.getCurrentOffset();
        out.print("xmlns");
        out.print("=\"");
        attrValue = Util.substituteStandardEntities(attrValue);
        out.print(attrValue);
        out.print("\"");
        out.incIndent(offset);
        pmap.forEach((ns, uri) -> {
            out.println();
            out.print("xmlns:");
            out.print((String)ns);
            out.print("=");
            out.print("\"");
            uri = Util.substituteStandardEntities(uri);
            out.print((String)uri);
            out.print("\"");
        });
        out.decIndent(offset);
        out.print(">");
        out.incIndent();
    }

    private static void endTag(IndentedWriter out, String text) {
        out.decIndent();
        out.print("</");
        out.print(text);
        out.print(">");
    }
}

