/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.mem.FourTupleMap;
import org.apache.jena.sparql.core.mem.PMapQuadTable;
import org.apache.jena.sparql.core.mem.QuadTable;
import org.apache.jena.sparql.core.mem.TupleSlot;

public enum QuadTableForm implements Supplier<QuadTable>,
Predicate<Set<TupleSlot>>
{
    GSPO((List)Arrays.asList(TupleSlot.GRAPH, TupleSlot.SUBJECT, TupleSlot.PREDICATE, TupleSlot.OBJECT)){

        @Override
        public PMapQuadTable get() {
            return new PMapQuadTable(this.name()){

                @Override
                public Stream<Node> listGraphNodes() {
                    return ((FourTupleMap)this.local().get()).entryStream().map(Map.Entry::getKey);
                }
            };
        }
    }
    ,
    GOPS(Arrays.asList(TupleSlot.GRAPH, TupleSlot.OBJECT, TupleSlot.PREDICATE, TupleSlot.SUBJECT)),
    SPOG((List)Arrays.asList(TupleSlot.SUBJECT, TupleSlot.PREDICATE, TupleSlot.OBJECT, TupleSlot.GRAPH)){

        @Override
        public PMapQuadTable get() {
            return new PMapQuadTable(this.name()){

                @Override
                public Stream<Quad> findInUnionGraph(Node s2, Node p, Node o) {
                    AtomicReference mostRecentlySeen = new AtomicReference();
                    return this.find(Node.ANY, s2, p, o).map(Quad::asTriple).filter(t2 -> !mostRecentlySeen.getAndSet(t2).equals(t2)).map((? super T t2) -> Quad.create(Quad.unionGraph, t2));
                }
            };
        }
    }
    ,
    OSGP(Arrays.asList(TupleSlot.OBJECT, TupleSlot.SUBJECT, TupleSlot.GRAPH, TupleSlot.PREDICATE)),
    PGSO(Arrays.asList(TupleSlot.PREDICATE, TupleSlot.GRAPH, TupleSlot.SUBJECT, TupleSlot.OBJECT)),
    OPSG((List)Arrays.asList(TupleSlot.OBJECT, TupleSlot.PREDICATE, TupleSlot.SUBJECT, TupleSlot.GRAPH)){

        @Override
        public PMapQuadTable get() {
            return new PMapQuadTable(this.name()){

                @Override
                public Stream<Quad> findInUnionGraph(Node s2, Node p, Node o) {
                    AtomicReference mostRecentlySeen = new AtomicReference();
                    return this.find(Node.ANY, s2, p, o).map(Quad::asTriple).filter(t2 -> !mostRecentlySeen.getAndSet(t2).equals(t2)).map((? super T t2) -> Quad.create(Quad.unionGraph, t2));
                }
            };
        }
    };

    public final List<TupleSlot> fullpattern;

    @Override
    public PMapQuadTable get() {
        return new PMapQuadTable(this.name());
    }

    private QuadTableForm(List<TupleSlot> fp) {
        this.fullpattern = fp;
    }

    @Override
    public boolean test(Set<TupleSlot> pattern) {
        for (int i = 4; i > 0; i = (int)((byte)(i - 1))) {
            EnumSet<TupleSlot> prefix = EnumSet.copyOf(this.fullpattern.subList(0, i));
            if (!prefix.equals(pattern)) continue;
            return true;
        }
        return false;
    }

    public static QuadTableForm chooseFrom(Set<TupleSlot> pattern) {
        return QuadTableForm.tableForms().filter(f -> f.test(pattern)).findFirst().orElse(GSPO);
    }

    public static Stream<QuadTableForm> tableForms() {
        return Arrays.stream(QuadTableForm.values());
    }
}

