/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.sparql.core.Var;

public final class JoinKey
implements Iterable<Var> {
    private static final JoinKey emptyKey = new JoinKey(Collections.emptyList());
    private final List<Var> keys;

    public static JoinKey create(Collection<Var> vars1, Collection<Var> vars2) {
        ArrayList<Var> intersection = new ArrayList<Var>();
        for (Var v : vars1) {
            if (!vars2.contains(v)) continue;
            intersection.add(v);
        }
        return new JoinKey(intersection);
    }

    public static JoinKey createVarKey(Collection<Var> vars1, Collection<Var> vars2) {
        for (Var v : vars1) {
            if (!vars2.contains(v)) continue;
            return JoinKey.create(v);
        }
        return emptyKey;
    }

    public static JoinKey create(Var var) {
        return new JoinKey(var);
    }

    private JoinKey(List<Var> _keys) {
        this.keys = _keys;
    }

    private JoinKey(Var var) {
        this.keys = Collections.singletonList(var);
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public int length() {
        return this.keys.size();
    }

    public Var getVarKey() {
        if (this.keys.isEmpty()) {
            return null;
        }
        return this.keys.get(0);
    }

    @Override
    public Iterator<Var> iterator() {
        return this.keys.iterator();
    }

    public String toString() {
        return this.keys.toString();
    }

    public static final class Builder {
        private List<Var> keys = new ArrayList<Var>();

        public boolean contains(Var var) {
            return this.keys.contains(var);
        }

        public Builder add(Var var) {
            if (!this.contains(var)) {
                this.keys.add(var);
            }
            return this;
        }

        public Builder remove(Var var) {
            this.keys.remove(var);
            return this;
        }

        public Builder clear() {
            this.keys.clear();
            return this;
        }

        public JoinKey build() {
            JoinKey joinKey = new JoinKey(new ArrayList<Var>(this.keys));
            return joinKey;
        }
    }
}

