/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl.validation;

import java.util.ArrayList;
import java.util.Collection;
import org.fcrepo.storage.ocfl.exception.ValidationException;

class Context {
    private final String ocflObjectId;
    private final Collection<String> problems;

    public Context() {
        this(null);
    }

    public Context(String ocflObjectId) {
        this.ocflObjectId = ocflObjectId;
        this.problems = new ArrayList<String>();
    }

    public void problem(String problem) {
        this.problems.add(problem);
    }

    public void problem(String format, Object ... args) {
        this.problems.add(String.format(format, args));
    }

    public Collection<String> getProblems() {
        return this.problems;
    }

    public void throwValidationException() {
        if (!this.problems.isEmpty()) {
            throw ValidationException.createForObject(this.ocflObjectId, this.problems);
        }
    }
}

