/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension;

import edu.wisc.library.ocfl.api.exception.OcflExtensionException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.FlatLayoutExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.FlatOmitPrefixLayoutExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.HashedNTupleIdEncapsulationLayoutExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.HashedNTupleLayoutExtension;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcflExtensionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(OcflExtensionRegistry.class);
    private static final Map<String, Class<? extends OcflExtension>> REGISTRY = new HashMap<String, Class<FlatOmitPrefixLayoutExtension>>(Map.of("0004-hashed-n-tuple-storage-layout", HashedNTupleLayoutExtension.class, "0003-hash-and-id-n-tuple-storage-layout", HashedNTupleIdEncapsulationLayoutExtension.class, "0002-flat-direct-storage-layout", FlatLayoutExtension.class, "0006-flat-omit-prefix-storage-layout", FlatOmitPrefixLayoutExtension.class));

    private OcflExtensionRegistry() {
    }

    public static void register(String extensionId, Class<? extends OcflExtension> extensionClass) {
        Enforce.notBlank(extensionId, "extensionId cannot be blank");
        Enforce.notNull(extensionClass, "extensionClass cannot be null");
        REGISTRY.put(extensionId, extensionClass);
    }

    public static void remove(String extensionName) {
        REGISTRY.remove(extensionName);
    }

    public static <T extends OcflExtension> Optional<T> lookup(String extensionName) {
        Class<? extends OcflExtension> extensionClass = REGISTRY.get(extensionName);
        LOG.debug("Found OCFL extension {} implementation {}", (Object)extensionName, (Object)extensionClass);
        if (extensionClass == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(extensionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e2) {
            throw new OcflExtensionException(String.format("Failed to load extension %s class %s.", extensionName, extensionClass), e2);
        }
    }

    public static boolean isSupported(String extensionName) {
        return REGISTRY.containsKey(extensionName);
    }
}

