/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension.storage.layout;

import edu.wisc.library.ocfl.api.exception.OcflExtensionException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.storage.layout.OcflStorageLayoutExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.config.HashedNTupleIdEncapsulationLayoutConfig;
import edu.wisc.library.ocfl.core.util.DigestUtil;
import edu.wisc.library.ocfl.core.util.PercentEscaper;

public class HashedNTupleIdEncapsulationLayoutExtension
implements OcflStorageLayoutExtension {
    public static final String EXTENSION_NAME = "0003-hash-and-id-n-tuple-storage-layout";
    private static final int MAX_LENGTH = 100;
    private static final String SEPARATOR = "-";
    private final PercentEscaper percentEscaper = PercentEscaper.builderWithSafeAlphaNumeric().addSafeChars("-_").plusForSpace(false).useUppercase(false).build();
    private HashedNTupleIdEncapsulationLayoutConfig config;

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    @Override
    public String getDescription() {
        return "OCFL object identifiers are hashed and encoded as lowercase hex strings. These digests are then divided into N n-tuple segments, which are used to create nested paths under the OCFL storage root. Finally, the OCFL object identifier is percent-encoded to create a directory name for the OCFL object root.";
    }

    @Override
    public synchronized void init(OcflExtensionConfig config) {
        if (this.config == null) {
            Enforce.notNull(config, "configFile cannot be null");
            if (!(config instanceof HashedNTupleIdEncapsulationLayoutConfig)) {
                throw new OcflExtensionException(String.format("This extension only supports %s configuration. Received: %s", this.getExtensionConfigClass(), config));
            }
            HashedNTupleIdEncapsulationLayoutConfig castConfig = (HashedNTupleIdEncapsulationLayoutConfig)config;
            HashedNTupleIdEncapsulationLayoutExtension.validateConfig(castConfig);
            this.config = castConfig;
        }
    }

    @Override
    public Class<? extends OcflExtensionConfig> getExtensionConfigClass() {
        return HashedNTupleIdEncapsulationLayoutConfig.class;
    }

    @Override
    public String mapObjectId(String objectId) {
        if (this.config == null) {
            throw new OcflExtensionException("This extension must be initialized before it can be used.");
        }
        String digest = DigestUtil.computeDigestHex(this.config.getDigestAlgorithm(), objectId, false);
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 0; i < this.config.getNumberOfTuples(); ++i) {
            int start = i * this.config.getTupleSize();
            int end = start + this.config.getTupleSize();
            pathBuilder.append(digest, start, end).append("/");
        }
        pathBuilder.append(this.encapsulationDirectory(objectId, digest));
        return pathBuilder.toString();
    }

    private String encapsulationDirectory(String objectId, String digest) {
        String escapedId = this.percentEscaper.escape(objectId);
        if (escapedId.length() <= 100) {
            return escapedId;
        }
        return escapedId.substring(0, 100) + SEPARATOR + digest;
    }

    private static void validateConfig(HashedNTupleIdEncapsulationLayoutConfig config) {
        if (config != null) {
            String testDigest;
            if (!(config.getTupleSize() != 0 && config.getNumberOfTuples() != 0 || config.getTupleSize() == 0 && config.getNumberOfTuples() == 0)) {
                throw new OcflExtensionException(String.format("If tupleSize (=%s) or numberOfTuples (=%s) is set to 0, then both must be 0.", config.getTupleSize(), config.getNumberOfTuples()));
            }
            int totalTupleChars = config.getTupleSize() * config.getNumberOfTuples();
            if (totalTupleChars > (testDigest = DigestUtil.computeDigestHex(config.getDigestAlgorithm(), "test")).length()) {
                throw new OcflExtensionException(String.format("The config tupleSize=%s and numberOfTuples=%s requires a minimum of %s characters, but %s digests only have %s characters.", config.getTupleSize(), config.getNumberOfTuples(), totalTupleChars, config.getDigestAlgorithm().getOcflName(), testDigest.length()));
            }
        }
    }
}

