/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutionContext<R> {
    volatile Duration startTime = Duration.ZERO;
    volatile Duration attemptStartTime = Duration.ZERO;
    AtomicInteger attempts = new AtomicInteger();
    AtomicInteger executions = new AtomicInteger();
    volatile int cancelledIndex;
    volatile R lastResult;
    volatile Throwable lastFailure;

    ExecutionContext() {
    }

    private ExecutionContext(ExecutionContext<R> context2) {
        this.startTime = context2.startTime;
        this.attemptStartTime = context2.attemptStartTime;
        this.attempts = context2.attempts;
        this.executions = context2.executions;
        this.cancelledIndex = context2.cancelledIndex;
        this.lastResult = context2.lastResult;
        this.lastFailure = context2.lastFailure;
    }

    public Duration getElapsedTime() {
        return Duration.ofNanos(System.nanoTime() - this.startTime.toNanos());
    }

    public Duration getElapsedAttemptTime() {
        return Duration.ofNanos(System.nanoTime() - this.attemptStartTime.toNanos());
    }

    public int getAttemptCount() {
        return this.attempts.get();
    }

    public int getExecutionCount() {
        return this.executions.get();
    }

    public <T extends Throwable> T getLastFailure() {
        return (T)this.lastFailure;
    }

    public R getLastResult() {
        return this.lastResult;
    }

    public R getLastResult(R defaultValue) {
        return this.lastResult != null ? this.lastResult : defaultValue;
    }

    public Duration getStartTime() {
        return this.startTime;
    }

    public boolean isCancelled() {
        return this.cancelledIndex != 0;
    }

    public boolean isFirstAttempt() {
        return this.attempts.get() == 0;
    }

    public boolean isRetry() {
        return this.attempts.get() > 0;
    }

    public ExecutionContext<R> copy() {
        return new ExecutionContext<R>(this);
    }

    static <R> ExecutionContext<R> ofResult(R result) {
        ExecutionContext<R> context2 = new ExecutionContext<R>();
        context2.lastResult = result;
        return context2;
    }

    static <R> ExecutionContext<R> ofFailure(Throwable failure) {
        ExecutionContext<R> context2 = new ExecutionContext<R>();
        context2.lastFailure = failure;
        return context2;
    }

    public String toString() {
        return "ExecutionContext[attempts=" + this.attempts + ", executions=" + this.executions + ", lastResult=" + this.lastResult + ", lastFailure=" + this.lastFailure + ']';
    }
}

