/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.FailurePolicy;
import net.jodah.failsafe.FallbackExecutor;
import net.jodah.failsafe.Functions;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.function.CheckedConsumer;
import net.jodah.failsafe.function.CheckedFunction;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.function.CheckedSupplier;
import net.jodah.failsafe.internal.EventListener;
import net.jodah.failsafe.internal.util.Assert;

public class Fallback<R>
extends FailurePolicy<Fallback<R>, R> {
    public static final Fallback<Void> VOID = new Fallback();
    private final CheckedFunction<ExecutionAttemptedEvent, R> fallback;
    private final CheckedFunction<ExecutionAttemptedEvent, CompletableFuture<R>> fallbackStage;
    private final boolean async;
    private EventListener failedAttemptListener;

    private Fallback() {
        this(null, null, false);
    }

    private Fallback(CheckedFunction<ExecutionAttemptedEvent, R> fallback, CheckedFunction<ExecutionAttemptedEvent, CompletableFuture<R>> fallbackStage, boolean async) {
        this.fallback = fallback;
        this.fallbackStage = fallbackStage;
        this.async = async;
    }

    public static <R> Fallback<R> of(CheckedRunnable fallback) {
        return new Fallback<CheckedRunnable>(Functions.toFn(Assert.notNull(fallback, "fallback")), null, false);
    }

    public static <R> Fallback<R> of(CheckedSupplier<? extends R> fallback) {
        return new Fallback<CheckedSupplier<? extends R>>(Functions.toFn(Assert.notNull(fallback, "fallback")), null, false);
    }

    public static <R> Fallback<R> of(CheckedConsumer<ExecutionAttemptedEvent<? extends R>> fallback) {
        return new Fallback<CheckedConsumer<ExecutionAttemptedEvent<? extends R>>>(Functions.toFn(Assert.notNull(fallback, "fallback")), null, false);
    }

    public static <R> Fallback<R> of(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends R> fallback) {
        return new Fallback<R>(Assert.notNull(fallback, "fallback"), null, false);
    }

    public static <R> Fallback<R> ofException(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends Exception> fallback) {
        Assert.notNull(fallback, "fallback");
        return new Fallback<Object>(e2 -> {
            throw (Exception)fallback.apply((ExecutionAttemptedEvent)e2);
        }, null, false);
    }

    public static <R> Fallback<R> of(R fallbackResult) {
        return new Fallback<R>(Functions.toFn(fallbackResult), null, false);
    }

    public static <R> Fallback<R> ofAsync(CheckedRunnable fallback) {
        return new Fallback<CheckedRunnable>(Functions.toFn(Assert.notNull(fallback, "fallback")), null, true);
    }

    public static <R> Fallback<R> ofAsync(CheckedSupplier<? extends R> fallback) {
        return new Fallback<CheckedSupplier<? extends R>>(Functions.toFn(Assert.notNull(fallback, "fallback")), null, true);
    }

    public static <R> Fallback<R> ofAsync(CheckedConsumer<ExecutionAttemptedEvent<? extends R>> fallback) {
        return new Fallback<CheckedConsumer<ExecutionAttemptedEvent<? extends R>>>(Functions.toFn(Assert.notNull(fallback, "fallback")), null, true);
    }

    public static <R> Fallback<R> ofAsync(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends R> fallback) {
        return new Fallback<R>(Assert.notNull(fallback, "fallback"), null, true);
    }

    public static <R> Fallback<R> ofStage(CheckedSupplier<? extends CompletionStage<R>> fallback) {
        return new Fallback<CompletionStage<R>>(null, Functions.toFn(Assert.notNull(fallback, "fallback")), false);
    }

    public static <R> Fallback<R> ofStage(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends CompletionStage<R>> fallback) {
        return new Fallback<R>(null, Assert.notNull(fallback, "fallback"), false);
    }

    public static <R> Fallback<R> ofStageAsync(CheckedSupplier<? extends CompletionStage<R>> fallback) {
        return new Fallback<CompletionStage<R>>(null, Functions.toFn(Assert.notNull(fallback, "fallback")), true);
    }

    public static <R> Fallback<R> ofStageAsync(CheckedFunction<ExecutionAttemptedEvent<? extends R>, ? extends CompletionStage<R>> fallback) {
        return new Fallback<R>(null, Assert.notNull(fallback, "fallback"), true);
    }

    public boolean isAsync() {
        return this.async;
    }

    public Fallback<R> onFailedAttempt(CheckedConsumer<? extends ExecutionAttemptedEvent<R>> listener) {
        this.failedAttemptListener = EventListener.ofAttempt(Assert.notNull(listener, "listener"));
        return this;
    }

    R apply(R result, Throwable failure, ExecutionContext context2) throws Throwable {
        ExecutionAttemptedEvent<R> event = new ExecutionAttemptedEvent<R>(result, failure, context2);
        return this.fallback != null ? this.fallback.apply(event) : this.fallbackStage.apply(event).get();
    }

    CompletableFuture<R> applyStage(R result, Throwable failure, ExecutionContext context2) throws Throwable {
        ExecutionAttemptedEvent<R> event = new ExecutionAttemptedEvent<R>(result, failure, context2);
        return this.fallback != null ? CompletableFuture.completedFuture(this.fallback.apply(event)) : this.fallbackStage.apply(event);
    }

    @Override
    public PolicyExecutor toExecutor(AbstractExecution execution) {
        return new FallbackExecutor(this, execution, this.failedAttemptListener);
    }
}

