/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.assemblers.RuleSetAssembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.assembler.exceptions.CannotHaveRulesException;
import org.apache.jena.assembler.exceptions.NotExpectedTypeException;
import org.apache.jena.assembler.exceptions.UnknownReasonerException;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.ReasonerRegistry;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import org.apache.jena.reasoner.rulesys.Rule;

public class ReasonerFactoryAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root2, Mode irrelevant) {
        this.checkType(root2, JA.ReasonerFactory);
        return this.addSchema(root2, a, this.addRules(root2, a, ReasonerFactoryAssembler.getReasonerFactory(root2)));
    }

    private ReasonerFactory addSchema(Resource root2, Assembler a, final ReasonerFactory rf) {
        if (root2.hasProperty(JA.ja_schema)) {
            final Graph schema = this.loadSchema(root2, a);
            return new ReasonerFactory(){

                @Override
                public Reasoner create(Resource configuration) {
                    return rf.create(configuration).bindSchema(schema);
                }

                @Override
                public Model getCapabilities() {
                    return rf.getCapabilities();
                }

                @Override
                public String getURI() {
                    return rf.getURI();
                }
            };
        }
        return rf;
    }

    private Graph loadSchema(Resource root2, Assembler a) {
        Graph result = Factory.createDefaultGraph();
        StmtIterator models = root2.listProperties(JA.ja_schema);
        while (models.hasNext()) {
            this.loadSchema(result, a, ReasonerFactoryAssembler.getResource(models.nextStatement()));
        }
        return result;
    }

    private void loadSchema(Graph result, Assembler a, Resource root2) {
        Model m4 = a.openModel(root2);
        GraphUtil.addInto(result, m4.getGraph());
    }

    private ReasonerFactory addRules(Resource root2, Assembler a, final ReasonerFactory r) {
        final List<Rule> rules = RuleSetAssembler.addRules(new ArrayList<Rule>(), a, root2);
        if (rules.size() > 0) {
            if (r instanceof GenericRuleReasonerFactory) {
                return new ReasonerFactory(){

                    @Override
                    public Reasoner create(Resource configuration) {
                        GenericRuleReasoner result = (GenericRuleReasoner)r.create(configuration);
                        result.addRules(rules);
                        return result;
                    }

                    @Override
                    public Model getCapabilities() {
                        return r.getCapabilities();
                    }

                    @Override
                    public String getURI() {
                        return r.getURI();
                    }
                };
            }
            throw new CannotHaveRulesException(root2);
        }
        return r;
    }

    protected Reasoner getReasoner(Resource root2) {
        return ReasonerFactoryAssembler.getReasonerFactory(root2).create(root2);
    }

    protected static ReasonerFactory getReasonerFactory(Resource root2) {
        Resource reasonerURL = ReasonerFactoryAssembler.getUniqueResource(root2, JA.reasonerURL);
        String className = ReasonerFactoryAssembler.getOptionalClassName(root2);
        return className != null ? ReasonerFactoryAssembler.getReasonerFactoryByClassName(root2, className) : (reasonerURL == null ? GenericRuleReasonerFactory.theInstance() : ReasonerFactoryAssembler.getReasonerFactoryByURL(root2, reasonerURL));
    }

    private static ReasonerFactory getReasonerFactoryByClassName(Resource root2, String className) {
        Class<?> c = ReasonerFactoryAssembler.loadClass(root2, className);
        ReasonerFactoryAssembler.mustBeReasonerFactory(root2, c);
        ReasonerFactory theInstance = ReasonerFactoryAssembler.resultFromStatic(c, "theInstance");
        return theInstance == null ? ReasonerFactoryAssembler.createInstance(root2, c) : theInstance;
    }

    private static ReasonerFactory createInstance(Resource root2, Class<?> c) {
        try {
            return (ReasonerFactory)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new AssemblerException(root2, "could not create instance of " + c.getName(), e2);
        }
    }

    private static ReasonerFactory resultFromStatic(Class<?> c, String methodName) {
        try {
            return (ReasonerFactory)c.getMethod(methodName, null).invoke(null, (Object[])null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static void mustBeReasonerFactory(Resource root2, Class<?> c) {
        if (!ReasonerFactory.class.isAssignableFrom(c)) {
            throw new NotExpectedTypeException(root2, ReasonerFactory.class, c);
        }
    }

    private static String getOptionalClassName(Resource root2) {
        return ReasonerFactoryAssembler.getOptionalClassName(root2, JA.reasonerClass);
    }

    public static ReasonerFactory getReasonerFactoryByURL(Resource root2, Resource reasonerURL) {
        String url = reasonerURL.getURI();
        ReasonerFactory factory = ReasonerRegistry.theRegistry().getFactory(url);
        if (factory == null) {
            throw new UnknownReasonerException(root2, reasonerURL);
        }
        return factory;
    }
}

