/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.HashCommon;
import org.apache.jena.mem.TripleBunch;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class SetBunch
implements TripleBunch {
    protected Set<Triple> elements = new HashSet<Triple>(20);

    public SetBunch(TripleBunch b) {
        ExtendedIterator<Triple> it = b.iterator();
        while (it.hasNext()) {
            this.elements.add((Triple)it.next());
        }
    }

    protected static boolean equalsObjectOK(Triple t2) {
        Node o = t2.getObject();
        return o.isLiteral() ? o.getLiteralDatatype() == null : true;
    }

    @Override
    public boolean contains(Triple t2) {
        return this.elements.contains(t2);
    }

    @Override
    public boolean containsBySameValueAs(Triple t2) {
        return SetBunch.equalsObjectOK(t2) ? this.elements.contains(t2) : this.slowContains(t2);
    }

    protected boolean slowContains(Triple t2) {
        for (Triple element : this.elements) {
            if (!t2.matches(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public void add(Triple t2) {
        this.elements.add(t2);
    }

    @Override
    public void remove(Triple t2) {
        this.elements.remove(t2);
    }

    @Override
    public ExtendedIterator<Triple> iterator(HashCommon.NotifyEmpty container2) {
        return this.iterator();
    }

    @Override
    public ExtendedIterator<Triple> iterator() {
        return WrappedIterator.create(this.elements.iterator());
    }
}

