/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.CardinalityRestriction;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.RestrictionImpl;

public class CardinalityRestrictionImpl
extends RestrictionImpl
implements CardinalityRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new CardinalityRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to CardinalityRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile2 = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile2 != null && profile2.isSupported(node, eg, CardinalityRestriction.class);
        }
    };

    public CardinalityRestrictionImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setCardinality(int cardinality) {
        this.setPropertyValue(this.getProfile().CARDINALITY(), "CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public int getCardinality() {
        return this.objectAsInt(this.getProfile().CARDINALITY(), "CARDINALITY");
    }

    @Override
    public boolean hasCardinality(int cardinality) {
        return this.hasPropertyValue(this.getProfile().CARDINALITY(), "CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public void removeCardinality(int cardinality) {
        this.removePropertyValue(this.getProfile().CARDINALITY(), "CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }
}

