/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.Builtin;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.impl.RETEEngine;
import org.apache.jena.util.iterator.ClosableIterator;

public class RETERuleContext
implements RuleContext {
    protected BindingEnvironment env;
    protected Rule rule;
    protected ForwardRuleInfGraphI graph;
    protected RETEEngine engine;

    public RETERuleContext(ForwardRuleInfGraphI graph, RETEEngine engine) {
        this.graph = graph;
        this.engine = engine;
    }

    @Override
    public BindingEnvironment getEnv() {
        return this.env;
    }

    @Override
    public InfGraph getGraph() {
        return this.graph;
    }

    public RETEEngine getEngine() {
        return this.engine;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void setEnv(BindingEnvironment env) {
        this.env = env;
    }

    @Override
    public boolean contains(Triple t2) {
        return this.contains(t2.getSubject(), t2.getPredicate(), t2.getObject());
    }

    @Override
    public boolean contains(Node s2, Node p, Node o) {
        ClosableIterator<Triple> it = this.find(s2, p, o);
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    @Override
    public ClosableIterator<Triple> find(Node s2, Node p, Node o) {
        return this.graph.findDataMatches(s2, p, o);
    }

    @Override
    public void silentAdd(Triple t2) {
        this.graph.silentAdd(t2);
    }

    @Override
    public void remove(Triple t2) {
        this.graph.getRawGraph().delete(t2);
        this.engine.deleteTriple(t2, true);
    }

    @Override
    public void add(Triple t2) {
        this.engine.addTriple(t2, true);
    }

    public boolean shouldFire(boolean allowUnsafe) {
        for (int i = 0; i < this.rule.bodyLength(); ++i) {
            ClauseEntry clause = this.rule.getBodyElement(i);
            if (!(clause instanceof Functor) || !(allowUnsafe ? !((Functor)clause).evalAsBodyClause(this) : !((Functor)clause).safeEvalAsBodyClause(this))) continue;
            return false;
        }
        return true;
    }

    public boolean shouldStillFire() {
        for (int i = 0; i < this.rule.bodyLength(); ++i) {
            Builtin builtin;
            ClauseEntry clause = this.rule.getBodyElement(i);
            if (!(clause instanceof Functor) || (builtin = ((Functor)clause).getImplementor()) == null || builtin.isMonotonic() || ((Functor)clause).evalAsBodyClause(this)) continue;
            return false;
        }
        return true;
    }
}

