/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.transitiveReasoner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.transitiveReasoner.GraphNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.util.iterator.SingletonIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class TransitiveGraphCache
implements Finder {
    protected boolean cacheTriples = false;
    protected HashMap<Node, GraphNode> nodeMap = new HashMap();
    protected Node directPredicate;
    protected Node closedPredicate;
    protected Set<Triple> deletesPending;
    protected Set<Triple> originalTriples = new HashSet<Triple>();

    public TransitiveGraphCache(Node directPredicate, Node closedPredicate) {
        this.directPredicate = directPredicate;
        this.closedPredicate = closedPredicate;
    }

    public Node getClosedPredicate() {
        return this.closedPredicate;
    }

    public Node getDirectPredicate() {
        return this.directPredicate;
    }

    public synchronized void addRelation(Triple t2) {
        this.originalTriples.add(t2);
        this.addRelation(t2.getSubject(), t2.getObject());
    }

    private void addRelation(Node start, Node end) {
        GraphNode endN;
        if (start.equals(end)) {
            return;
        }
        GraphNode startN = this.getLead(start);
        if (startN.pathTo(endN = this.getLead(end))) {
            return;
        }
        boolean needJoin = endN.pathTo(startN);
        HashSet<GraphNode> members = null;
        if (needJoin) {
            members = new HashSet<GraphNode>();
            members.add(endN);
            startN.visitPredecessors(new Visitor<Set<GraphNode>, GraphNode>(){

                @Override
                public List<GraphNode> visit(GraphNode node, GraphNode processing, Set<GraphNode> members, GraphNode endN) {
                    if (endN.pathTo(node)) {
                        members.add(node);
                    }
                    return null;
                }
            }, members, endN);
            startN.makeLeadNodeFor(members);
            startN.propagateSCC();
        } else {
            startN.propagateAdd(endN);
            startN.assertLinkTo(endN);
        }
        if (needJoin) {
            // empty if block
        }
    }

    public void removeRelation(Triple t2) {
        GraphNode endN;
        Node end;
        Node start = t2.getSubject();
        if (start == (end = t2.getObject())) {
            return;
        }
        GraphNode startN = this.getLead(start);
        if (startN != (endN = this.getLead(end)) && !startN.directPathTo(endN)) {
            return;
        }
        if (this.deletesPending == null) {
            this.deletesPending = new HashSet<Triple>();
        }
        this.deletesPending.add(t2);
    }

    private void processDeletes() {
        HashSet<GraphNode> kernel = new HashSet<GraphNode>();
        for (Triple t2 : this.deletesPending) {
            GraphNode start = this.nodeMap.get(t2.getSubject());
            kernel.add(start);
        }
        HashSet<GraphNode> pKernel = new HashSet<GraphNode>();
        pKernel.addAll(kernel);
        block1: for (GraphNode n : this.nodeMap.values()) {
            for (GraphNode target : kernel) {
                if (!n.pathTo(target)) continue;
                pKernel.add(n);
                continue block1;
            }
        }
        for (GraphNode n : pKernel) {
            for (GraphNode fringe : n.succ) {
                if (pKernel.contains(fringe)) continue;
                fringe.pred.remove(n);
            }
            n.succ.clear();
            n.succClosed.clear();
            n.pred.clear();
        }
        this.originalTriples.removeAll(this.deletesPending);
        this.deletesPending.clear();
        for (Triple t3 : this.originalTriples) {
            GraphNode n = this.nodeMap.get(t3.getSubject());
            if (!pKernel.contains(n)) continue;
            this.addRelation(t3);
        }
    }

    @Override
    public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation) {
        Node p = pattern.getPredicate();
        if (p.isVariable()) {
            return this.find(pattern).andThen(continuation.find(pattern));
        }
        if (p.equals(this.directPredicate) || p.equals(this.closedPredicate)) {
            return this.find(pattern);
        }
        return continuation.find(pattern);
    }

    @Override
    public boolean contains(TriplePattern pattern) {
        ExtendedIterator<Triple> it = this.find(pattern);
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    public ExtendedIterator<Node> listAllSubjects() {
        return WrappedIterator.create(this.nodeMap.keySet().iterator());
    }

    public boolean isSubject(Node node) {
        return this.nodeMap.keySet().contains(node);
    }

    public boolean cacheAll(Finder graph, Node predicate) {
        ExtendedIterator<Triple> it = graph.find(new TriplePattern(null, predicate, null));
        boolean foundsome = it.hasNext();
        while (it.hasNext()) {
            this.addRelation((Triple)it.next());
        }
        it.close();
        return foundsome;
    }

    @Override
    public ExtendedIterator<Triple> find(TriplePattern pattern) {
        if (this.deletesPending != null && this.deletesPending.size() > 0) {
            this.processDeletes();
        }
        Node s2 = pattern.getSubject();
        Node p = pattern.getPredicate();
        Node o = pattern.getObject();
        if (p.isVariable() || p.equals(this.directPredicate) || p.equals(this.closedPredicate)) {
            boolean closed = !p.equals(this.directPredicate);
            Node pred = this.closedPredicate;
            if (s2.isVariable()) {
                if (o.isVariable()) {
                    return new FullGraphWalker(closed, this.closedPredicate, this.nodeMap);
                }
                GraphNode gn_o = this.nodeMap.get(o);
                if (gn_o == null) {
                    return NullIterator.instance();
                }
                return gn_o.listPredecessorTriples(closed, this);
            }
            GraphNode gn_s = this.nodeMap.get(s2);
            if (gn_s == null) {
                return NullIterator.instance();
            }
            if (o.isVariable()) {
                return gn_s.listTriples(closed, this);
            }
            GraphNode gn_o = this.nodeMap.get(o);
            gn_s = gn_s.leadNode();
            if (gn_o == null) {
                return NullIterator.instance();
            }
            gn_o = gn_o.leadNode();
            if (closed ? gn_s.pathTo(gn_o) : gn_s.directPathTo(gn_o)) {
                return new SingletonIterator<Triple>(new Triple(s2, pred, o));
            }
            return NullIterator.instance();
        }
        return NullIterator.instance();
    }

    public TransitiveGraphCache deepCopy() {
        TransitiveGraphCache copy = new TransitiveGraphCache(this.directPredicate, this.closedPredicate);
        ExtendedIterator<Triple> i = this.find(new TriplePattern(null, this.directPredicate, null));
        while (i.hasNext()) {
            Triple t2 = (Triple)i.next();
            copy.addRelation(t2.getSubject(), t2.getObject());
        }
        return copy;
    }

    public void clear() {
        this.nodeMap.clear();
    }

    public void setCaching(boolean enable) {
        if (!enable && this.cacheTriples) {
            for (GraphNode graphNode : this.nodeMap.values()) {
                graphNode.clearTripleCache();
            }
        }
        this.cacheTriples = enable;
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        for (GraphNode n : this.nodeMap.values()) {
            sb.append(n.dump());
            sb.append("\n");
        }
        return sb.toString();
    }

    private GraphNode getLead(Node n) {
        GraphNode gn = this.nodeMap.get(n);
        if (gn == null) {
            gn = new GraphNode(n);
            this.nodeMap.put(n, gn);
            return gn;
        }
        return gn.leadNode();
    }

    private static class FullGraphWalker
    extends NiceIterator<Triple>
    implements ExtendedIterator<Triple> {
        boolean closed;
        Iterator<GraphNode> baseNodeIt;
        GraphNode node;
        Node nodeN;
        Node predicate;
        Iterator<GraphNode> succIt = null;
        GraphNode succ;
        Iterator<GraphNode> aliasesIt = null;
        Triple next;

        FullGraphWalker(boolean closed, Node predicate, HashMap<Node, GraphNode> nodes) {
            this.predicate = predicate;
            this.closed = closed;
            this.baseNodeIt = nodes.values().iterator();
            this.walkOne();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Triple next() {
            Triple toReturn = this.next;
            this.walkOne();
            return toReturn;
        }

        protected void walkOne() {
            if (this.aliasesIt != null) {
                while (this.aliasesIt.hasNext()) {
                    GraphNode al = this.aliasesIt.next();
                    if (al == this.succ || al == this.node) continue;
                    this.next = new Triple(this.nodeN, this.predicate, al.rdfNode);
                    return;
                }
                this.aliasesIt = null;
            }
            if (this.succIt != null) {
                while (this.succIt.hasNext()) {
                    this.succ = this.succIt.next();
                    if (this.succ == this.node) continue;
                    this.aliasesIt = this.succ.siblingIterator();
                    this.next = new Triple(this.nodeN, this.predicate, this.succ.rdfNode);
                    return;
                }
                this.succIt = null;
            }
            if (this.baseNodeIt.hasNext()) {
                this.node = this.baseNodeIt.next();
                this.nodeN = this.node.rdfNode;
                GraphNode lead = this.node.leadNode();
                this.succIt = (this.closed ? lead.succClosed : lead.succ).iterator();
                this.succIt = lead.concatenateSiblings(this.succIt);
                this.next = new Triple(this.nodeN, this.predicate, this.nodeN);
            } else {
                this.next = null;
            }
        }
    }

    static class GraphWalker
    extends NiceIterator<Triple>
    implements ExtendedIterator<Triple> {
        boolean isDeep;
        GraphNode node;
        Node root;
        Node predicate;
        Iterator<GraphNode> iterator = null;
        Iterator<GraphNode> aliasIterator = null;
        ArrayList<GraphNode> nodeStack = new ArrayList();
        ArrayList<Iterator<GraphNode>> iteratorStack = new ArrayList();
        Triple next;
        HashSet<GraphNode> visited = new HashSet();

        GraphWalker(GraphNode node, Node rdfNode, boolean closed, Node predicate) {
            this.isDeep = closed;
            this.node = node;
            this.root = rdfNode;
            this.predicate = predicate;
            this.iterator = node.pred.iterator();
            this.aliasIterator = node.siblingIterator();
            this.next = new Triple(this.root, predicate, this.root);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Triple next() {
            Triple toReturn = this.next;
            this.walkOne();
            return toReturn;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void walkOne() {
            if (this.aliasIterator != null) {
                if (this.aliasIterator.hasNext()) {
                    GraphNode nextNode = this.aliasIterator.next();
                    this.next = new Triple(nextNode.rdfNode, this.predicate, this.root);
                    return;
                }
                this.aliasIterator = null;
            }
            if (this.iterator.hasNext()) {
                GraphNode nextNode = this.iterator.next();
                if (!this.visited.add(nextNode)) {
                    this.walkOne();
                    return;
                }
                if (this.isDeep) {
                    this.pushStack(nextNode);
                }
                this.next = new Triple(nextNode.rdfNode, this.predicate, this.root);
                this.aliasIterator = nextNode.siblingIterator();
                return;
            }
            if (this.nodeStack.isEmpty()) {
                this.next = null;
                return;
            }
            this.popStack();
            this.walkOne();
        }

        protected void pushStack(GraphNode next) {
            this.nodeStack.add(this.node);
            this.iteratorStack.add(this.iterator);
            this.iterator = next.pred.iterator();
            this.node = next;
        }

        protected void popStack() {
            int i = this.nodeStack.size() - 1;
            this.iterator = this.iteratorStack.remove(i);
            this.node = this.nodeStack.remove(i);
        }
    }

    static interface Visitor<Alpha, Beta> {
        public List<GraphNode> visit(GraphNode var1, GraphNode var2, Alpha var3, Beta var4);
    }
}

