/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.other;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.other.StreamRDFBatchHandler;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;

public class BatchedStreamRDF
implements StreamRDF {
    private final StreamRDFBatchHandler batchProc;
    private Node currentSubject = null;
    private Node currentGraph = null;
    private List<Triple> batchTriples = null;
    private List<Quad> batchQuads = null;

    public BatchedStreamRDF(StreamRDFBatchHandler batchProc) {
        this.batchProc = batchProc;
    }

    @Override
    public final void start() {
        this.currentSubject = null;
        this.currentGraph = null;
        this.batchTriples = null;
        this.batchQuads = null;
        this.batchProc.start();
    }

    @Override
    public void triple(Triple triple) {
        Node s2 = triple.getSubject();
        if (!Objects.equals(s2, this.currentSubject)) {
            if (this.currentSubject != null) {
                this.finishBatchTriple(this.currentSubject);
            }
            this.startBatchTriple(s2);
            this.currentGraph = null;
            this.currentSubject = s2;
        }
        this.processTriple(triple);
    }

    private void startBatchTriple(Node subject) {
        this.batchTriples = new ArrayList<Triple>();
    }

    private void finishBatchTriple(Node subject) {
        if (this.batchTriples != null && this.batchTriples.size() > 0) {
            this.batchProc.batchTriples(this.currentSubject, this.batchTriples);
        }
    }

    private void processTriple(Triple triple) {
        this.batchTriples.add(triple);
    }

    @Override
    public void quad(Quad quad) {
        Node g2 = quad.getGraph();
        Node s2 = quad.getSubject();
        if (!Objects.equals(g2, this.currentGraph) || !Objects.equals(s2, this.currentSubject)) {
            if (this.currentSubject != null) {
                this.finishBatchQuad(this.currentGraph, this.currentSubject);
            }
            this.startBatchQuad(g2, s2);
            this.currentGraph = g2;
            this.currentSubject = s2;
        }
        this.processQuad(quad);
    }

    private void startBatchQuad(Node graph, Node subject) {
        this.batchQuads = new ArrayList<Quad>();
    }

    private void finishBatchQuad(Node graph, Node subject) {
        if (this.batchQuads != null && this.batchQuads.size() > 0) {
            this.batchProc.batchQuads(this.currentGraph, this.currentSubject, this.batchQuads);
        }
    }

    private void processQuad(Quad Quad2) {
        this.batchQuads.add(Quad2);
    }

    private void flush() {
        this.finishBatchTriple(this.currentSubject);
        this.finishBatchQuad(this.currentGraph, this.currentSubject);
    }

    @Override
    public final void finish() {
        this.flush();
        this.batchProc.finish();
    }

    @Override
    public void base(String base) {
        this.batchProc.base(base);
    }

    @Override
    public void prefix(String prefix, String iri) {
        this.batchProc.prefix(prefix, iri);
    }
}

