/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.join.JoinKey;

class JoinLib {
    static final boolean JOIN_EXPLAIN = false;
    public static final Object noKeyHash = new Object();
    public static final long nullHashCode = 5L;

    JoinLib() {
    }

    public static long hash(Var v, Node x) {
        long h2 = 17L;
        if (v != null) {
            h2 ^= (long)v.hashCode();
        }
        if (x != null) {
            h2 ^= (long)x.hashCode();
        }
        return h2;
    }

    public static Object hash(JoinKey joinKey, Binding row) {
        long x = 31L;
        boolean seenJoinKeyVar = false;
        for (Var v : joinKey) {
            Node value = row.get(v);
            long h2 = 5L;
            if (value != null) {
                seenJoinKeyVar = true;
                h2 = JoinLib.hash(v, value);
            }
            x ^= h2;
        }
        if (!seenJoinKeyVar) {
            return noKeyHash;
        }
        return x;
    }
}

