/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers.ocfl;

import at.favre.lib.bytes.Bytes;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.fcrepo.migration.ContentDigest;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.FedoraObjectVersionHandler;
import org.fcrepo.migration.MigrationType;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectVersionReference;
import org.fcrepo.migration.ResourceMigrationType;
import org.fcrepo.migration.handlers.ocfl.OcflObjectSessionWrapper;
import org.fcrepo.storage.ocfl.InteractionModel;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.exception.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveGroupHandler
implements FedoraObjectVersionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveGroupHandler.class);
    private static final String FCREPO_ROOT = "info:fedora/";
    private static final String FCRMETA_SUFFIX = "/fcr:metadata";
    private static final Map<String, String> externalHandlingMap = Map.of("E", "proxy", "R", "redirect");
    private static final String INLINE_XML = "X";
    private static final String DS_INACTIVE = "I";
    private static final String DS_DELETED = "D";
    private static final String OBJ_STATE_PROP = "info:fedora/fedora-system:def/model#state";
    private static final String DOWNLOAD_NAME_PROP = "info:fedora/fedora-system:def/model#downloadFilename";
    private static final String OBJ_INACTIVE = "Inactive";
    private static final String OBJ_DELETED = "Deleted";
    private static final String RELS_EXT = "RELS-EXT";
    private static final String RELS_INT = "RELS-INT";
    private final OcflObjectSessionFactory sessionFactory;
    private final boolean addDatastreamExtensions;
    private final boolean deleteInactive;
    private final boolean foxmlFile;
    private final MigrationType migrationType;
    private final ResourceMigrationType resourceMigrationType;
    private final String user;
    private final String idPrefix;
    private final Detector mimeDetector;
    private final boolean disableChecksumValidation;

    public ArchiveGroupHandler(OcflObjectSessionFactory sessionFactory, MigrationType migrationType, ResourceMigrationType resourceMigrationType, boolean addDatastreamExtensions, boolean deleteInactive, boolean foxmlFile, String user, String idPrefix, boolean disableChecksumValidation) {
        this.sessionFactory = Preconditions.checkNotNull(sessionFactory, "sessionFactory cannot be null");
        this.migrationType = Preconditions.checkNotNull(migrationType, "migrationType cannot be null");
        this.resourceMigrationType = Preconditions.checkNotNull(resourceMigrationType, "resourceMigrationType cannot be null");
        this.addDatastreamExtensions = addDatastreamExtensions;
        this.deleteInactive = deleteInactive;
        this.foxmlFile = foxmlFile;
        this.user = Preconditions.checkNotNull(Strings.emptyToNull(user), "user cannot be blank");
        this.idPrefix = idPrefix;
        this.disableChecksumValidation = disableChecksumValidation;
        try {
            this.mimeDetector = new TikaConfig().getDetector();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void processObjectVersions(Iterable<ObjectVersionReference> versions, ObjectInfo objectInfo) {
        String objectId = objectInfo.getPid();
        String f6ObjectId = this.idPrefix + objectId;
        HashMap<String, String> dsCreateDates = new HashMap<String, String>();
        String objectState = null;
        HashMap<String, String> datastreamStates = new HashMap<String, String>();
        HashMap<String, MetaHolder> metaMap = new HashMap<String, MetaHolder>();
        HashMap<String, BinaryMeta> binaryMeta = new HashMap<String, BinaryMeta>();
        HashMap<String, String> filenameMap = new HashMap<String, String>();
        for (ObjectVersionReference ov : versions) {
            OcflObjectSession objectSession;
            HashMap<String, String> relsDeletedFilenames;
            HashSet<String> relsFilenameUpdates;
            HashSet<String> toWrite;
            block25: {
                toWrite = new HashSet<String>();
                relsFilenameUpdates = new HashSet<String>();
                relsDeletedFilenames = new HashMap<String, String>();
                objectSession = this.newSession(f6ObjectId);
                if (ov.isFirstVersion()) {
                    if (objectSession.containsResource(f6ObjectId)) {
                        throw new RuntimeException(f6ObjectId + " already exists!");
                    }
                    objectState = this.getObjectState(ov, objectId);
                    if (this.foxmlFile) {
                        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(objectInfo.getFoxmlPath(), new OpenOption[0]));){
                            String foxmlDsId = f6ObjectId + "/FOXML";
                            ResourceHeaders headers = this.createHeaders(foxmlDsId, f6ObjectId, InteractionModel.NON_RDF).build();
                            objectSession.writeResource(headers, is);
                            datastreamStates.put(foxmlDsId, DS_DELETED);
                            break block25;
                        }
                        catch (IOException io) {
                            LOGGER.error("error writing " + objectId + " FOXML file to " + f6ObjectId + ": " + io);
                            throw new UncheckedIOException(io);
                        }
                    }
                    ResourceHeaders.Builder objectHeaders = this.createObjectHeaders(f6ObjectId, ov);
                    Model content = ArchiveGroupHandler.getObjTriples(ov, objectId);
                    MetaHolder meta = MetaHolder.fromContent(content, objectHeaders);
                    metaMap.put(f6ObjectId, meta);
                    objectSession.writeResource(meta.headers.build(), meta.constructTriples());
                }
            }
            HashMap<String, OcflObjectSession> datastreamSessions = new HashMap<String, OcflObjectSession>();
            for (DatastreamVersion dv : ov.listChangedDatastreams()) {
                String mimeType = this.resolveMimeType(dv);
                String dsId = dv.getDatastreamInfo().getDatastreamId();
                String f6DsId = this.resolveF6DatastreamId(dsId, f6ObjectId);
                String datastreamFilename = this.lastPartFromId(f6DsId);
                OcflObjectSession datastreamSession = datastreamSessions.computeIfAbsent(f6DsId, k -> this.datastreamSession(f6DsId, objectSession));
                if (dv.isFirstVersionIn(ov.getObject())) {
                    dsCreateDates.put(dsId, dv.getCreated());
                    datastreamStates.put(f6DsId, dv.getDatastreamInfo().getState());
                }
                String createDate = (String)dsCreateDates.get(dsId);
                String filename = this.resolveFilename(datastreamFilename, dv.getLabel(), (String)filenameMap.get(f6DsId), mimeType);
                relsDeletedFilenames.remove(f6DsId);
                ResourceHeaders datastreamHeaders = this.createDatastreamHeaders(dv, f6DsId, f6ObjectId, filename, mimeType, createDate);
                binaryMeta.put(f6DsId, new BinaryMeta(datastreamFilename, mimeType, dv.getLabel()));
                if (externalHandlingMap.containsKey(dv.getDatastreamInfo().getControlGroup())) {
                    InputStream content = null;
                    if (this.migrationType == MigrationType.PLAIN_OCFL) {
                        content = IOUtils.toInputStream(dv.getExternalOrRedirectURL(), StandardCharsets.UTF_8);
                    }
                    datastreamSession.writeResource(datastreamHeaders, content);
                } else {
                    try (InputStream contentStream = dv.getContent();){
                        this.writeDatastreamContent(dv, datastreamHeaders, contentStream, datastreamSession);
                    }
                    catch (IOException e2) {
                        throw new UncheckedIOException(e2);
                    }
                }
                if (this.foxmlFile) continue;
                String f6DescId = this.f6DescriptionId(f6DsId);
                ResourceHeaders.Builder descriptionHeaders = this.createDescriptionHeaders(f6DsId, datastreamHeaders);
                Model descriptionTriples = this.getDsTriples(dv, f6DsId, createDate);
                metaMap.computeIfAbsent(f6DescId, k -> new MetaHolder()).setHeaders(descriptionHeaders).setContentTriples(descriptionTriples);
                toWrite.add(f6DescId);
                if (!RELS_EXT.equals(dsId) && !RELS_INT.equals(dsId)) continue;
                Model triples = this.parseRdfXml(dv);
                if (RELS_EXT.equals(dsId)) {
                    ((MetaHolder)metaMap.get(f6ObjectId)).setRelsTriples(triples);
                    toWrite.add(f6ObjectId);
                    continue;
                }
                Map<String, Model> splitModels = this.splitRelsInt(triples);
                HashSet oldIds = new HashSet(filenameMap.keySet());
                filenameMap.clear();
                splitModels.forEach((id, model) -> {
                    String descId = this.f6DescriptionId((String)id);
                    metaMap.computeIfAbsent(descId, k -> new MetaHolder()).setRelsTriples((Model)model);
                    toWrite.add(descId);
                    StmtIterator it = model.listStatements();
                    while (it.hasNext()) {
                        Statement statement = (Statement)it.next();
                        if (!DOWNLOAD_NAME_PROP.equals(statement.getPredicate().getURI())) continue;
                        filenameMap.put((String)id, statement.getObject().toString());
                        relsFilenameUpdates.add((String)id);
                        break;
                    }
                });
                Sets.SetView deleted = Sets.difference(oldIds, filenameMap.keySet());
                deleted.forEach(id -> {
                    BinaryMeta meta = (BinaryMeta)binaryMeta.get(id);
                    if (meta != null) {
                        relsDeletedFilenames.put((String)id, this.resolveFilename(meta.name, meta.label, null, meta.mimeType));
                    }
                });
            }
            this.writeMeta(toWrite, metaMap, objectSession, datastreamSessions);
            this.updateFilenames(relsFilenameUpdates, filenameMap, relsDeletedFilenames, objectSession, datastreamSessions);
            LOGGER.debug("Committing object <{}>", (Object)f6ObjectId);
            OffsetDateTime creationTimestamp = OffsetDateTime.parse(ov.getVersionDate());
            objectSession.versionCreationTimestamp(creationTimestamp);
            objectSession.commit();
            if (this.resourceMigrationType != ResourceMigrationType.ATOMIC) continue;
            datastreamSessions.forEach((id, session) -> {
                LOGGER.debug("Committing object <{}>", id);
                session.versionCreationTimestamp(creationTimestamp);
                session.commit();
            });
        }
        this.handleDeletedResources(f6ObjectId, objectState, datastreamStates);
    }

    private String resolveFilename(String dsName, String labelName, String downloadName, String mimeType) {
        Object filename = StringUtils.isNotBlank(downloadName) ? downloadName : (StringUtils.isNotBlank(labelName) ? labelName : dsName);
        if (this.addDatastreamExtensions && StringUtils.isNotBlank(mimeType) && !((String)filename).contains(".")) {
            filename = (String)filename + ArchiveGroupHandler.getExtension(mimeType);
        }
        return filename;
    }

    private void writeMeta(Set<String> toWrite, Map<String, MetaHolder> metaMap, OcflObjectSession objectSession, Map<String, OcflObjectSession> datastreamSessions) {
        for (String id : toWrite) {
            MetaHolder meta = metaMap.get(id);
            if (meta.headers == null) continue;
            OcflObjectSession session = datastreamSessions.computeIfAbsent(id.replace(FCRMETA_SUFFIX, ""), k -> this.datastreamSession((String)k, objectSession));
            if (this.migrationType == MigrationType.FEDORA_OCFL) {
                try {
                    ResourceHeaders existingHeaders = session.readHeaders(id);
                    meta.headers.withMementoCreatedDate(existingHeaders.getMementoCreatedDate());
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            session.writeResource(meta.headers.build(), meta.constructTriples());
        }
    }

    private void updateFilenames(Set<String> toUpdate, Map<String, String> filenameMap, Map<String, String> relsDeletedFilenames, OcflObjectSession objectSession, Map<String, OcflObjectSession> datastreamSessions) {
        if (this.migrationType == MigrationType.FEDORA_OCFL) {
            toUpdate.forEach(id -> {
                OcflObjectSession session = datastreamSessions.computeIfAbsent(id.replace(FCRMETA_SUFFIX, ""), k -> this.datastreamSession((String)k, objectSession));
                ResourceHeaders origHeaders = session.readHeaders((String)id);
                String filename = (String)filenameMap.get(id);
                if (StringUtils.isNotBlank(filename)) {
                    ResourceHeaders newHeaders = ResourceHeaders.builder(origHeaders).withFilename(filename).build();
                    session.writeHeaders(newHeaders);
                }
            });
            relsDeletedFilenames.forEach((id, filename) -> {
                OcflObjectSession session = datastreamSessions.computeIfAbsent(id.replace(FCRMETA_SUFFIX, ""), k -> this.datastreamSession((String)k, objectSession));
                ResourceHeaders origHeaders = session.readHeaders((String)id);
                ResourceHeaders newHeaders = ResourceHeaders.builder(origHeaders).withFilename((String)filename).build();
                session.writeHeaders(newHeaders);
            });
        }
    }

    private boolean fedora3DigestValid(ContentDigest f3Digest) {
        return f3Digest != null && StringUtils.isNotBlank(f3Digest.getType()) && StringUtils.isNotBlank(f3Digest.getDigest());
    }

    private void writeDatastreamContent(DatastreamVersion dv, ResourceHeaders datastreamHeaders, InputStream contentStream, OcflObjectSession session) throws IOException {
        block13: {
            if (this.disableChecksumValidation) {
                session.writeResource(datastreamHeaders, contentStream);
                return;
            }
            ContentDigest f3Digest = dv.getContentDigest();
            String ocflObjectId = session.ocflObjectId();
            String datastreamId = dv.getDatastreamInfo().getDatastreamId();
            String datastreamControlGroup = dv.getDatastreamInfo().getControlGroup();
            if (this.fedora3DigestValid(f3Digest)) {
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(f3Digest.getType());
                    if (this.migrationType == MigrationType.PLAIN_OCFL) {
                        session.writeResource(datastreamHeaders, contentStream);
                        break block13;
                    }
                    try (DigestInputStream digestStream = new DigestInputStream(contentStream, messageDigest);){
                        session.writeResource(datastreamHeaders, digestStream);
                        String expectedDigest = f3Digest.getDigest();
                        String actualDigest = Bytes.wrap(digestStream.getMessageDigest().digest()).encodeHex();
                        if (!actualDigest.equalsIgnoreCase(expectedDigest)) {
                            String msg = String.format("%s/%s: digest %s doesn't match expected digest %s", ocflObjectId, datastreamId, actualDigest, expectedDigest);
                            throw new RuntimeException(msg);
                        }
                    }
                }
                catch (NoSuchAlgorithmException e2) {
                    String msg = String.format("%s/%s: no digest algorithm %s. Writing resource & continuing.", ocflObjectId, datastreamId, f3Digest.getType());
                    LOGGER.warn(msg);
                    session.writeResource(datastreamHeaders, contentStream);
                }
            } else {
                if (datastreamControlGroup.equalsIgnoreCase("M")) {
                    String msg = String.format("%s/%s: missing/invalid digest. Writing resource & continuing.", ocflObjectId, datastreamId);
                    LOGGER.warn(msg);
                }
                session.writeResource(datastreamHeaders, contentStream);
            }
        }
    }

    private void handleDeletedResources(String f6ObjectId, String objectState, Map<String, String> datastreamStates) {
        OcflObjectSession session = this.newSession(f6ObjectId);
        HashMap<String, OcflObjectSession> datastreamSessions = new HashMap<String, OcflObjectSession>();
        try {
            OffsetDateTime now2 = OffsetDateTime.now().withOffsetSameInstant(ZoneOffset.UTC);
            AtomicBoolean hasDeletes = new AtomicBoolean(false);
            if (OBJ_DELETED.equals(objectState) || this.deleteInactive && OBJ_INACTIVE.equals(objectState)) {
                hasDeletes.set(true);
                datastreamStates.keySet().forEach(f6DsId -> {
                    OcflObjectSession datastreamSession = datastreamSessions.computeIfAbsent((String)f6DsId, k -> this.datastreamSession((String)f6DsId, session));
                    this.deleteDatastream((String)f6DsId, now2.toInstant(), datastreamSession);
                });
                if (this.migrationType == MigrationType.PLAIN_OCFL) {
                    this.deleteOcflMigratedResource(f6ObjectId, InteractionModel.BASIC_CONTAINER, session);
                } else {
                    this.deleteF6MigratedResource(f6ObjectId, now2.toInstant(), session);
                }
            } else {
                datastreamStates.forEach((f6DsId, state) -> {
                    if (DS_DELETED.equals(state) || this.deleteInactive && DS_INACTIVE.equals(state)) {
                        OcflObjectSession datastreamSession = datastreamSessions.computeIfAbsent((String)f6DsId, k -> this.datastreamSession((String)f6DsId, session));
                        hasDeletes.set(true);
                        this.deleteDatastream((String)f6DsId, now2.toInstant(), datastreamSession);
                    }
                });
            }
            if (hasDeletes.get()) {
                session.versionCreationTimestamp(now2);
                session.commit();
                if (this.resourceMigrationType == ResourceMigrationType.ATOMIC) {
                    datastreamSessions.forEach((id, dsSession) -> {
                        dsSession.versionCreationTimestamp(now2);
                        dsSession.commit();
                    });
                }
            } else {
                session.abort();
                if (this.resourceMigrationType == ResourceMigrationType.ATOMIC) {
                    datastreamSessions.forEach((id, dsSession) -> dsSession.abort());
                }
            }
        }
        catch (RuntimeException e2) {
            session.abort();
            throw e2;
        }
    }

    private String f6DescriptionId(String f6ResourceId) {
        return f6ResourceId + FCRMETA_SUFFIX;
    }

    private String lastPartFromId(String id) {
        return id.substring(id.lastIndexOf(47) + 1);
    }

    private String resolveF6DatastreamId(String datastreamId, String f6ObjectId) {
        return f6ObjectId + "/" + datastreamId;
    }

    private ResourceHeaders.Builder createHeaders(String id, String parentId, InteractionModel model) {
        ResourceHeaders.Builder headers = ResourceHeaders.builder();
        headers.withHeadersVersion("1.0");
        headers.withId(id);
        headers.withParent(parentId);
        headers.withInteractionModel(model.getUri());
        return headers;
    }

    private ResourceHeaders.Builder createObjectHeaders(String f6ObjectId, ObjectVersionReference ov) {
        ResourceHeaders.Builder headers = this.createHeaders(f6ObjectId, FCREPO_ROOT, InteractionModel.BASIC_CONTAINER);
        headers.withArchivalGroup(this.resourceMigrationType == ResourceMigrationType.ARCHIVAL);
        headers.withObjectRoot(true);
        headers.withLastModifiedBy(this.user);
        headers.withCreatedBy(this.user);
        ov.getObjectProperties().listProperties().forEach(p -> {
            if (p.getName().contains("lastModifiedDate")) {
                Instant lastModified = Instant.parse(p.getValue());
                headers.withLastModifiedDate(lastModified);
                headers.withMementoCreatedDate(lastModified);
                headers.withStateToken(DigestUtils.md5Hex(String.valueOf(lastModified.toEpochMilli())).toUpperCase());
            } else if (p.getName().contains("createdDate")) {
                headers.withCreatedDate(Instant.parse(p.getValue()));
            }
        });
        return headers;
    }

    private ResourceHeaders createDatastreamHeaders(DatastreamVersion dv, String f6DsId, String f6ObjectId, String filename, String mime, String createDate) {
        Instant lastModified = Instant.parse(dv.getCreated());
        ResourceHeaders.Builder headers = this.createHeaders(f6DsId, f6ObjectId, InteractionModel.NON_RDF);
        if (this.resourceMigrationType == ResourceMigrationType.ARCHIVAL) {
            headers.withArchivalGroupId(f6ObjectId);
        }
        headers.withFilename(filename);
        headers.withCreatedDate(Instant.parse(createDate));
        headers.withLastModifiedDate(lastModified);
        headers.withLastModifiedBy(this.user);
        headers.withCreatedBy(this.user);
        headers.withMementoCreatedDate(lastModified);
        if (externalHandlingMap.containsKey(dv.getDatastreamInfo().getControlGroup())) {
            headers.withExternalHandling(externalHandlingMap.get(dv.getDatastreamInfo().getControlGroup()));
            headers.withExternalUrl(dv.getExternalOrRedirectURL());
        }
        headers.withArchivalGroup(false);
        headers.withObjectRoot(this.resourceMigrationType == ResourceMigrationType.ATOMIC);
        if (dv.getSize() > -1L && !INLINE_XML.equals(dv.getDatastreamInfo().getControlGroup())) {
            headers.withContentSize(dv.getSize());
        }
        if (dv.getContentDigest() != null && !Strings.isNullOrEmpty(dv.getContentDigest().getDigest())) {
            ContentDigest digest = dv.getContentDigest();
            ArrayList<URI> digests = new ArrayList<URI>();
            digests.add(URI.create("urn:" + digest.getType().toLowerCase() + ":" + digest.getDigest().toLowerCase()));
            headers.withDigests(digests);
        }
        headers.withMimeType(mime);
        headers.withStateToken(DigestUtils.md5Hex(String.valueOf(lastModified.toEpochMilli())).toUpperCase());
        return headers.build();
    }

    private ResourceHeaders.Builder createDescriptionHeaders(String f6DsId, ResourceHeaders datastreamHeaders) {
        String id = this.f6DescriptionId(f6DsId);
        ResourceHeaders.Builder headers = this.createHeaders(id, f6DsId, InteractionModel.NON_RDF_DESCRIPTION);
        if (this.resourceMigrationType == ResourceMigrationType.ARCHIVAL) {
            headers.withArchivalGroupId(datastreamHeaders.getArchivalGroupId());
        }
        headers.withCreatedDate(datastreamHeaders.getCreatedDate());
        headers.withLastModifiedDate(datastreamHeaders.getLastModifiedDate());
        headers.withCreatedBy(datastreamHeaders.getCreatedBy());
        headers.withLastModifiedBy(datastreamHeaders.getLastModifiedBy());
        headers.withMementoCreatedDate(datastreamHeaders.getMementoCreatedDate());
        headers.withArchivalGroup(false);
        headers.withObjectRoot(false);
        headers.withStateToken(datastreamHeaders.getStateToken());
        return headers;
    }

    private String resolveMimeType(DatastreamVersion dv) {
        String mime = dv.getMimeType();
        if (Strings.isNullOrEmpty(mime)) {
            Metadata meta = new Metadata();
            meta.set("resourceName", dv.getDatastreamInfo().getDatastreamId());
            try (TikaInputStream content = TikaInputStream.get(dv.getContent());){
                mime = this.mimeDetector.detect(content, meta).toString();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
        return mime;
    }

    private void deleteDatastream(String id, Instant lastModified, OcflObjectSession session) {
        if (this.migrationType == MigrationType.PLAIN_OCFL) {
            this.deleteOcflMigratedResource(id, InteractionModel.NON_RDF, session);
            this.deleteOcflMigratedResource(this.f6DescriptionId(id), InteractionModel.NON_RDF_DESCRIPTION, session);
        } else {
            this.deleteF6MigratedResource(id, lastModified, session);
            this.deleteF6MigratedResource(this.f6DescriptionId(id), lastModified, session);
        }
    }

    private void deleteF6MigratedResource(String id, Instant lastModified, OcflObjectSession session) {
        LOGGER.debug("Deleting resource {}", (Object)id);
        ResourceHeaders headers = session.readHeaders(id);
        session.deleteContentFile(ResourceHeaders.builder(headers).withDeleted(true).withLastModifiedDate(lastModified).withMementoCreatedDate(lastModified).build());
    }

    private void deleteOcflMigratedResource(String id, InteractionModel interactionModel, OcflObjectSession session) {
        LOGGER.debug("Deleting resource {}", (Object)id);
        session.deleteContentFile(ResourceHeaders.builder().withId(id).withInteractionModel(interactionModel.getUri()).build());
    }

    private String getObjectState(ObjectVersionReference ov, String pid) {
        return ov.getObjectProperties().listProperties().stream().filter(prop -> OBJ_STATE_PROP.equals(prop.getName())).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Object %s is missing state information", pid))).getValue();
    }

    private static Model getObjTriples(ObjectVersionReference o, String pid) {
        Model triples = ModelFactory.createDefaultModel();
        String uri = FCREPO_ROOT + pid;
        o.getObjectProperties().listProperties().forEach(p -> {
            if (p.getName().contains("Date")) {
                ArchiveGroupHandler.addDateLiteral(triples, uri, p.getName(), p.getValue());
            } else {
                ArchiveGroupHandler.addStringLiteral(triples, uri, p.getName(), p.getValue());
            }
        });
        return triples;
    }

    private Model getDsTriples(DatastreamVersion dv, String f6DsId, String createDate) {
        Model triples = ModelFactory.createDefaultModel();
        if (this.migrationType == MigrationType.PLAIN_OCFL) {
            ArchiveGroupHandler.addDateLiteral(triples, f6DsId, "http://fedora.info/definitions/v4/repository#created", createDate);
            ArchiveGroupHandler.addDateLiteral(triples, f6DsId, "http://fedora.info/definitions/v4/repository#lastModified", dv.getCreated());
            ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://purl.org/dc/terms/identifier", dv.getDatastreamInfo().getDatastreamId());
            ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://www.ebu.ch/metadata/ontologies/ebucore/ebucore#hasMimeType", dv.getMimeType());
            ArchiveGroupHandler.addLongLiteral(triples, f6DsId, "http://www.loc.gov/premis/rdf/v1#size", dv.getSize());
            if (dv.getContentDigest() != null) {
                ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://www.loc.gov/premis/rdf/v1#hasMessageDigest", "urn:" + dv.getContentDigest().getType().toLowerCase() + ":" + dv.getContentDigest().getDigest().toLowerCase());
            }
        }
        ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://purl.org/dc/terms/title", dv.getLabel());
        ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://fedora.info/definitions/1/0/access/objState", dv.getDatastreamInfo().getState());
        ArchiveGroupHandler.addStringLiteral(triples, f6DsId, "http://www.loc.gov/premis/rdf/v1#formatDesignation", dv.getFormatUri());
        return triples;
    }

    private static void addStringLiteral(Model m4, String s2, String p, String o) {
        if (o != null) {
            m4.add(m4.createResource(s2), m4.createProperty(p), o);
        }
    }

    private static void addDateLiteral(Model m4, String s2, String p, String date2) {
        if (date2 != null) {
            m4.addLiteral(m4.createResource(s2), m4.createProperty(p), m4.createTypedLiteral(date2, (RDFDatatype)XSDDatatype.XSDdateTime));
        }
    }

    private static void addLongLiteral(Model m4, String s2, String p, long number) {
        if (number != -1L) {
            m4.addLiteral(m4.createResource(s2), m4.createProperty(p), m4.createTypedLiteral((Object)number, (RDFDatatype)XSDDatatype.XSDlong));
        }
    }

    private static String getExtension(String mime) {
        MimeType type;
        MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
        try {
            type = allTypes.forName(mime);
        }
        catch (MimeTypeException e2) {
            type = null;
        }
        if (type != null) {
            return type.getExtension();
        }
        LOGGER.warn("No mimetype found for '{}'", (Object)mime);
        return "";
    }

    private Model parseRdfXml(DatastreamVersion datastreamVersion) {
        Model model;
        block8: {
            Model model2 = ModelFactory.createDefaultModel();
            InputStream is = datastreamVersion.getContent();
            try {
                RDFDataMgr.read(model2, is, Lang.RDFXML);
                model = model2;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    throw new RuntimeException(String.format("Failed to parse RDF XML in %s/%s", datastreamVersion.getDatastreamInfo().getObjectInfo().getPid(), datastreamVersion.getDatastreamInfo().getDatastreamId()), e2);
                }
            }
            is.close();
        }
        return model;
    }

    private Map<String, Model> splitRelsInt(Model relsIntModel) {
        HashMap<String, Model> splitModels = new HashMap<String, Model>();
        StmtIterator it = relsIntModel.listStatements();
        while (it.hasNext()) {
            Statement statement = (Statement)it.next();
            String id = statement.getSubject().getURI();
            Model model = splitModels.computeIfAbsent(id, k -> ModelFactory.createDefaultModel());
            model.add(statement);
        }
        return splitModels;
    }

    private OcflObjectSession datastreamSession(String id, OcflObjectSession objectSession) {
        if (this.resourceMigrationType == ResourceMigrationType.ARCHIVAL) {
            return objectSession;
        }
        return this.newSession(id);
    }

    private OcflObjectSession newSession(String id) {
        return new OcflObjectSessionWrapper(this.sessionFactory.newSession(id));
    }

    private static class BinaryMeta {
        final String name;
        final String mimeType;
        final String label;

        public BinaryMeta(String name, String mimeType, String label) {
            this.name = name;
            this.mimeType = mimeType;
            this.label = label;
        }
    }

    private static class MetaHolder {
        Model contentTriples;
        Model relsTriples;
        ResourceHeaders.Builder headers;

        public static MetaHolder fromContent(Model contentTriples, ResourceHeaders.Builder headers) {
            return new MetaHolder(contentTriples, null, headers);
        }

        private MetaHolder() {
        }

        private MetaHolder(Model contentTriples, Model relsTriples, ResourceHeaders.Builder headers) {
            this.contentTriples = contentTriples;
            this.relsTriples = relsTriples;
            this.headers = headers;
        }

        public InputStream constructTriples() {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Model triples = ModelFactory.createDefaultModel();
            if (this.contentTriples != null) {
                triples.add(this.contentTriples.listStatements());
            }
            if (this.relsTriples != null) {
                triples.add(this.relsTriples.listStatements());
            }
            triples.write(output, Lang.NTRIPLES.getName());
            return new ByteArrayInputStream(output.toByteArray());
        }

        public MetaHolder setHeaders(ResourceHeaders.Builder headers) {
            this.headers = headers;
            return this;
        }

        public MetaHolder setContentTriples(Model contentTriples) {
            this.contentTriples = contentTriples;
            return this;
        }

        public MetaHolder setRelsTriples(Model relsTriples) {
            this.relsTriples = relsTriples;
            return this;
        }
    }
}

