/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fcrepo.migration.DatastreamVersion;
import org.fcrepo.migration.FedoraObjectVersionHandler;
import org.fcrepo.migration.ObjectInfo;
import org.fcrepo.migration.ObjectProperties;
import org.fcrepo.migration.ObjectReference;
import org.fcrepo.migration.ObjectVersionReference;
import org.fcrepo.migration.StreamingFedoraObjectHandler;

public class ObjectAbstractionStreamingFedoraObjectHandler
implements StreamingFedoraObjectHandler {
    private FedoraObjectVersionHandler versionHandler;
    private ObjectInfo objectInfo;
    private ObjectProperties objectProperties;
    private List<String> dsIds;
    private Map<String, List<DatastreamVersion>> dsIdToVersionListMap;

    public ObjectAbstractionStreamingFedoraObjectHandler(FedoraObjectVersionHandler versionHandler) {
        this.versionHandler = versionHandler;
        this.dsIds = new ArrayList<String>();
        this.dsIdToVersionListMap = new HashMap<String, List<DatastreamVersion>>();
    }

    @Override
    public void beginObject(ObjectInfo object) {
        this.objectInfo = object;
    }

    @Override
    public void processObjectProperties(ObjectProperties properties) {
        this.objectProperties = properties;
    }

    @Override
    public void processDatastreamVersion(DatastreamVersion dsVersion) {
        List<DatastreamVersion> versions = this.dsIdToVersionListMap.get(dsVersion.getDatastreamInfo().getDatastreamId());
        if (versions == null) {
            this.dsIds.add(dsVersion.getDatastreamInfo().getDatastreamId());
            versions = new ArrayList<DatastreamVersion>();
            this.dsIdToVersionListMap.put(dsVersion.getDatastreamInfo().getDatastreamId(), versions);
        }
        versions.add(dsVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeObject(ObjectInfo object) {
        ObjectReference objectReference = this.getObjectReference();
        try {
            Map<String, List<DatastreamVersion>> versionMap = this.buildVersionMap();
            ArrayList<String> versionDates = new ArrayList<String>(versionMap.keySet());
            Collections.sort(versionDates);
            ArrayList<ObjectVersionReference> versions = new ArrayList<ObjectVersionReference>();
            for (String versionDate : versionDates) {
                versions.add(this.getObjectVersionReference(versionDate, versionDates, objectReference, versionMap));
            }
            this.versionHandler.processObjectVersions(versions, object);
        }
        finally {
            this.cleanForReuse();
        }
    }

    @Override
    public void abortObject(ObjectInfo object) {
        this.cleanForReuse();
    }

    private void cleanForReuse() {
        this.dsIds.clear();
        this.dsIdToVersionListMap.clear();
    }

    private Map<String, List<DatastreamVersion>> buildVersionMap() {
        HashMap<String, List<DatastreamVersion>> versionMap = new HashMap<String, List<DatastreamVersion>>();
        for (String dsId : this.dsIds) {
            for (DatastreamVersion v : this.dsIdToVersionListMap.get(dsId)) {
                String date = v.getCreated();
                ArrayList<DatastreamVersion> versionsForDate = (ArrayList<DatastreamVersion>)versionMap.get(date);
                if (versionsForDate == null) {
                    versionsForDate = new ArrayList<DatastreamVersion>();
                    versionMap.put(date, versionsForDate);
                }
                versionsForDate.add(v);
            }
        }
        return versionMap;
    }

    private ObjectReference getObjectReference() {
        return new ObjectReference(){

            @Override
            public ObjectInfo getObjectInfo() {
                return ObjectAbstractionStreamingFedoraObjectHandler.this.objectInfo;
            }

            @Override
            public ObjectProperties getObjectProperties() {
                return ObjectAbstractionStreamingFedoraObjectHandler.this.objectProperties;
            }

            @Override
            public List<String> listDatastreamIds() {
                return ObjectAbstractionStreamingFedoraObjectHandler.this.dsIds;
            }

            @Override
            public List<DatastreamVersion> getDatastreamVersions(String datastreamId) {
                return ObjectAbstractionStreamingFedoraObjectHandler.this.dsIdToVersionListMap.get(datastreamId);
            }
        };
    }

    private ObjectVersionReference getObjectVersionReference(final String versionDate, final List<String> versionDates, final ObjectReference objectReference, final Map<String, List<DatastreamVersion>> versionMap) {
        return new ObjectVersionReference(){

            @Override
            public ObjectReference getObject() {
                return objectReference;
            }

            @Override
            public ObjectProperties getObjectProperties() {
                return ObjectAbstractionStreamingFedoraObjectHandler.this.objectProperties;
            }

            @Override
            public String getVersionDate() {
                return versionDate;
            }

            @Override
            public List<DatastreamVersion> listChangedDatastreams() {
                return (List)versionMap.get(versionDate);
            }

            @Override
            public boolean isLastVersion() {
                return ((String)versionDates.get(versionDates.size() - 1)).equals(versionDate);
            }

            @Override
            public boolean isFirstVersion() {
                return ((String)versionDates.get(0)).equals(versionDate);
            }

            @Override
            public int getVersionIndex() {
                return versionDates.indexOf(versionDate);
            }

            @Override
            public boolean wasDatastreamChanged(String dsId) {
                for (DatastreamVersion v : this.listChangedDatastreams()) {
                    if (!v.getDatastreamInfo().getDatastreamId().equals(dsId)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

