/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.urlmappers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fcrepo.migration.ExternalContentURLMapper;
import org.fcrepo.migration.MigrationIDMapper;

public class SelfReferencingURLMapper
implements ExternalContentURLMapper {
    private static final String OLD_DS_CONTENT_URL_PATTERN = "http://{local-fedora-server}/fedora/get/([^/]+)/(.+)";
    private static final String NEW_DS_CONTENT_URL_PATTERN = "http://{local-fedora-server}/fedora/objects/([^/]+)/datastreams/([^/]+)/content";
    private List<Pattern> contentPatterns = new ArrayList<Pattern>();
    private Pattern invalidPattern;
    private MigrationIDMapper idMapper;

    public SelfReferencingURLMapper(String localFedoraServer, MigrationIDMapper idMapper) {
        this.contentPatterns.add(this.parsePattern(OLD_DS_CONTENT_URL_PATTERN, localFedoraServer));
        this.contentPatterns.add(this.parsePattern(NEW_DS_CONTENT_URL_PATTERN, localFedoraServer));
        this.idMapper = idMapper;
        this.invalidPattern = this.parsePattern("http://{local-fedora-server}/fedora/.*", localFedoraServer);
    }

    private Pattern parsePattern(String pattern, String localFedoraServer) {
        return Pattern.compile(pattern.replace("{local-fedora-server}", localFedoraServer));
    }

    @Override
    public String mapURL(String url) {
        for (Pattern p : this.contentPatterns) {
            Matcher m = p.matcher(url);
            if (!m.matches()) continue;
            return this.idMapper.getBaseURL() + this.idMapper.mapDatastreamPath(m.group(1), m.group(2));
        }
        if (this.invalidPattern.matcher(url).matches()) {
            throw new IllegalArgumentException("Unhandled internal external fedora 3 URL. (" + url + ")");
        }
        return url;
    }
}

