/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.lock;

import edu.wisc.library.ocfl.api.exception.LockException;
import edu.wisc.library.ocfl.api.exception.OcflDbException;
import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.db.DbType;
import edu.wisc.library.ocfl.core.lock.ObjectLock;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbObjectLock
implements ObjectLock {
    private static final Logger LOG = LoggerFactory.getLogger(DbObjectLock.class);
    private static final Map<DbType, String> DUPLICATE_STATE_CODES = Map.of(DbType.H2, "23505", DbType.MARIADB, "23000", DbType.POSTGRES, "23505");
    private final String tableName;
    private final DataSource dataSource;
    private final Duration lockDuration;
    private final String createRowLockQuery;
    private final String updateRowLockQuery;
    private final String deleteRowLockQuery;
    private final String duplicateStateCode;

    public DbObjectLock(DbType dbType, String tableName, DataSource dataSource, Duration maxLockDuration) {
        Enforce.notNull(dbType, "dbType cannot be null");
        this.tableName = Enforce.notBlank(tableName, "tableName cannot be blank");
        this.dataSource = Enforce.notNull(dataSource, "dataSource cannot be null");
        this.lockDuration = Enforce.notNull(maxLockDuration, "maxLockDuration cannot be null");
        this.duplicateStateCode = Enforce.notBlank(DUPLICATE_STATE_CODES.get((Object)dbType), "duplicate state code cannot be blank");
        this.createRowLockQuery = String.format("INSERT INTO %s (object_id, acquired_timestamp) VALUES (?, ?)", tableName);
        this.updateRowLockQuery = String.format("UPDATE %s SET acquired_timestamp = ? WHERE object_id = ? AND acquired_timestamp <= ?", tableName);
        this.deleteRowLockQuery = String.format("DELETE FROM %s WHERE object_id = ? AND acquired_timestamp = ?", tableName);
    }

    @Override
    public void doInWriteLock(String objectId, Runnable doInLock) {
        this.doInWriteLock(objectId, () -> {
            doInLock.run();
            return null;
        });
    }

    @Override
    public <T> T doInWriteLock(String objectId, Callable<T> doInLock) {
        Instant now2 = Instant.now().truncatedTo(ChronoUnit.MILLIS);
        try (Connection connection = this.dataSource.getConnection();){
            if (!this.createLockRow(objectId, now2, connection) && !this.createLockRow(objectId, now2, connection)) {
                throw this.failedToAcquireLock(objectId);
            }
        }
        catch (SQLException e2) {
            throw new OcflDbException(e2);
        }
        try {
            T e2 = doInLock.call();
            return e2;
        }
        catch (RuntimeException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new OcflJavaException(e4);
        }
        finally {
            this.releaseLock(objectId, now2);
        }
    }

    private boolean createLockRow(String objectId, Instant timestamp, Connection connection) throws SQLException {
        boolean bl;
        block9: {
            PreparedStatement statement = connection.prepareStatement(this.createRowLockQuery);
            try {
                statement.setString(1, objectId);
                statement.setTimestamp(2, Timestamp.from(timestamp));
                statement.executeUpdate();
                bl = true;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e2) {
                    if (this.duplicateStateCode.equals(e2.getSQLState())) {
                        return this.updateLockRow(objectId, timestamp, connection);
                    }
                    throw e2;
                }
            }
            statement.close();
        }
        return bl;
    }

    private boolean updateLockRow(String objectId, Instant timestamp, Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.updateRowLockQuery);){
            Instant expired = timestamp.minus(this.lockDuration);
            statement.setTimestamp(1, Timestamp.from(timestamp));
            statement.setString(2, objectId);
            statement.setTimestamp(3, Timestamp.from(expired));
            int updateCount = statement.executeUpdate();
            boolean bl = updateCount == 1;
            return bl;
        }
    }

    private LockException failedToAcquireLock(String objectId) {
        return new LockException("Failed to acquire lock for object " + objectId);
    }

    private void releaseLock(String objectId, Instant timestamp) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.deleteRowLockQuery);){
            statement.setString(1, objectId);
            statement.setTimestamp(2, Timestamp.from(timestamp));
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            LOG.error("Failed to release lock on object {}", (Object)objectId, (Object)e2);
        }
    }
}

