/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.model;

import edu.wisc.library.ocfl.api.exception.OcflInputException;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.InventoryType;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.PathBiMap;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import edu.wisc.library.ocfl.core.model.Version;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InventoryBuilder {
    private static final VersionNum INITIAL_VERSION = VersionNum.V1;
    private static final RevisionNum INITIAL_REVISION = RevisionNum.R1;
    private String id;
    private InventoryType type;
    private DigestAlgorithm digestAlgorithm;
    private VersionNum head;
    private String contentDirectory;
    private boolean mutableHead;
    private RevisionNum revisionNum;
    private String objectRootPath;
    private Map<DigestAlgorithm, PathBiMap> fixity;
    private PathBiMap manifest;
    private Map<VersionNum, Version> versions;
    private VersionNum nextHeadVersion;
    private String previousDigest;
    private String inventoryDigest;

    public InventoryBuilder() {
        this.fixity = new HashMap<DigestAlgorithm, PathBiMap>();
        this.manifest = new PathBiMap();
        this.versions = new HashMap<VersionNum, Version>();
        this.nextHeadVersion = INITIAL_VERSION;
    }

    public InventoryBuilder(Inventory original) {
        Enforce.notNull(original, "inventory cannot be null");
        this.id = original.getId();
        this.type = original.getType();
        this.digestAlgorithm = original.getDigestAlgorithm();
        this.head = original.getHead();
        this.contentDirectory = original.getContentDirectory();
        this.mutableHead = original.hasMutableHead();
        this.revisionNum = original.getRevisionNum();
        this.objectRootPath = original.getObjectRootPath();
        this.fixity = InventoryBuilder.fixityToBiMap(original.getFixity());
        this.manifest = PathBiMap.fromFileIdMap(original.getManifest());
        this.versions = new HashMap<VersionNum, Version>(original.getVersions());
        this.previousDigest = original.getPreviousDigest();
        this.inventoryDigest = original.getInventoryDigest();
        this.nextHeadVersion = this.head.nextVersionNum();
    }

    private static Map<DigestAlgorithm, PathBiMap> fixityToBiMap(Map<DigestAlgorithm, Map<String, Set<String>>> originalFixity) {
        HashMap<DigestAlgorithm, PathBiMap> fixity = new HashMap<DigestAlgorithm, PathBiMap>();
        originalFixity.forEach((digestAlgorithm, map) -> fixity.put((DigestAlgorithm)digestAlgorithm, PathBiMap.fromFileIdMap(map)));
        return fixity;
    }

    public InventoryBuilder addHeadVersion(Version version2) {
        Enforce.notNull(version2, "version cannot be null");
        if (this.mutableHead) {
            if (this.revisionNum == null) {
                this.revisionNum = INITIAL_REVISION;
                this.head = this.nextHeadVersion;
            } else {
                this.revisionNum = this.revisionNum.nextRevisionNum();
            }
            this.versions.put(this.head, version2);
        } else {
            this.versions.put(this.nextHeadVersion, version2);
            this.head = this.nextHeadVersion;
            this.nextHeadVersion = this.nextHeadVersion.nextVersionNum();
        }
        return this;
    }

    public InventoryBuilder putVersion(VersionNum versionNum, Version version2) {
        Enforce.notNull(versionNum, "versionNum cannot be null");
        Enforce.notNull(version2, "version cannot be null");
        this.versions.put(versionNum, version2);
        return this;
    }

    public InventoryBuilder addFileToManifest(String id, String contentPath) {
        Enforce.notBlank(id, "id cannot be blank");
        Enforce.notBlank(contentPath, "contentPath cannot be blank");
        this.manifest.put(id, contentPath);
        return this;
    }

    public InventoryBuilder removeFileId(String fileId) {
        Set<String> paths = this.manifest.removeFileId(fileId);
        if (paths != null) {
            paths.forEach(this::removeContentPathFromFixity);
        }
        return this;
    }

    public InventoryBuilder removeContentPath(String contentPath) {
        Enforce.notBlank(contentPath, "contentPath cannot be blank");
        this.manifest.removePath(contentPath);
        this.removeContentPathFromFixity(contentPath);
        return this;
    }

    public InventoryBuilder removeContentPathFromFixity(String contentPath) {
        Enforce.notBlank(contentPath, "contentPath cannot be blank");
        this.fixity.values().forEach(map -> map.removePath(contentPath));
        return this;
    }

    public InventoryBuilder addFixityForFile(String contentPath, DigestAlgorithm algorithm, String value) {
        Enforce.notBlank(contentPath, "contentPath cannot be blank");
        Enforce.notNull(algorithm, "algorithm cannot be null");
        Enforce.notBlank(value, "value cannot be blank");
        if (!this.manifest.containsPath(contentPath)) {
            throw new OcflInputException(String.format("Cannot add fixity information for content path %s because it is not present in the manifest.", contentPath));
        }
        this.fixity.computeIfAbsent(algorithm, k -> new PathBiMap()).put(value, contentPath);
        return this;
    }

    public InventoryBuilder clearFixity() {
        this.fixity.clear();
        return this;
    }

    public InventoryBuilder id(String id) {
        this.id = Enforce.notBlank(id, "id cannot be blank");
        return this;
    }

    public InventoryBuilder type(InventoryType type) {
        this.type = Enforce.notNull(type, "type cannot be null");
        return this;
    }

    public InventoryBuilder digestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = Enforce.notNull(digestAlgorithm, "digestAlgorithm cannot be null");
        return this;
    }

    public InventoryBuilder head(VersionNum head) {
        this.head = Enforce.notNull(head, "head cannot be null");
        this.nextHeadVersion = head.nextVersionNum();
        return this;
    }

    public InventoryBuilder contentDirectory(String contentDirectory) {
        this.contentDirectory = contentDirectory;
        return this;
    }

    public InventoryBuilder fixityBiMap(Map<DigestAlgorithm, PathBiMap> fixity) {
        this.fixity = Enforce.notNull(fixity, "fixity cannot be null");
        return this;
    }

    public InventoryBuilder fixity(Map<DigestAlgorithm, Map<String, Set<String>>> fixity) {
        this.fixity = InventoryBuilder.fixityToBiMap(fixity == null ? Collections.emptyMap() : fixity);
        return this;
    }

    public InventoryBuilder manifest(PathBiMap manifest) {
        this.manifest = Enforce.notNull(manifest, "manifest cannot be null");
        return this;
    }

    public InventoryBuilder manifest(Map<String, Set<String>> manifest) {
        this.manifest = PathBiMap.fromFileIdMap(Enforce.notNull(manifest, "manifest cannot be null"));
        return this;
    }

    public InventoryBuilder versions(Map<VersionNum, Version> versions) {
        this.versions = Enforce.notNull(versions, "versions cannot be null");
        return this;
    }

    public InventoryBuilder mutableHead(boolean mutableHead) {
        this.mutableHead = mutableHead;
        return this;
    }

    public InventoryBuilder revisionNum(RevisionNum revisionNum) {
        this.revisionNum = revisionNum;
        return this;
    }

    public InventoryBuilder objectRootPath(String objectRootPath) {
        this.objectRootPath = Enforce.notBlank(objectRootPath, "objectRootPath cannot be blank");
        return this;
    }

    public InventoryBuilder previousDigest(String previousDigest) {
        this.previousDigest = previousDigest;
        return this;
    }

    public InventoryBuilder inventoryDigest(String inventoryDigest) {
        this.inventoryDigest = inventoryDigest;
        return this;
    }

    public Inventory build() {
        return new Inventory(this.id, this.type, this.digestAlgorithm, this.head, this.contentDirectory, this.fixityFromBiMap(), this.manifest.getFileIdToPaths(), this.versions, this.mutableHead, this.revisionNum, this.objectRootPath, this.previousDigest, this.inventoryDigest);
    }

    public boolean containsFileId(String fileId) {
        return this.manifest.containsFileId(fileId);
    }

    public boolean containsContentPath(String contentPath) {
        return this.manifest.containsPath(contentPath);
    }

    public Set<String> getContentPaths(String fileId) {
        return this.manifest.getPaths(fileId);
    }

    public String getFileId(String contentPath) {
        return this.manifest.getFileId(contentPath);
    }

    public boolean hasMutableHead() {
        return this.mutableHead;
    }

    public String getFileFixity(String fileId, DigestAlgorithm algorithm) {
        Set<String> contentPaths = this.manifest.getPaths(fileId);
        for (String contentPath : contentPaths) {
            String digest;
            PathBiMap fixityMap = this.fixity.get(algorithm);
            if (fixityMap == null || (digest = fixityMap.getFileId(contentPath)) == null) continue;
            return digest;
        }
        return null;
    }

    private Map<DigestAlgorithm, Map<String, Set<String>>> fixityFromBiMap() {
        HashMap<DigestAlgorithm, Map<String, Set<String>>> transformed = new HashMap<DigestAlgorithm, Map<String, Set<String>>>();
        this.fixity.forEach((algorithm, map) -> transformed.put((DigestAlgorithm)algorithm, map.getFileIdToPaths()));
        return transformed;
    }
}

