/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.path.constraint;

import edu.wisc.library.ocfl.api.exception.PathConstraintException;
import edu.wisc.library.ocfl.core.path.constraint.PathCharConstraint;
import java.nio.file.FileSystems;

public class BackslashPathSeparatorConstraint
implements PathCharConstraint {
    private final char pathSeparator = FileSystems.getDefault().getSeparator().charAt(0);
    private final boolean isBackslash = this.pathSeparator == '\\';

    @Override
    public void apply(char c, String path) {
        if (this.isBackslash && c == '\\') {
            throw new PathConstraintException(String.format("The path contains a \\ character in a filename, which is illegal on the local filesystem. Path: %s", path));
        }
    }
}

