/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.path.constraint;

import edu.wisc.library.ocfl.api.exception.PathConstraintException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.path.constraint.FileNameConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraint;
import java.nio.charset.StandardCharsets;

public class PathLengthConstraint
implements PathConstraint,
FileNameConstraint {
    private final int maxLength;
    private final Type type;

    public static PathLengthConstraint maxChars(int maxLength) {
        return new PathLengthConstraint(maxLength, Type.CHARACTERS);
    }

    public static PathLengthConstraint maxBytes(int maxLength) {
        return new PathLengthConstraint(maxLength, Type.BYTES);
    }

    public PathLengthConstraint(int maxLength, Type type) {
        this.maxLength = Enforce.expressionTrue(maxLength > 0, maxLength, "maxLength must be greater than 0");
        this.type = Enforce.notNull(type, "type cannot be null");
    }

    @Override
    public void apply(String path) {
        if (this.type == Type.CHARACTERS) {
            this.validateLength(path.length(), this.message(path));
        } else {
            this.validateLength(path.getBytes(StandardCharsets.UTF_8).length, this.message(path));
        }
    }

    @Override
    public void apply(String fileName, String path) {
        if (this.type == Type.CHARACTERS) {
            this.validateLength(fileName.length(), this.message(fileName, path));
        } else {
            this.validateLength(fileName.getBytes(StandardCharsets.UTF_8).length, this.message(fileName, path));
        }
    }

    private void validateLength(int length, String message) {
        if (length > this.maxLength) {
            throw new PathConstraintException(message);
        }
    }

    private String message(String path) {
        return String.format("The path is longer than %s %s. Path: %s", new Object[]{this.maxLength, this.type, path});
    }

    private String message(String fileName, String path) {
        return String.format("The filename '%s' is longer than %s %s. Path: %s", new Object[]{fileName, this.maxLength, this.type, path});
    }

    public static enum Type {
        CHARACTERS("characters"),
        BYTES("bytes");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

