/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.common;

import edu.wisc.library.ocfl.api.util.Enforce;
import java.util.Objects;

public class Listing {
    private final Type type;
    private final String relativePath;

    public static Listing file(String relativePath) {
        return new Listing(Type.File, relativePath);
    }

    public static Listing directory(String relativePath) {
        return new Listing(Type.Directory, relativePath);
    }

    public static Listing other(String relativePath) {
        return new Listing(Type.Other, relativePath);
    }

    public Listing(Type type, String relativePath) {
        this.type = Enforce.notNull(type, "type cannot be null");
        this.relativePath = Enforce.notNull(relativePath, "relativePath cannot be null");
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isFile() {
        return this.type == Type.File;
    }

    public boolean isDirectory() {
        return this.type == Type.Directory;
    }

    public boolean isOther() {
        return this.type == Type.Other;
    }

    public String toString() {
        return "Listing{type=" + this.type + ", relativePath='" + this.relativePath + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Listing listing = (Listing)o;
        return this.type == listing.type && this.relativePath.equals(listing.relativePath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.relativePath});
    }

    public static enum Type {
        Directory,
        File,
        Other;

    }
}

