/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.assemblers;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.JA;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.PrefixMapping;

public class PrefixMappingAssembler
extends AssemblerBase
implements Assembler {
    @Override
    public Object open(Assembler a, Resource root2, Mode irrelevant) {
        this.checkType(root2, JA.PrefixMapping);
        return PrefixMappingAssembler.getPrefixes(a, root2, PrefixMapping.Factory.create());
    }

    public static PrefixMapping getPrefixes(Assembler a, Resource root2, PrefixMapping result) {
        PrefixMappingAssembler.setSimplePrefixes(root2, result);
        PrefixMappingAssembler.includePrefixesFor(a, root2, result, JA.includes);
        PrefixMappingAssembler.includePrefixesFor(a, root2, result, JA.prefixMapping);
        return result;
    }

    private static void includePrefixesFor(Assembler a, Resource root2, PrefixMapping result, Property includeUsing) {
        StmtIterator it = root2.listProperties(includeUsing);
        while (it.hasNext()) {
            Statement s2 = it.nextStatement();
            PrefixMapping sub = (PrefixMapping)a.open(PrefixMappingAssembler.getResource(s2));
            result.setNsPrefixes(sub);
        }
    }

    private static void setSimplePrefixes(Resource root2, PrefixMapping result) {
        if (root2.hasProperty(JA.prefix)) {
            Literal prefix = PrefixMappingAssembler.getUniqueLiteral(root2, JA.prefix);
            Literal namespace2 = PrefixMappingAssembler.getUniqueLiteral(root2, JA.namespace);
            result.setNsPrefix(prefix.getLexicalForm(), namespace2.getLexicalForm());
        }
    }
}

