/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.io.InputStream;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetCloseable;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.ResultSetMgr;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.rw.ReadAnything;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.resultset.RDFInput;
import org.apache.jena.sparql.resultset.RDFOutput;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.resultset.ResultSetMem;
import org.apache.jena.sparql.resultset.ResultSetPeekable;
import org.apache.jena.sparql.resultset.ResultSetPeeking;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderTable;

public class ResultSetFactory {
    public static ResultSet load(String filenameOrURI) {
        return ResultSetFactory.load(filenameOrURI, null);
    }

    public static ResultSet load(String filenameOrURI, ResultsFormat format) {
        if (format == null) {
            format = ResultsFormat.guessSyntax(filenameOrURI);
        }
        InputStream in = IO.openFile(filenameOrURI);
        return ResultSetFactory.load(in, format);
    }

    public static ResultSet load(InputStream input, ResultsFormat format) {
        Lang lang;
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultsFormat.FMT_RS_XML;
        }
        if ((lang = ResultsFormat.convert(format)) != null) {
            return ResultSetMgr.read(input, lang);
        }
        if (format.equals(ResultsFormat.FMT_TEXT)) {
            Log.warn(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultsFormat.FMT_RDF_XML)) {
            Model m4 = ModelFactory.createDefaultModel();
            m4.read(input, null);
            return RDFInput.fromRDF(m4);
        }
        if (format.equals(ResultsFormat.FMT_RDF_TTL)) {
            Model m5 = ModelFactory.createDefaultModel();
            m5.read(input, null, "TURTLE");
            return RDFInput.fromRDF(m5);
        }
        if (format.equals(ResultsFormat.FMT_RDF_N3)) {
            Model m6 = ModelFactory.createDefaultModel();
            m6.read(input, null, "N3");
            return RDFInput.fromRDF(m6);
        }
        if (format.equals(ResultsFormat.FMT_RDF_NT)) {
            Model m7 = ModelFactory.createDefaultModel();
            m7.read(input, null, "N-TRIPLES");
            return RDFInput.fromRDF(m7);
        }
        Log.warn(ResultSet.class, "Unknown result set syntax: " + format);
        return null;
    }

    public static Model loadAsModel(String filenameOrURI) {
        return ResultSetFactory.loadAsModel(null, filenameOrURI, null);
    }

    public static Model loadAsModel(Model model, String filenameOrURI) {
        return ResultSetFactory.loadAsModel(model, filenameOrURI, null);
    }

    public static Model loadAsModel(String filenameOrURI, ResultsFormat format) {
        return ResultSetFactory.loadAsModel(null, filenameOrURI, format);
    }

    public static Model loadAsModel(Model model, String filenameOrURI, ResultsFormat format) {
        if (model == null) {
            model = GraphFactory.makeDefaultModel();
        }
        if (format == null) {
            format = ResultsFormat.guessSyntax(filenameOrURI);
        }
        if (format == null) {
            Log.warn(ResultSet.class, "Null format - defaulting to XML");
            format = ResultsFormat.FMT_RS_XML;
        }
        if (format.equals(ResultsFormat.FMT_TEXT)) {
            Log.error(ResultSet.class, "Can't read a text result set");
            throw new ResultSetException("Can't read a text result set");
        }
        if (format.equals(ResultsFormat.FMT_RS_XML) || format.equals(ResultsFormat.FMT_RS_JSON)) {
            SPARQLResult x = ReadAnything.read(filenameOrURI);
            if (x.isResultSet()) {
                RDFOutput.encodeAsRDF(model, x.getResultSet());
            } else if (x.isBoolean()) {
                RDFOutput.encodeAsRDF(model, x.getBooleanResult());
            } else {
                throw new ResultSetException("Not a result set");
            }
            return model;
        }
        if (ResultsFormat.isRDFGraphSyntax(format)) {
            RDFDataMgr.read(model, filenameOrURI);
            return model;
        }
        Log.error(ResultSet.class, "Unknown result set syntax: " + format);
        return null;
    }

    public static SPARQLResult result(String filenameOrURI) {
        return ReadAnything.read(filenameOrURI);
    }

    public static ResultSet fromXML(InputStream in) {
        return ResultSetMgr.read(in, ResultSetLang.RS_XML);
    }

    public static ResultSet fromJSON(InputStream in) {
        return ResultSetMgr.read(in, ResultSetLang.RS_JSON);
    }

    public static ResultSet fromTSV(InputStream in) {
        return ResultSetMgr.read(in, ResultSetLang.RS_TSV);
    }

    public static ResultSet fromSSE(InputStream in) {
        Item item = SSE.parse(in);
        Log.warn(ResultSet.class, "Reading SSE result set not full implemented");
        BuilderTable.build(item);
        return null;
    }

    public static ResultSet makeResults(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(Model model) {
        return new RDFInput(model);
    }

    public static ResultSetRewindable makeRewindable(ResultSet resultSet) {
        if (resultSet instanceof ResultSetRewindable) {
            ResultSetRewindable rsw = (ResultSetRewindable)resultSet;
            rsw.reset();
            return rsw;
        }
        return new ResultSetMem(resultSet);
    }

    public static ResultSetPeekable makePeekable(ResultSet resultSet) {
        return new ResultSetPeeking(resultSet);
    }

    public static ResultSetCloseable closeableResultSet(QueryExecution queryExecution) {
        return ResultSetCloseable.closeableResultSet(queryExecution);
    }

    public static ResultSetRewindable copyResults(ResultSet results) {
        return new ResultSetMem(results);
    }

    public static ResultSet create(QueryIterator queryIterator, List<String> vars) {
        return new ResultSetStream(vars, null, queryIterator);
    }
}

