/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WriterDatasetRIOTFactory;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.lang.LangJSONLD11;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.writer.JsonLD11Writer;

public class SysJSONLD11 {
    private static boolean titaniumPresent = false;
    private static boolean jakartaJsonPresent = false;
    public static ReaderRIOTFactory jsonld11ReaderFactory;
    public static WriterDatasetRIOTFactory jsonld11WriterDatasetFactory;
    public static WriterGraphRIOTFactory jsonld11WriterGraphFactory;

    private static void chooseFactories() {
        if (titaniumPresent) {
            jsonld11ReaderFactory = (language, profile2) -> new LangJSONLD11();
            jsonld11WriterDatasetFactory = syntaxForm -> new JsonLD11Writer(syntaxForm);
            jsonld11WriterGraphFactory = syntaxForm -> RiotLib.adapter(new JsonLD11Writer(syntaxForm));
        } else {
            jsonld11ReaderFactory = (language, profile2) -> {
                throw new UnsupportedOperationException("Need both titanium-json-ld (1.1.0 or later) and org.glassfish:jakarta on the classpath");
            };
            jsonld11WriterDatasetFactory = syntaxForm -> {
                throw new UnsupportedOperationException("Need both titanium-json-ld (1.1.0 or later) and org.glassfish:jakarta on the classpath");
            };
            jsonld11WriterGraphFactory = syntaxForm -> {
                throw new UnsupportedOperationException("Need both titanium-json-ld (1.1.0 or later) and org.glassfish:jakarta on the classpath");
            };
        }
    }

    public static void init() {
        SysJSONLD11.checkForTitaniumOnClassPath();
        SysJSONLD11.chooseFactories();
        RDFParserRegistry.registerLangTriples(Lang.JSONLD11, jsonld11ReaderFactory);
        RDFParserRegistry.registerLangQuads(Lang.JSONLD11, jsonld11ReaderFactory);
        RDFWriterRegistry.register(RDFFormat.JSONLD11_PLAIN, jsonld11WriterGraphFactory);
        RDFWriterRegistry.register(RDFFormat.JSONLD11_PLAIN, jsonld11WriterDatasetFactory);
        RDFWriterRegistry.register(RDFFormat.JSONLD11_FLAT, jsonld11WriterGraphFactory);
        RDFWriterRegistry.register(RDFFormat.JSONLD11_FLAT, jsonld11WriterDatasetFactory);
    }

    public static void becomeDefaultJsonLd() {
        if (titaniumPresent) {
            RDFParserRegistry.registerLangTriples(Lang.JSONLD, jsonld11ReaderFactory);
            RDFParserRegistry.registerLangQuads(Lang.JSONLD, jsonld11ReaderFactory);
            return;
        }
        Log.warn(LangJSONLD11.class, "Titanium not configured - can't take over JSON-LD");
    }

    public static void checkForTitanium() {
        if (!titaniumPresent) {
            throw new RiotException("Artifact com.apicatalog:titanium-json-ld not on classpath");
        }
        if (!jakartaJsonPresent) {
            throw new RiotException("Artifact org.glassfish:jakarta not on classpath");
        }
    }

    static void checkForTitaniumOnClassPath() {
        try {
            Class.forName("com.apicatalog.jsonld.JsonLdVersion", false, Thread.currentThread().getContextClassLoader());
            titaniumPresent = true;
        }
        catch (ClassNotFoundException ex) {
            return;
        }
        try {
            Class.forName("jakarta.json.Json", false, Thread.currentThread().getContextClassLoader());
            jakartaJsonPresent = true;
        }
        catch (ClassNotFoundException ex) {
            return;
        }
    }
}

