/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.walker.Walker;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTripleTerm;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitorBase;

public class ExprVars {
    private static Action<Var> accVar = (a, var) -> a.add(var);
    private static Action<String> accVarName = (a, var) -> a.add(var.getVarName());

    public static Set<Var> getVarsMentioned(Expr expr) {
        HashSet<Var> acc = new HashSet<Var>();
        ExprVars.varsMentioned(acc, expr);
        return acc;
    }

    public static Set<Var> getNonOpVarsMentioned(Expr expr) {
        HashSet<Var> acc = new HashSet<Var>();
        ExprVars.nonOpVarsMentioned(acc, expr);
        return acc;
    }

    public static void varsMentioned(Collection<Var> acc, Expr expr) {
        ExprVarsWorker<Var> vv = new ExprVarsWorker<Var>(acc, accVar);
        Walker.walk(expr, vv);
    }

    public static void nonOpVarsMentioned(Collection<Var> acc, Expr expr) {
        ExprNoOpVarsWorker<Var> vv = new ExprNoOpVarsWorker<Var>(acc, accVar);
        Walker.walk(expr, vv);
    }

    public static Set<Var> getVarsMentioned(ExprList exprs) {
        HashSet<Var> acc = new HashSet<Var>();
        ExprVars.varsMentioned(acc, exprs);
        return acc;
    }

    public static void varsMentioned(Collection<Var> acc, ExprList exprs) {
        exprs.forEach(e2 -> ExprVars.varsMentioned(acc, e2));
    }

    public static Set<Var> getNonOpVarsMentioned(ExprList exprs) {
        HashSet<Var> acc = new HashSet<Var>();
        ExprVars.nonOpVarsMentioned(acc, exprs);
        return acc;
    }

    public static void nonOpVarsMentioned(Collection<Var> acc, ExprList exprs) {
        exprs.forEach(e2 -> ExprVars.nonOpVarsMentioned(acc, e2));
    }

    public static Set<String> getVarNamesMentioned(Expr expr) {
        HashSet<String> acc = new HashSet<String>();
        ExprVars.varNamesMentioned(acc, expr);
        return acc;
    }

    public static Set<String> getNonOpVarNamesMentioned(Expr expr) {
        HashSet<String> acc = new HashSet<String>();
        ExprVars.nonOpVarNamesMentioned(acc, expr);
        return acc;
    }

    public static void varNamesMentioned(Collection<String> acc, Expr expr) {
        ExprVarsWorker<String> vv = new ExprVarsWorker<String>(acc, accVarName);
        Walker.walk(expr, vv);
    }

    public static void nonOpVarNamesMentioned(Collection<String> acc, Expr expr) {
        ExprNoOpVarsWorker<String> vv = new ExprNoOpVarsWorker<String>(acc, accVarName);
        Walker.walk(expr, vv);
    }

    public static Set<Var> getVarsMentioned(SortCondition sortCondition) {
        HashSet<Var> acc = new HashSet<Var>();
        ExprVars.varsMentioned(acc, sortCondition);
        return acc;
    }

    public static Set<Var> getVarsMentioned(Collection<SortCondition> sortConditions) {
        HashSet<Var> acc = new HashSet<Var>();
        ExprVars.varsMentioned(acc, sortConditions);
        return acc;
    }

    public static void varsMentioned(Collection<Var> acc, SortCondition sortCondition) {
        ExprVars.varsMentioned(acc, sortCondition.getExpression());
    }

    public static void varsMentioned(Collection<Var> acc, Collection<SortCondition> sortConditions) {
        for (SortCondition sc : sortConditions) {
            ExprVars.varsMentioned(acc, sc);
        }
    }

    static class ExprVarsWorker<T>
    extends ExprNoOpVarsWorker<T> {
        public ExprVarsWorker(Collection<T> acc, Action<T> action) {
            super(acc, action);
        }

        @Override
        public void visit(ExprFunctionOp funcOp) {
            Set<Var> vars = OpVars.visibleVars(funcOp.getGraphPattern());
            for (Var v : vars) {
                this.action.var(this.acc, v);
            }
        }
    }

    static class ExprNoOpVarsWorker<T>
    extends ExprVisitorBase {
        protected final Collection<T> acc;
        protected final Action<T> action;

        public ExprNoOpVarsWorker(Collection<T> acc, Action<T> action) {
            this.acc = acc;
            this.action = action;
        }

        @Override
        public void visit(ExprVar nv) {
            this.action.var(this.acc, nv.asVar());
        }

        @Override
        public void visit(ExprTripleTerm exTripleTerm) {
            Triple t2 = exTripleTerm.getTriple();
            this.process(t2);
        }

        private void process(Triple t2) {
            this.process(t2.getSubject());
            this.process(t2.getPredicate());
            this.process(t2.getObject());
        }

        private void process(Node node) {
            if (Var.isVar(node)) {
                this.action.var(this.acc, Var.alloc(node));
                return;
            }
            if (node.isNodeTriple()) {
                this.process(node.getTriple());
            }
        }
    }

    @FunctionalInterface
    static interface Action<T> {
        public void var(Collection<T> var1, Var var2);
    }
}

