/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.api.exception;

import edu.wisc.library.ocfl.api.exception.OcflFileAlreadyExistsException;
import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.exception.OcflNoSuchFileException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;

public class OcflIOException
extends OcflJavaException {
    private final Exception cause;
    private final boolean hasMessage;

    public static OcflIOException from(IOException e2) {
        if (e2 instanceof NoSuchFileException || e2 instanceof FileNotFoundException) {
            return new OcflNoSuchFileException(e2);
        }
        if (e2 instanceof FileAlreadyExistsException) {
            return new OcflFileAlreadyExistsException(e2);
        }
        return new OcflIOException(e2);
    }

    public OcflIOException(Exception cause) {
        super(cause);
        this.cause = cause;
        this.hasMessage = false;
    }

    public OcflIOException(String message, Exception cause) {
        super(message, cause);
        this.cause = cause;
        this.hasMessage = true;
    }

    public OcflIOException(String message) {
        super(message);
        this.cause = null;
        this.hasMessage = true;
    }

    @Override
    public String getMessage() {
        if (this.hasMessage || this.cause == null) {
            return super.getMessage();
        }
        return this.cause.getClass().getSimpleName() + ": " + this.cause.getMessage();
    }
}

