/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.wisc.library.ocfl.api.exception.OcflJavaException;
import edu.wisc.library.ocfl.api.model.OcflVersion;

public enum InventoryType {
    OCFL_1_0("https://ocfl.io/1.0/spec/#inventory");

    private final String id;

    private InventoryType(String id) {
        this.id = id;
    }

    @JsonValue
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public OcflVersion getOcflVersion() {
        switch (this.id) {
            case "https://ocfl.io/1.0/spec/#inventory": {
                return OcflVersion.OCFL_1_0;
            }
        }
        throw new OcflJavaException("Unmapped inventory type " + this.id);
    }

    @JsonCreator
    public static InventoryType fromValue(String value) {
        for (InventoryType entry : InventoryType.values()) {
            if (!entry.id.equalsIgnoreCase(value)) continue;
            return entry;
        }
        throw new OcflJavaException("Unknown InventoryType: " + value);
    }
}

