/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.api.model;

import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.OcflObjectVersionFile;
import edu.wisc.library.ocfl.api.model.VersionDetails;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Map;

public class OcflObjectVersion {
    private final VersionDetails versionDetails;
    private final Map<String, OcflObjectVersionFile> fileMap;

    public OcflObjectVersion(VersionDetails versionDetails, Map<String, OcflObjectVersionFile> fileMap) {
        this.versionDetails = Enforce.notNull(versionDetails, "versionDetails cannot be null");
        this.fileMap = Enforce.notNull(fileMap, "fileMap cannot be null");
    }

    public ObjectVersionId getObjectVersionId() {
        return this.versionDetails.getObjectVersionId();
    }

    public String getObjectId() {
        return this.versionDetails.getObjectId();
    }

    public VersionNum getVersionNum() {
        return this.versionDetails.getVersionNum();
    }

    public OffsetDateTime getCreated() {
        return this.versionDetails.getCreated();
    }

    public VersionInfo getVersionInfo() {
        return this.versionDetails.getVersionInfo();
    }

    public boolean isMutable() {
        return this.versionDetails.isMutable();
    }

    public Collection<OcflObjectVersionFile> getFiles() {
        return this.fileMap.values();
    }

    public boolean containsFile(String path) {
        return this.fileMap.containsKey(path);
    }

    public OcflObjectVersionFile getFile(String path) {
        return this.fileMap.get(path);
    }

    public String toString() {
        return "OcflObjectVersion{versionDetails='" + this.versionDetails + "', fileMap=" + this.fileMap + "}";
    }
}

