/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core;

import edu.wisc.library.ocfl.api.OcflConstants;
import edu.wisc.library.ocfl.api.exception.CorruptObjectException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import edu.wisc.library.ocfl.core.util.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ObjectPaths {
    private ObjectPaths() {
    }

    public static Path objectNamastePath(Path objectRoot) {
        return objectRoot.resolve(OcflConstants.OBJECT_NAMASTE_1_0);
    }

    public static String objectNamastePath(String objectRoot) {
        return FileUtil.pathJoinFailEmpty(objectRoot, OcflConstants.OBJECT_NAMASTE_1_0);
    }

    public static Path inventoryPath(Path directory) {
        return directory.resolve("inventory.json");
    }

    public static String inventoryPath(String directory) {
        return FileUtil.pathJoinFailEmpty(directory, "inventory.json");
    }

    public static Path inventorySidecarPath(Path directory, Inventory inventory) {
        return directory.resolve("inventory.json." + inventory.getDigestAlgorithm().getOcflName());
    }

    public static String inventorySidecarPath(String directory, Inventory inventory) {
        return FileUtil.pathJoinFailEmpty(directory, "inventory.json." + inventory.getDigestAlgorithm().getOcflName());
    }

    public static Path findInventorySidecarPath(Path directory) {
        return ObjectPaths.findSidecarPathInternal(directory, "inventory.json.");
    }

    public static Path findMutableHeadRootInventorySidecarPath(Path directory) {
        return ObjectPaths.findSidecarPathInternal(directory, "root-inventory.json.");
    }

    public static Path logsPath(Path objectRoot) {
        return objectRoot.resolve("logs");
    }

    public static String logsPath(String objectRoot) {
        return FileUtil.pathJoinFailEmpty(objectRoot, "logs");
    }

    public static Path extensionsPath(Path objectRoot) {
        return objectRoot.resolve("extensions");
    }

    public static String extensionsPath(String objectRoot) {
        return FileUtil.pathJoinFailEmpty(objectRoot, "extensions");
    }

    public static Path mutableHeadInventoryPath(Path objectRootPath) {
        return ObjectPaths.inventoryPath(ObjectPaths.mutableHeadVersionPath(objectRootPath));
    }

    public static String mutableHeadInventoryPath(String objectRootPath) {
        return ObjectPaths.inventoryPath(ObjectPaths.mutableHeadVersionPath(objectRootPath));
    }

    public static String mutableHeadInventorySidecarPath(String objectRootPath, Inventory inventory) {
        return ObjectPaths.inventorySidecarPath(ObjectPaths.mutableHeadVersionPath(objectRootPath), inventory);
    }

    public static String mutableHeadVersionPath(String objectRootPath) {
        return FileUtil.pathJoinFailEmpty(objectRootPath, "extensions/0005-mutable-head/head");
    }

    public static Path mutableHeadVersionPath(Path objectRootPath) {
        return objectRootPath.resolve("extensions/0005-mutable-head/head");
    }

    public static String mutableHeadExtensionRoot(String objectRootPath) {
        return FileUtil.pathJoinFailEmpty(objectRootPath, "extensions/0005-mutable-head");
    }

    public static Path mutableHeadExtensionRoot(Path objectRootPath) {
        return objectRootPath.resolve("extensions/0005-mutable-head");
    }

    public static String mutableHeadRevisionsPath(String objectRootPath) {
        return FileUtil.pathJoinFailEmpty(objectRootPath, "extensions/0005-mutable-head/revisions");
    }

    public static Path mutableHeadRevisionsPath(Path objectRootPath) {
        return objectRootPath.resolve("extensions/0005-mutable-head/revisions");
    }

    public static ObjectRoot objectRoot(Inventory inventory) {
        Enforce.notNull(inventory, "inventory cannot be null");
        return new ObjectRoot(inventory);
    }

    private static Path findSidecarPathInternal(Path directory, String prefix) {
        Path path;
        block9: {
            Stream<Path> files = Files.list(directory);
            try {
                List sidecars = files.filter(file -> file.getFileName().toString().startsWith(prefix)).collect(Collectors.toList());
                if (sidecars.size() != 1) {
                    throw new CorruptObjectException(String.format("Expected there to be one inventory sidecar file in %s, but found %s.", directory, sidecars.size()));
                }
                path = (Path)sidecars.get(0);
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new OcflIOException(e2);
                }
            }
            files.close();
        }
        return path;
    }

    public static class ContentRoot {
        private final Inventory inventory;
        private final String path;

        private ContentRoot(Inventory inventory, String path) {
            this.inventory = inventory;
            this.path = path == null ? "" : path;
        }

        public String objectId() {
            return this.inventory.getId();
        }

        private String path() {
            return this.path;
        }

        public String revisionPath(RevisionNum revisionNum) {
            return FileUtil.pathJoinIgnoreEmpty(this.path, revisionNum.toString());
        }

        public String headRevisionPath() {
            if (this.inventory.getRevisionNum() == null) {
                return null;
            }
            return this.revisionPath(this.inventory.getRevisionNum());
        }
    }

    public static class VersionRoot
    implements HasInventory {
        private final Inventory inventory;
        private final String path;
        private String inventoryFile;
        private String inventorySidecar;
        private String contentPath;
        private ContentRoot contentRoot;

        private VersionRoot(Inventory inventory, String path) {
            this.inventory = inventory;
            this.path = path == null ? "" : path;
        }

        public String objectId() {
            return this.inventory.getId();
        }

        public String path() {
            return this.path;
        }

        @Override
        public String inventoryFile() {
            if (this.inventoryFile == null) {
                this.inventoryFile = ObjectPaths.inventoryPath(this.path);
            }
            return this.inventoryFile;
        }

        @Override
        public String inventorySidecar() {
            if (this.inventorySidecar == null) {
                this.inventorySidecar = ObjectPaths.inventorySidecarPath(this.path, this.inventory);
            }
            return this.inventorySidecar;
        }

        public String contentPath() {
            if (this.contentPath == null) {
                this.contentPath = FileUtil.pathJoinIgnoreEmpty(this.path, this.inventory.resolveContentDirectory());
            }
            return this.contentPath;
        }

        public ContentRoot contentRoot() {
            if (this.contentRoot == null) {
                this.contentRoot = new ContentRoot(this.inventory, this.contentPath());
            }
            return this.contentRoot;
        }
    }

    public static class ObjectRoot
    implements HasInventory {
        private final Inventory inventory;
        private final String path;
        private String inventoryFile;
        private String inventorySidecar;
        private String headVersionPath;
        private String mutableHeadExtPath;
        private String mutableHeadPath;
        private String mutableHeadRevisionsPath;
        private VersionRoot headVersion;
        private VersionRoot mutableHeadVersion;

        private ObjectRoot(Inventory inventory) {
            this.inventory = inventory;
            this.path = inventory.getObjectRootPath();
        }

        public String path() {
            return this.path;
        }

        public String objectId() {
            return this.inventory.getId();
        }

        @Override
        public String inventoryFile() {
            if (this.inventoryFile == null) {
                this.inventoryFile = ObjectPaths.inventoryPath(this.path);
            }
            return this.inventoryFile;
        }

        @Override
        public String inventorySidecar() {
            if (this.inventorySidecar == null) {
                this.inventorySidecar = ObjectPaths.inventorySidecarPath(this.path, this.inventory);
            }
            return this.inventorySidecar;
        }

        public String versionPath(VersionNum versionNum) {
            if (this.inventory.getHead().equals(versionNum)) {
                return this.headVersionPath();
            }
            return FileUtil.pathJoinIgnoreEmpty(this.path, versionNum.toString());
        }

        public String headVersionPath() {
            if (this.headVersionPath == null) {
                this.headVersionPath = this.inventory.hasMutableHead() ? this.mutableHeadPath() : FileUtil.pathJoinIgnoreEmpty(this.path, this.inventory.getHead().toString());
            }
            return this.headVersionPath;
        }

        public String mutableHeadExtensionPath() {
            if (this.mutableHeadExtPath == null) {
                this.mutableHeadExtPath = ObjectPaths.mutableHeadExtensionRoot(this.path);
            }
            return this.mutableHeadExtPath;
        }

        public String mutableHeadPath() {
            if (this.mutableHeadPath == null) {
                this.mutableHeadPath = ObjectPaths.mutableHeadVersionPath(this.path);
            }
            return this.mutableHeadPath;
        }

        public String mutableHeadRevisionsPath() {
            if (this.mutableHeadRevisionsPath == null) {
                this.mutableHeadRevisionsPath = ObjectPaths.mutableHeadRevisionsPath(this.path);
            }
            return this.mutableHeadRevisionsPath;
        }

        public VersionRoot version(VersionNum versionNum) {
            return new VersionRoot(this.inventory, this.versionPath(versionNum));
        }

        public VersionRoot headVersion() {
            if (this.headVersion == null) {
                this.headVersion = new VersionRoot(this.inventory, this.headVersionPath());
            }
            return this.headVersion;
        }

        public VersionRoot mutableHeadVersion() {
            if (this.mutableHeadVersion == null) {
                this.mutableHeadVersion = new VersionRoot(this.inventory, this.mutableHeadPath());
            }
            return this.mutableHeadVersion;
        }
    }

    public static interface HasInventory {
        public String inventoryFile();

        public String inventorySidecar();
    }
}

