/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension.storage.layout.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.wisc.library.ocfl.api.exception.OcflExtensionException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import java.util.Objects;

public class NTupleOmitPrefixStorageLayoutConfig
implements OcflExtensionConfig {
    private static final int DEFAULT_TUPLE_SIZE = 3;
    private static final int DEFAULT_NUM_TUPLES = 3;
    private static final ZeroPadding DEFAULT_PADDING = ZeroPadding.LEFT;
    private static final boolean DEFAULT_REVERSE_ROOT = false;
    private String delimiter;
    private int tupleSize = 3;
    private int numberOfTuples = 3;
    private ZeroPadding zeroPadding = DEFAULT_PADDING;
    private boolean reverseObjectRoot = false;

    @Override
    public String getExtensionName() {
        return "0007-n-tuple-omit-prefix-storage-layout";
    }

    public void setExtensionName(String extensionName) {
        if (!Objects.equals(this.getExtensionName(), extensionName)) {
            throw new OcflExtensionException(String.format("The extension name for %s must be %s; found %s.", this.getClass().getSimpleName(), this.getExtensionName(), extensionName));
        }
    }

    @Override
    @JsonIgnore
    public boolean hasParameters() {
        return true;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public int getTupleSize() {
        return this.tupleSize;
    }

    public int getNumberOfTuples() {
        return this.numberOfTuples;
    }

    public ZeroPadding getZeroPadding() {
        return this.zeroPadding;
    }

    public boolean isReverseObjectRoot() {
        return this.reverseObjectRoot;
    }

    public NTupleOmitPrefixStorageLayoutConfig setDelimiter(String delimiter) {
        this.delimiter = Enforce.expressionTrue(delimiter != null && !delimiter.isEmpty(), delimiter, "delimiter must not be empty");
        return this;
    }

    public NTupleOmitPrefixStorageLayoutConfig setTupleSize(Integer tupleSize) {
        this.tupleSize = tupleSize == null ? 3 : Enforce.expressionTrue(tupleSize >= 1 && tupleSize <= 32, tupleSize, "tupleSize must be between 1 and 32 inclusive");
        return this;
    }

    public NTupleOmitPrefixStorageLayoutConfig setNumberOfTuples(Integer numberOfTuples) {
        this.numberOfTuples = numberOfTuples == null ? 3 : Enforce.expressionTrue(numberOfTuples >= 1 && numberOfTuples <= 32, numberOfTuples, "numberOfTuples must be between 1 and 32 inclusive");
        return this;
    }

    public NTupleOmitPrefixStorageLayoutConfig setZeroPadding(ZeroPadding zeroPadding) {
        this.zeroPadding = zeroPadding == null ? DEFAULT_PADDING : zeroPadding;
        return this;
    }

    public NTupleOmitPrefixStorageLayoutConfig setReverseObjectRoot(Boolean reverseObjectRoot) {
        this.reverseObjectRoot = reverseObjectRoot == null ? false : reverseObjectRoot;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NTupleOmitPrefixStorageLayoutConfig that = (NTupleOmitPrefixStorageLayoutConfig)o;
        return this.delimiter.equals(that.delimiter) && this.tupleSize == that.tupleSize && this.numberOfTuples == that.numberOfTuples && this.zeroPadding == that.zeroPadding && this.reverseObjectRoot == that.reverseObjectRoot;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.delimiter, this.tupleSize, this.numberOfTuples, this.reverseObjectRoot, this.zeroPadding});
    }

    public String toString() {
        return "NTupleOmitPrefixStorageLayoutConfig{ delimiter='" + this.delimiter + "', tupleSize='" + this.tupleSize + "', numberOfTuples='" + this.numberOfTuples + "', zeroPadding='" + this.zeroPadding + "', reverseObjectRoot='" + this.reverseObjectRoot + "' }";
    }

    public static enum ZeroPadding {
        LEFT,
        RIGHT;


        @JsonValue
        public String toJson() {
            return this.name().toLowerCase();
        }
    }
}

