/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.path.constraint;

import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.path.constraint.BackslashPathSeparatorConstraint;
import edu.wisc.library.ocfl.core.path.constraint.BeginEndPathConstraint;
import edu.wisc.library.ocfl.core.path.constraint.ContentPathConstraintProcessor;
import edu.wisc.library.ocfl.core.path.constraint.FileNameConstraint;
import edu.wisc.library.ocfl.core.path.constraint.NonEmptyFileNameConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathCharConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraintProcessor;
import edu.wisc.library.ocfl.core.path.constraint.RegexPathConstraint;
import java.nio.file.FileSystems;
import java.util.regex.Pattern;

public class DefaultContentPathConstraintProcessor
implements ContentPathConstraintProcessor {
    private static final PathConstraint LEADING_SLASH_CONSTRAINT = BeginEndPathConstraint.mustNotBeginWith("/");
    private static final PathConstraint TRAILING_SLASH_CONSTRAINT = BeginEndPathConstraint.mustNotEndWith("/");
    private static final FileNameConstraint DOT_CONSTRAINT = RegexPathConstraint.mustNotContain(Pattern.compile("^\\.{1,2}$"));
    private static final FileNameConstraint NON_EMPTY_CONSTRAINT = new NonEmptyFileNameConstraint();
    private static final PathCharConstraint BACKSLASH_CONSTRAINT = new BackslashPathSeparatorConstraint();
    private final PathConstraintProcessor storagePathConstraintProcessor;
    private final PathConstraintProcessor contentPathConstraintProcessor;

    public static Builder builder() {
        return new Builder();
    }

    public DefaultContentPathConstraintProcessor(PathConstraintProcessor storagePathConstraintProcessor, PathConstraintProcessor contentPathConstraintProcessor) {
        this.storagePathConstraintProcessor = Enforce.notNull(storagePathConstraintProcessor, "storagePathConstraintProcessor cannot be null");
        this.contentPathConstraintProcessor = Enforce.notNull(contentPathConstraintProcessor, "contentPathConstraintProcessor cannot be null");
        if (this.filesystemUsesBackslashSeparator()) {
            this.contentPathConstraintProcessor.prependCharConstraint(BACKSLASH_CONSTRAINT);
        }
        this.contentPathConstraintProcessor.prependFileNameConstraint(DOT_CONSTRAINT).prependFileNameConstraint(NON_EMPTY_CONSTRAINT).prependPathConstraint(TRAILING_SLASH_CONSTRAINT).prependPathConstraint(LEADING_SLASH_CONSTRAINT);
    }

    @Override
    public void apply(String contentPath, String storagePath) {
        this.storagePathConstraintProcessor.apply(storagePath);
        this.contentPathConstraintProcessor.apply(contentPath);
    }

    @Override
    public void apply(String contentPath) {
        this.contentPathConstraintProcessor.apply(contentPath);
    }

    private boolean filesystemUsesBackslashSeparator() {
        char pathSeparator = FileSystems.getDefault().getSeparator().charAt(0);
        return pathSeparator == '\\';
    }

    public static class Builder {
        private PathConstraintProcessor storagePathConstraintProcessor = PathConstraintProcessor.builder().build();
        private PathConstraintProcessor contentPathConstraintProcessor = PathConstraintProcessor.builder().build();

        public Builder storagePathConstraintProcessor(PathConstraintProcessor storagePathConstraintProcessor) {
            this.storagePathConstraintProcessor = Enforce.notNull(storagePathConstraintProcessor, "storagePathConstraintProcessor cannot be null");
            return this;
        }

        public Builder contentPathConstraintProcessor(PathConstraintProcessor contentPathConstraintProcessor) {
            this.contentPathConstraintProcessor = Enforce.notNull(contentPathConstraintProcessor, "contentPathConstraintProcessor cannot be null");
            return this;
        }

        public DefaultContentPathConstraintProcessor build() {
            return new DefaultContentPathConstraintProcessor(this.storagePathConstraintProcessor, this.contentPathConstraintProcessor);
        }
    }
}

