/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.transitiveReasoner;

import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.BaseInfGraph;
import org.apache.jena.reasoner.FGraph;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.FinderUtil;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveEngine;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveReasoner;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.UniqueFilter;

public class TransitiveInfGraph
extends BaseInfGraph {
    protected TransitiveEngine transitiveEngine;
    protected Finder tbox = null;
    protected Finder dataFind;

    public TransitiveInfGraph(Graph data, TransitiveReasoner reasoner) {
        super(data, reasoner);
    }

    @Override
    public synchronized void prepare() {
        if (this.isPrepared()) {
            return;
        }
        this.tbox = ((TransitiveReasoner)this.reasoner).getTbox();
        this.transitiveEngine = new TransitiveEngine(((TransitiveReasoner)this.reasoner).getSubClassCache().deepCopy(), ((TransitiveReasoner)this.reasoner).getSubPropertyCache().deepCopy());
        this.dataFind = this.transitiveEngine.insert(this.tbox, this.fdata);
        this.transitiveEngine.setCaching(true, true);
        this.setPreparedState(true);
    }

    @Override
    public Graph getSchemaGraph() {
        if (this.tbox == null) {
            return null;
        }
        if (this.tbox instanceof FGraph) {
            return ((FGraph)this.tbox).getGraph();
        }
        throw new ReasonerException("Transitive reasoner got into an illegal state");
    }

    @Override
    public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation) {
        this.checkOpen();
        this.requirePrepared();
        Finder cascade = this.transitiveEngine.getFinder(pattern, FinderUtil.cascade(this.tbox, continuation));
        return cascade.find(pattern).filterKeep(new UniqueFilter());
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), this.fdata);
    }

    @Override
    public ExtendedIterator<Triple> find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, this.fdata);
    }

    @Override
    public synchronized void performAdd(Triple t2) {
        this.requirePrepared();
        this.fdata.getGraph().add(t2);
        this.transitiveEngine.add(t2);
    }

    @Override
    public synchronized void performDelete(Triple t2) {
        this.fdata.getGraph().delete(t2);
        if (this.isPrepared()) {
            this.transitiveEngine.delete(t2);
        }
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfFindSafeCapabilities();
        }
        return this.capabilities;
    }
}

