/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.apache.jena.JenaRuntime;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.SetupJenaIRI;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdfxml.xmlinput.ALiteral;
import org.apache.jena.rdfxml.xmlinput.ARP;
import org.apache.jena.rdfxml.xmlinput.ARPOptions;
import org.apache.jena.rdfxml.xmlinput.AResource;
import org.apache.jena.rdfxml.xmlinput.NamespaceHandler;
import org.apache.jena.rdfxml.xmlinput.ParseException;
import org.apache.jena.rdfxml.xmlinput.StatementHandler;
import org.apache.jena.rdfxml.xmlinput.impl.ARPSaxErrorHandler;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.Checker;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReaderRIOTRDFXML
implements ReaderRIOT {
    public static ReaderRIOTFactory factory = (language, parserProfile) -> new ReaderRIOTRDFXML(parserProfile.getErrorHandler());
    private ARP arp = new ARP();
    private InputStream input = null;
    private Reader reader = null;
    private String xmlBase;
    private String filename;
    private StreamRDF sink;
    private ErrorHandler errorHandler;
    private Context context;
    public static boolean RiotUniformCompatibility = false;
    private static int[] additionalErrors = new int[]{115};
    private static boolean errorForSpaceInURI = true;

    public ReaderRIOTRDFXML(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        this.input = in;
        this.xmlBase = ReaderRIOTRDFXML.baseURI_RDFXML(baseURI);
        this.filename = baseURI;
        this.sink = output;
        this.context = context2;
        this.parse();
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        this.reader = reader;
        this.xmlBase = ReaderRIOTRDFXML.baseURI_RDFXML(baseURI);
        this.filename = baseURI;
        this.sink = output;
        this.context = context2;
        this.parse();
    }

    private void oneProperty(ARPOptions options, String pName, Object value) {
        int val;
        int cond;
        block8: {
            block9: {
                block7: {
                    if (!(pName.startsWith("ERR_") || pName.startsWith("IGN_") || pName.startsWith("WARN_"))) {
                        return;
                    }
                    cond = ParseException.errorCode(pName);
                    if (cond == -1) {
                        throw new RiotException("No such ARP property: '" + pName + "'");
                    }
                    if (!(value instanceof String)) break block7;
                    if (!((String)value).startsWith("EM_")) {
                        throw new RiotException("Value for ARP property does not start EM_: '" + pName + "' = '" + value + "'");
                    }
                    val = ParseException.errorCode((String)value);
                    if (val == -1) {
                        throw new RiotException("Illegal value for ARP property: '" + pName + "' = '" + value + "'");
                    }
                    break block8;
                }
                if (!(value instanceof Integer)) break block9;
                val = (Integer)value;
                switch (val) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break block8;
                    }
                    default: {
                        throw new RiotException("Illegal value for ARP property: '" + pName + "' = '" + value + "'");
                    }
                }
            }
            throw new RiotException("Property \"" + pName + "\" cannot have value: " + value.toString());
        }
        options.setErrorMode(cond, val);
    }

    public void parse() {
        this.sink.start();
        HandlerSink rslt = new HandlerSink(this.sink, this.errorHandler);
        this.arp.getHandlers().setStatementHandler(rslt);
        this.arp.getHandlers().setErrorHandler(rslt);
        this.arp.getHandlers().setNamespaceHandler(rslt);
        ARPOptions arpOptions = this.arp.getOptions();
        if (RiotUniformCompatibility) {
            for (int code : additionalErrors) {
                arpOptions.setErrorMode(code, 2);
            }
        }
        if (JenaRuntime.isRDF11) {
            this.arp.getOptions().setIRIFactory(SetupJenaIRI.iriFactory_RDFXML());
        }
        if (this.context != null) {
            Map properties = null;
            try {
                Map p;
                properties = p = (Map)this.context.get(SysRIOT.sysRdfReaderProperties);
            }
            catch (Throwable ex) {
                Log.warn(this, "Problem accessing the RDF/XML reader properties: properties ignored", ex);
            }
            if (properties != null) {
                properties.forEach((k, v) -> this.oneProperty(arpOptions, (String)k, v));
            }
        }
        this.arp.setOptionsWith(arpOptions);
        try {
            if (this.reader != null) {
                this.arp.load(this.reader, this.xmlBase);
            } else {
                this.arp.load(this.input, this.xmlBase);
            }
        }
        catch (IOException e2) {
            this.errorHandler.error(this.filename + ": " + ParseException.formatMessage(e2), -1L, -1L);
        }
        catch (SAXParseException e2) {
        }
        catch (SAXException sax) {
            this.errorHandler.error(this.filename + ": " + ParseException.formatMessage(sax), -1L, -1L);
        }
        this.sink.finish();
    }

    private static String baseURI_RDFXML(String baseIRI) {
        if (baseIRI == null) {
            return IRIs.getBaseStr();
        }
        return IRIs.toBase(baseIRI);
    }

    private static class ErrorHandlerBridge
    implements RDFErrorHandler {
        private ErrorHandler errorHandler;

        ErrorHandlerBridge(ErrorHandler hander) {
            this.errorHandler = hander;
        }

        @Override
        public void warning(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.warning(e2.getMessage(), p.getLeft().intValue(), p.getRight().intValue());
        }

        @Override
        public void error(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.error(e2.getMessage(), p.getLeft().intValue(), p.getRight().intValue());
        }

        @Override
        public void fatalError(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.fatal(e2.getMessage(), p.getLeft().intValue(), p.getRight().intValue());
        }

        private static Pair<Integer, Integer> getLineCol(Exception e2) {
            if (e2 instanceof SAXParseException) {
                SAXParseException esax = (SAXParseException)e2;
                return Pair.create(esax.getLineNumber(), esax.getColumnNumber());
            }
            return Pair.create(-1, -1);
        }
    }

    private static class HandlerSink
    extends ARPSaxErrorHandler
    implements StatementHandler,
    NamespaceHandler {
        private StreamRDF output;
        private ErrorHandler riotErrorHandler;

        HandlerSink(StreamRDF output, ErrorHandler errHandler) {
            super(new ErrorHandlerBridge(errHandler));
            this.output = output;
            this.riotErrorHandler = errHandler;
        }

        @Override
        public void statement(AResource subj, AResource pred, AResource obj) {
            this.output.triple(this.convert(subj, pred, obj));
        }

        @Override
        public void statement(AResource subj, AResource pred, ALiteral lit) {
            this.output.triple(this.convert(subj, pred, lit));
        }

        private static Node convert(ALiteral lit) {
            String dtURI = lit.getDatatypeURI();
            if (dtURI == null) {
                return NodeFactory.createLiteral(lit.toString(), lit.getLang());
            }
            if (lit.isWellFormedXML()) {
                return NodeFactory.createLiteral(lit.toString(), null, true);
            }
            RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtURI);
            return NodeFactory.createLiteral(lit.toString(), dt);
        }

        private Node convert(AResource r) {
            if (!r.isAnonymous()) {
                String uriStr = r.getURI();
                if (errorForSpaceInURI && uriStr.contains(" ")) {
                    int i = uriStr.indexOf(32);
                    String s2 = uriStr.substring(0, i);
                    String msg = String.format("Bad character in IRI (space): <%s[space]...>", s2);
                    this.riotErrorHandler.error(msg, -1L, -1L);
                    throw new RiotParseException(msg, -1L, -1L);
                }
                return NodeFactory.createURI(uriStr);
            }
            Node rr = (Node)r.getUserData();
            if (rr == null) {
                rr = NodeFactory.createBlankNode();
                r.setUserData(rr);
            }
            return rr;
        }

        private Triple convert(AResource s2, AResource p, AResource o) {
            return Triple.create(this.convert(s2), this.convert(p), this.convert(o));
        }

        private Triple convert(AResource s2, AResource p, ALiteral o) {
            Node literal = HandlerSink.convert(o);
            Checker.checkLiteral(literal, this.riotErrorHandler, -1L, -1L);
            return Triple.create(this.convert(s2), this.convert(p), literal);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            this.output.prefix(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }
    }
}

