/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.PrintSerializableBase;

public abstract class PlanBase
extends PrintSerializableBase
implements Plan {
    private Op op = null;
    protected Closeable closeable = null;
    protected boolean closed = false;
    private boolean iteratorProduced = false;

    protected abstract QueryIterator iteratorOnce();

    protected PlanBase(Op op, Closeable closeable) {
        this.op = op;
        this.closeable = closeable;
    }

    @Override
    public Op getOp() {
        return this.op;
    }

    @Override
    public final QueryIterator iterator() {
        if (this.iteratorProduced) {
            throw new ARQInternalErrorException("Attempt to use the iterator twice");
        }
        this.iteratorProduced = true;
        return this.iteratorOnce();
    }

    @Override
    public void output(IndentedWriter out) {
        SerializationContext sCxt = new SerializationContext(ARQConstants.getGlobalPrefixMap());
        this.output(out, sCxt);
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        this.op.output(out, sCxt);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.closeable != null) {
            this.closeable.close();
        }
        this.closed = true;
    }
}

