/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.migration.pidlist;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.fcrepo.migration.pidlist.PidListManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumePidListManager
implements PidListManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResumePidListManager.class);
    private File resumeFile;
    private boolean acceptAll;
    private int pidResumeIndex;
    private String pidResumeValue;
    private int index = 0;
    private String value = "foo";

    public ResumePidListManager(File pidDir, boolean acceptAll) {
        if (!pidDir.exists()) {
            pidDir.mkdirs();
        }
        if (!pidDir.isDirectory()) {
            throw new IllegalArgumentException("Arg must be a directory: " + pidDir.getAbsolutePath());
        }
        this.acceptAll = acceptAll;
        this.resumeFile = new File(pidDir, "resume.txt");
        LOGGER.debug("Resume pid file: {}, accept all? {}", (Object)this.resumeFile.getAbsolutePath(), (Object)acceptAll);
        try {
            this.loadResumeFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadResumeFile() throws IOException {
        if (!this.resumeFile.exists() || this.resumeFile.length() == 0L) {
            this.updateResumeFile(this.value, this.index);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.resumeFile));){
            this.pidResumeValue = reader.readLine();
            this.pidResumeIndex = Integer.parseInt(reader.readLine());
        }
    }

    @Override
    public boolean accept(String pid) {
        String logMsg = "PID: " + pid + ", accept? ";
        String previousValue = this.value;
        this.value = pid;
        ++this.index;
        if (this.index - 1 < this.pidResumeIndex) {
            LOGGER.debug(logMsg + this.acceptAll);
            return this.acceptAll;
        }
        if (this.index - 1 == this.pidResumeIndex && !previousValue.equalsIgnoreCase(this.pidResumeValue)) {
            String msg = "Number of accept requests does not align with expected PID value! index: " + this.index + ", pid: " + pid + ", expected pid: " + this.pidResumeValue;
            throw new IllegalStateException(msg);
        }
        this.updateResumeFile(this.value, this.index);
        LOGGER.debug(logMsg + "true");
        return true;
    }

    void reset() {
        this.index = 0;
        this.value = "foo";
        this.updateResumeFile(this.value, this.index);
    }

    private void updateResumeFile(String pid, int index) {
        PrintWriter resumeFileWriter = null;
        try {
            resumeFileWriter = new PrintWriter(new FileWriter(this.resumeFile, false));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        resumeFileWriter.write(pid);
        resumeFileWriter.write(System.getProperty("line.separator"));
        resumeFileWriter.write(Integer.toString(index));
        resumeFileWriter.flush();
        resumeFileWriter.close();
    }
}

