/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.db;

import edu.wisc.library.ocfl.core.db.BaseObjectDetailsDatabase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class MariaDbObjectDetailsDatabase
extends BaseObjectDetailsDatabase {
    private static final String LOCK_FAIL_STATE = "HY000";
    private static final String DEADLOCK_STATE = "40001";
    private static final String DUPLICATE_KEY_STATE = "23000";

    public MariaDbObjectDetailsDatabase(String tableName, DataSource dataSource, boolean storeInventory, long waitTime, TimeUnit timeUnit) {
        super(tableName, dataSource, storeInventory, waitTime, timeUnit, LOCK_FAIL_STATE);
    }

    @Override
    protected String updateDetailsQuery(String tableName) {
        return String.format("UPDATE %s SET version_id = ?, object_root_path = ?, revision_id = ?, inventory_digest = ?, digest_algorithm = ?, inventory = ?, update_timestamp = ? WHERE object_id = ?", tableName);
    }

    @Override
    protected void setLockWaitTimeout(Connection connection, long waitMillis) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(String.format("SET innodb_lock_wait_timeout = %s", TimeUnit.MILLISECONDS.toSeconds(waitMillis)));){
            statement.executeUpdate();
        }
    }

    @Override
    protected boolean isConcurrentWriteException(SQLException exception) {
        return Objects.equals(exception.getSQLState(), DEADLOCK_STATE) || Objects.equals(exception.getSQLState(), DUPLICATE_KEY_STATE);
    }
}

