/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.extension.storage.layout;

import edu.wisc.library.ocfl.api.exception.OcflExtensionException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.storage.layout.OcflStorageLayoutExtension;
import edu.wisc.library.ocfl.core.extension.storage.layout.config.NTupleOmitPrefixStorageLayoutConfig;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTupleOmitPrefixStorageLayoutExtension
implements OcflStorageLayoutExtension {
    private static final Logger LOG = LoggerFactory.getLogger(NTupleOmitPrefixStorageLayoutExtension.class);
    public static final String EXTENSION_NAME = "0007-n-tuple-omit-prefix-storage-layout";
    private static final Pattern ASCII_ONLY = Pattern.compile("\\A\\p{ASCII}*\\z");
    private NTupleOmitPrefixStorageLayoutConfig config;
    private String delimiter;
    private boolean caseMatters;

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    @Override
    public String getDescription() {
        return "This storage root extension describes an OCFL storage layout combining a pairtree-like root directory structure derived from prefix-omitted object identifiers, followed by the prefix-omitted object identifier themselves. The OCFL object identifiers are expected to contain prefixes which are removed in the mapping to directory names. The OCFL object identifier prefix is defined as all characters before and including a configurable delimiter. Where the prefix-omitted identifier length is less than tuple size * number of tuples, the remaining object id (prefix omitted) is left or right-side, zero-padded (configurable, left default), or not padded (none), and optionally reversed (default false). The object id is then divided into N n-tuple segments, and used to create nested paths under the OCFL storage root, followed by the prefix-omitted object id directory.";
    }

    @Override
    public synchronized void init(OcflExtensionConfig config) {
        Enforce.notNull(config, "configFile cannot be null");
        if (!(config instanceof NTupleOmitPrefixStorageLayoutConfig)) {
            throw new OcflExtensionException(String.format("This extension only supports %s configuration. Received: %s", this.getExtensionConfigClass(), config));
        }
        this.config = (NTupleOmitPrefixStorageLayoutConfig)config;
        this.delimiter = this.config.getDelimiter().toLowerCase();
        this.caseMatters = !this.delimiter.equals(this.config.getDelimiter());
    }

    @Override
    public Class<? extends OcflExtensionConfig> getExtensionConfigClass() {
        return NTupleOmitPrefixStorageLayoutConfig.class;
    }

    @Override
    public String mapObjectId(String objectId) {
        if (this.config == null) {
            throw new OcflExtensionException("This extension must be initialized before it can be used.");
        }
        if (!ASCII_ONLY.matcher(objectId).matches()) {
            throw new OcflExtensionException(String.format("This id %s must contain only ASCII characters.", objectId));
        }
        String id = this.caseMatters ? objectId.toLowerCase() : objectId;
        int index = id.lastIndexOf(this.delimiter);
        if (index == -1) {
            throw new OcflExtensionException(String.format("The delimiter %s cannot be found in %s.", this.delimiter, objectId));
        }
        Object section = objectId.substring(index + this.delimiter.length());
        String baseObjectId = section;
        if (((String)section).isEmpty()) {
            throw new OcflExtensionException(String.format("The object id <%s> is incompatible with layout extension %s because it produces an empty value.", objectId, EXTENSION_NAME));
        }
        if (this.config.isReverseObjectRoot()) {
            section = new StringBuilder((String)section).reverse().toString();
        }
        if (((String)section).length() < this.config.getTupleSize() * this.config.getNumberOfTuples()) {
            int paddingAmount = this.config.getTupleSize() * this.config.getNumberOfTuples();
            String padding = "0".repeat(paddingAmount - ((String)section).length());
            section = this.config.getZeroPadding() == NTupleOmitPrefixStorageLayoutConfig.ZeroPadding.RIGHT ? (String)section + padding : padding + (String)section;
        }
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 0; i < this.config.getNumberOfTuples(); ++i) {
            int start = i * this.config.getTupleSize();
            int end = start + this.config.getTupleSize();
            pathBuilder.append((CharSequence)section, start, end).append("/");
        }
        pathBuilder.append(baseObjectId);
        return pathBuilder.toString();
    }
}

