/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.path.constraint;

import edu.wisc.library.ocfl.api.exception.PathConstraintException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.path.constraint.FileNameConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraint;
import java.util.regex.Pattern;

public class RegexPathConstraint
implements PathConstraint,
FileNameConstraint {
    private final Pattern pattern;
    private final boolean mustMatch;

    public static RegexPathConstraint mustNotContain(Pattern pattern) {
        return new RegexPathConstraint(false, pattern);
    }

    public static RegexPathConstraint mustContain(Pattern pattern) {
        return new RegexPathConstraint(true, pattern);
    }

    public RegexPathConstraint(boolean mustMatch, Pattern pattern) {
        this.mustMatch = mustMatch;
        this.pattern = Enforce.notNull(pattern, "pattern cannot be null");
    }

    @Override
    public void apply(String path) {
        if (this.pattern.matcher(path).matches()) {
            if (!this.mustMatch) {
                throw new PathConstraintException(String.format("The path contains an invalid sequence %s. Path: %s", this.pattern, path));
            }
        } else if (this.mustMatch) {
            throw new PathConstraintException(String.format("The path must contain a sequence %s but does not. Path: %s", this.pattern, path));
        }
    }

    @Override
    public void apply(String fileName, String path) {
        if (this.pattern.matcher(fileName).matches()) {
            if (!this.mustMatch) {
                throw new PathConstraintException(String.format("The filename '%s' contains an invalid sequence %s. Path: %s", fileName, this.pattern, path));
            }
        } else if (this.mustMatch) {
            throw new PathConstraintException(String.format("The filename '%s' must contain a sequence %s but does not. Path: %s", fileName, this.pattern, path));
        }
    }
}

