/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage;

import edu.wisc.library.ocfl.api.exception.OcflStateException;
import edu.wisc.library.ocfl.api.model.OcflVersion;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.extension.ExtensionSupportEvaluator;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.inventory.InventoryMapper;
import edu.wisc.library.ocfl.core.storage.OcflStorage;
import edu.wisc.library.ocfl.core.storage.RepositoryConfig;

public abstract class AbstractOcflStorage
implements OcflStorage {
    protected InventoryMapper inventoryMapper;
    protected ExtensionSupportEvaluator supportEvaluator;
    private boolean closed = false;
    private boolean initialized = false;
    private RepositoryConfig repositoryConfig;

    @Override
    public synchronized RepositoryConfig initializeStorage(OcflVersion ocflVersion, OcflExtensionConfig layoutConfig, InventoryMapper inventoryMapper, ExtensionSupportEvaluator supportEvaluator) {
        if (this.initialized) {
            return this.repositoryConfig;
        }
        this.inventoryMapper = Enforce.notNull(inventoryMapper, "inventoryMapper cannot be null");
        this.supportEvaluator = Enforce.notNull(supportEvaluator, "supportEvaluator cannot be null");
        this.repositoryConfig = this.doInitialize(ocflVersion, layoutConfig);
        this.initialized = true;
        return this.repositoryConfig;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void invalidateCache(String objectId) {
    }

    @Override
    public void invalidateCache() {
    }

    protected abstract RepositoryConfig doInitialize(OcflVersion var1, OcflExtensionConfig var2);

    protected void ensureOpen() {
        if (this.closed) {
            throw new OcflStateException(this.getClass().getName() + " is closed.");
        }
        if (!this.initialized) {
            throw new OcflStateException(this.getClass().getName() + " must be initialized before it can be used.");
        }
    }
}

