/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage;

import edu.wisc.library.ocfl.api.OcflFileRetriever;
import edu.wisc.library.ocfl.api.exception.CorruptObjectException;
import edu.wisc.library.ocfl.api.exception.FixityCheckException;
import edu.wisc.library.ocfl.api.exception.NotFoundException;
import edu.wisc.library.ocfl.api.exception.ObjectOutOfSyncException;
import edu.wisc.library.ocfl.api.exception.OcflFileAlreadyExistsException;
import edu.wisc.library.ocfl.api.exception.OcflIOException;
import edu.wisc.library.ocfl.api.exception.OcflNoSuchFileException;
import edu.wisc.library.ocfl.api.exception.OcflStateException;
import edu.wisc.library.ocfl.api.io.FixityCheckInputStream;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.OcflVersion;
import edu.wisc.library.ocfl.api.model.ValidationResults;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.ObjectPaths;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.storage.layout.OcflStorageLayoutExtension;
import edu.wisc.library.ocfl.core.inventory.SidecarMapper;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.RevisionNum;
import edu.wisc.library.ocfl.core.model.Version;
import edu.wisc.library.ocfl.core.path.constraint.LogicalPathConstraints;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraintProcessor;
import edu.wisc.library.ocfl.core.storage.AbstractOcflStorage;
import edu.wisc.library.ocfl.core.storage.OcflStorageBuilder;
import edu.wisc.library.ocfl.core.storage.OcflStorageInitializer;
import edu.wisc.library.ocfl.core.storage.RepositoryConfig;
import edu.wisc.library.ocfl.core.storage.common.Listing;
import edu.wisc.library.ocfl.core.storage.common.ObjectProperties;
import edu.wisc.library.ocfl.core.storage.common.OcflObjectRootDirIterator;
import edu.wisc.library.ocfl.core.storage.common.Storage;
import edu.wisc.library.ocfl.core.util.FileUtil;
import edu.wisc.library.ocfl.core.util.NamasteTypeFile;
import edu.wisc.library.ocfl.core.util.UncheckedFiles;
import edu.wisc.library.ocfl.core.validation.Validator;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOcflStorage
extends AbstractOcflStorage {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOcflStorage.class);
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final String MEDIA_TYPE_TEXT = "text/plain; charset=UTF-8";
    private static final String MEDIA_TYPE_JSON = "application/json; charset=UTF-8";
    private final PathConstraintProcessor logicalPathConstraints;
    private final Storage storage;
    private final OcflStorageInitializer initializer;
    private OcflStorageLayoutExtension storageLayoutExtension;
    private final Validator validator;
    private final boolean verifyInventoryDigest;
    private final RetryPolicy<Void> invRetry;

    public static OcflStorageBuilder builder() {
        return new OcflStorageBuilder();
    }

    public DefaultOcflStorage(Storage storage, boolean verifyInventoryDigest, OcflStorageInitializer initializer) {
        this.storage = Enforce.notNull(storage, "storage cannot be null");
        this.verifyInventoryDigest = verifyInventoryDigest;
        this.initializer = Enforce.notNull(initializer, "initializer cannot be null");
        this.logicalPathConstraints = LogicalPathConstraints.constraintsWithBackslashCheck();
        this.validator = new Validator(storage);
        this.invRetry = ((RetryPolicy)new RetryPolicy().handle((Class<? extends Throwable>)((Class<Throwable>)RuntimeException.class))).withBackoff(10L, 200L, ChronoUnit.MILLIS, 1.5).withMaxRetries(10);
    }

    @Override
    public Inventory loadInventory(String objectId) {
        this.ensureOpen();
        LOG.debug("Load inventory for object <{}>", (Object)objectId);
        Inventory inventory = null;
        String objectRootPath = this.objectRootPath(objectId);
        ObjectProperties objectProps = this.examineObject(objectRootPath);
        if (objectProps.getOcflVersion() != null) {
            if (objectProps.getDigestAlgorithm() == null) {
                throw new CorruptObjectException(String.format("Object %s is missing its root sidecar file", objectId));
            }
            boolean hasMutableHead = false;
            if (objectProps.hasExtensions()) {
                hasMutableHead = this.loadObjectExtensions(objectRootPath).contains("0005-mutable-head");
            }
            if (hasMutableHead) {
                inventory = this.parseAndVerifyMutableInventory(objectId, objectProps.getDigestAlgorithm(), objectRootPath);
                this.ensureRootObjectHasNotChanged(inventory);
            } else {
                inventory = this.parseAndVerifyInventory(objectId, objectProps.getDigestAlgorithm(), objectRootPath);
            }
            if (!Objects.equals(objectId, inventory.getId())) {
                throw new CorruptObjectException(String.format("Expected object at %s to have id %s. Found: %s", objectRootPath, objectId, inventory.getId()));
            }
        }
        return inventory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getInventoryBytes(String objectId, VersionNum versionNum) {
        this.ensureOpen();
        Enforce.notBlank(objectId, "objectId cannot be blank");
        Enforce.notNull(versionNum, "versionNum cannot be null");
        LOG.debug("Loading inventory bytes for object {} version {}", (Object)objectId, (Object)versionNum);
        String objectRootPath = this.objectRootPath(objectId);
        String versionPath = FileUtil.pathJoinFailEmpty(objectRootPath, versionNum.toString());
        String inventoryPath = ObjectPaths.inventoryPath(versionPath);
        try (InputStream stream = this.storage.read(inventoryPath);){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
        catch (OcflNoSuchFileException e2) {
            String mutableHeadInventoryPath = ObjectPaths.mutableHeadInventoryPath(objectRootPath);
            try (InputStream mutableStream2222 = this.storage.read(mutableHeadInventoryPath);){
                byte[] bytes = mutableStream2222.readAllBytes();
                Inventory inv = this.inventoryMapper.readMutableHeadNoDigest("root", RevisionNum.R1, new ByteArrayInputStream(bytes));
                if (!versionNum.equals(inv.getHead())) throw new NotFoundException(String.format("No inventory could be found for object %s version %s", objectId, versionNum));
                byte[] byArray2 = bytes;
                return byArray2;
            }
            catch (OcflNoSuchFileException mutableStream2222) {
                throw new NotFoundException(String.format("No inventory could be found for object %s version %s", objectId, versionNum));
            }
            catch (IOException e22) {
                throw OcflIOException.from(e22);
            }
        }
        catch (IOException e3) {
            throw OcflIOException.from(e3);
        }
    }

    @Override
    public Stream<String> listObjectIds() {
        LOG.debug("List object ids");
        return this.findOcflObjectRootDirs().map(objectRoot -> this.parseInventory((String)objectRoot).getId());
    }

    @Override
    public void storeNewVersion(Inventory inventory, Path stagingDir, boolean upgradeOcflVersion) {
        this.ensureOpen();
        LOG.debug("Store new version of object <{}> version <{}> revision <{}> from staging directory <{}>", inventory.getId(), inventory.getHead(), inventory.getRevisionNum(), stagingDir);
        if (inventory.hasMutableHead()) {
            this.storeNewMutableHeadVersion(inventory, stagingDir);
        } else {
            this.storeNewImmutableVersion(inventory, stagingDir, upgradeOcflVersion);
        }
    }

    @Override
    public Map<String, OcflFileRetriever> getObjectStreams(Inventory inventory, VersionNum versionNum) {
        this.ensureOpen();
        LOG.debug("Get file streams for object <{}> version <{}>", (Object)inventory.getId(), (Object)versionNum);
        Version version2 = inventory.ensureVersion(versionNum);
        DigestAlgorithm algorithm = inventory.getDigestAlgorithm();
        HashMap<String, OcflFileRetriever> map = new HashMap<String, OcflFileRetriever>(version2.getState().size());
        version2.getState().forEach((digest, paths) -> {
            String srcPath = inventory.storagePath((String)digest);
            paths.forEach(path -> map.put((String)path, this.storage.readLazy(srcPath, algorithm, (String)digest)));
        });
        return map;
    }

    @Override
    public void reconstructObjectVersion(Inventory inventory, VersionNum versionNum, Path stagingDir) {
        this.ensureOpen();
        LOG.debug("Reconstruct object <{}> version <{}> in directory <{}>", inventory.getId(), versionNum, stagingDir);
        Version version2 = inventory.ensureVersion(versionNum);
        DigestAlgorithm digestAlgorithm = inventory.getDigestAlgorithm();
        version2.getState().forEach((id, files) -> {
            String srcPath = inventory.storagePath((String)id);
            for (String logicalPath : files) {
                this.logicalPathConstraints.apply(logicalPath);
                Path destination = Paths.get(FileUtil.pathJoinFailEmpty(stagingDir.toString(), logicalPath), new String[0]);
                UncheckedFiles.createDirectories(destination.getParent());
                try (FixityCheckInputStream stream = new FixityCheckInputStream((InputStream)new BufferedInputStream(this.storage.read(srcPath)), digestAlgorithm, (String)id);){
                    Files.copy(stream, destination, new CopyOption[0]);
                    stream.checkFixity();
                }
                catch (FixityCheckException e2) {
                    throw new FixityCheckException(String.format("File %s in object %s failed its fixity check.", logicalPath, inventory.getId()), e2);
                }
                catch (IOException e3) {
                    throw OcflIOException.from(e3);
                }
            }
        });
    }

    @Override
    public void purgeObject(String objectId) {
        this.ensureOpen();
        LOG.info("Purge object <{}>", (Object)objectId);
        String objectRoot = this.objectRootPath(objectId);
        try {
            this.storage.deleteDirectory(objectRoot);
        }
        catch (RuntimeException e2) {
            throw new CorruptObjectException(String.format("Failed to purge object %s at %s. The object may need to be deleted manually.", objectId, objectRoot), e2);
        }
        try {
            this.storage.deleteEmptyDirsUp(FileUtil.parentPath(objectRoot));
        }
        catch (RuntimeException e3) {
            LOG.warn("Failed to cleanup parent directories when purging object {}.", (Object)objectId, (Object)e3);
        }
    }

    @Override
    public void rollbackToVersion(Inventory inventory, VersionNum versionNum) {
        this.ensureOpen();
        LOG.info("Rollback object <{}> to version {}", (Object)inventory.getId(), (Object)versionNum);
        String versionPath = this.objectVersionPath(inventory, versionNum);
        try {
            this.copyInventoryInternal(inventory, versionPath, inventory.getObjectRootPath());
        }
        catch (Exception e2) {
            try {
                String previousVersionPath = this.objectVersionPath(inventory, inventory.getHead());
                this.copyInventoryInternal(inventory, previousVersionPath, inventory.getObjectRootPath());
            }
            catch (RuntimeException e1) {
                LOG.error("Failed to rollback inventory at {}. Object {} must be fixed manually.", ObjectPaths.inventoryPath(inventory.getObjectRootPath()), inventory.getId(), e1);
            }
            throw e2;
        }
        try {
            VersionNum currentVersion = inventory.getHead();
            while (currentVersion.compareTo(versionNum) > 0) {
                LOG.info("Purging object {} version {}", (Object)inventory.getId(), (Object)currentVersion);
                this.storage.deleteDirectory(this.objectVersionPath(inventory, currentVersion));
                currentVersion = currentVersion.previousVersionNum();
            }
            this.purgeMutableHead(inventory.getId());
        }
        catch (RuntimeException e3) {
            throw new CorruptObjectException(String.format("Object %s was corrupted while attempting to rollback to version %s. It must be manually remediated.", inventory.getId(), versionNum), e3);
        }
    }

    @Override
    public void commitMutableHead(Inventory oldInventory, Inventory newInventory, Path stagingDir) {
        this.ensureOpen();
        LOG.debug("Commit mutable HEAD on object <{}>", (Object)newInventory.getId());
        ObjectPaths.ObjectRoot objectRoot = ObjectPaths.objectRoot(newInventory);
        this.ensureRootObjectHasNotChanged(newInventory);
        if (!this.hasMutableHead(newInventory.getObjectRootPath())) {
            throw new ObjectOutOfSyncException(String.format("Cannot commit mutable HEAD of object %s because a mutable HEAD does not exist.", newInventory.getId()));
        }
        String versionPath = this.objectVersionPath(newInventory, newInventory.getHead());
        this.moveMutableHeadToVersionDirectory(newInventory, versionPath);
        try {
            try {
                this.copyInventoryToRootWithRollback(newInventory, objectRoot, stagingDir);
            }
            catch (RuntimeException e2) {
                this.rollbackMutableHeadVersionInstall(newInventory, objectRoot, versionPath);
                throw e2;
            }
            try {
                this.copyInventoryInternal(newInventory, newInventory.getObjectRootPath(), versionPath);
            }
            catch (RuntimeException e3) {
                LOG.warn("Failed to copy the inventory into object {} version {}.", (Object)newInventory.getId(), (Object)newInventory.getHead());
            }
        }
        catch (RuntimeException e4) {
            try {
                this.storage.deleteDirectory(versionPath);
                this.rollbackInventory(newInventory);
            }
            catch (RuntimeException exception) {
                LOG.error("Failed to rollback new version installation in object {} at {}. It must be cleaned up manually.", newInventory.getId(), newInventory.getHead(), e4);
            }
            throw e4;
        }
        try {
            this.purgeMutableHead(newInventory.getId());
        }
        catch (RuntimeException e5) {
            LOG.error("Failed to cleanup mutable HEAD of object {} at {}. It must be deleted manually.", newInventory.getId(), ObjectPaths.mutableHeadExtensionRoot(newInventory.getObjectRootPath()), e5);
        }
        boolean upgradeOcflVersion = oldInventory.getType() != newInventory.getType();
        this.upgradeOcflSpecVersion(newInventory, objectRoot, upgradeOcflVersion);
    }

    @Override
    public void purgeMutableHead(String objectId) {
        this.ensureOpen();
        LOG.info("Purge mutable HEAD on object <{}>", (Object)objectId);
        String extensionRoot = ObjectPaths.mutableHeadExtensionRoot(this.objectRootPath(objectId));
        try {
            this.storage.deleteDirectory(extensionRoot);
        }
        catch (RuntimeException e2) {
            throw new CorruptObjectException(String.format("Failed to purge mutable HEAD of object %s at %s. The version may need to be deleted manually.", objectId, extensionRoot), e2);
        }
    }

    @Override
    public boolean containsObject(String objectId) {
        this.ensureOpen();
        ObjectProperties objectProps = this.examineObject(this.objectRootPath(objectId));
        boolean exists = objectProps.getOcflVersion() != null;
        LOG.debug("OCFL repository contains object <{}>: {}", (Object)objectId, (Object)exists);
        return exists;
    }

    @Override
    public String objectRootPath(String objectId) {
        this.ensureOpen();
        String objectRootPath = this.storageLayoutExtension.mapObjectId(objectId);
        LOG.debug("Object root path for object <{}>: {}", (Object)objectId, (Object)objectRootPath);
        return objectRootPath;
    }

    @Override
    public void exportVersion(ObjectVersionId objectVersionId, Path outputPath) {
        this.ensureOpen();
        Enforce.notNull(objectVersionId.getVersionNum(), "versionNum cannot be null");
        if (!this.containsObject(objectVersionId.getObjectId())) {
            throw new NotFoundException(String.format("Object %s version %s was not found.", objectVersionId.getObjectId(), objectVersionId.getVersionNum()));
        }
        String versionRootPath = FileUtil.pathJoinFailEmpty(this.objectRootPath(objectVersionId.getObjectId()), objectVersionId.getVersionNum().toString());
        LOG.debug("Copying <{}> to <{}>", (Object)versionRootPath, (Object)outputPath);
        try {
            this.storage.copyDirectoryOutOf(versionRootPath, outputPath);
        }
        catch (OcflNoSuchFileException e2) {
            throw new NotFoundException(String.format("Object %s version %s was not found.", objectVersionId.getObjectId(), objectVersionId.getVersionNum()), e2);
        }
    }

    @Override
    public void exportObject(String objectId, Path outputPath) {
        this.ensureOpen();
        if (!this.containsObject(objectId)) {
            throw new NotFoundException(String.format("Object %s was not found.", objectId));
        }
        String objectRootPath = this.objectRootPath(objectId);
        LOG.debug("Copying <{}> to <{}>", (Object)objectRootPath, (Object)outputPath);
        try {
            this.storage.copyDirectoryOutOf(objectRootPath, outputPath);
        }
        catch (OcflNoSuchFileException e2) {
            throw new NotFoundException(String.format("Object %s was not found.", objectId), e2);
        }
    }

    @Override
    public void importObject(String objectId, Path objectPath) {
        this.ensureOpen();
        String objectRootPath = this.objectRootPath(objectId);
        LOG.debug("Importing <{}> to <{}>", (Object)objectId, (Object)objectRootPath);
        this.storage.createDirectories(FileUtil.parentPath(objectRootPath));
        try {
            this.storage.moveDirectoryInto(objectPath, objectRootPath);
        }
        catch (OcflFileAlreadyExistsException e2) {
            throw new ObjectOutOfSyncException(String.format("Cannot import object %s because the object already exists.", objectId));
        }
        catch (RuntimeException e3) {
            try {
                this.purgeObject(objectId);
            }
            catch (RuntimeException e1) {
                LOG.error("Failed to rollback object {} import", (Object)objectId, (Object)e1);
            }
            throw e3;
        }
    }

    @Override
    public ValidationResults validateObject(String objectId, boolean contentFixityCheck) {
        this.ensureOpen();
        if (!this.containsObject(objectId)) {
            throw new NotFoundException(String.format("Object %s was not found.", objectId));
        }
        String objectRoot = this.objectRootPath(objectId);
        LOG.debug("Validating object <{}> at <{}>", (Object)objectId, (Object)objectRoot);
        return this.validator.validateObject(objectRoot, contentFixityCheck);
    }

    @Override
    public void close() {
        LOG.debug("Closing " + this.getClass().getName());
        super.close();
    }

    @Override
    protected RepositoryConfig doInitialize(OcflVersion ocflVersion, OcflExtensionConfig layoutConfig) {
        RepositoryConfig result = this.initializer.initializeStorage(ocflVersion, layoutConfig, this.supportEvaluator);
        this.storageLayoutExtension = result.getStorageLayoutExtension();
        return result;
    }

    private void storeNewImmutableVersion(Inventory inventory, Path stagingDir, boolean upgradeOcflVersion) {
        ObjectPaths.ObjectRoot objectRoot = ObjectPaths.objectRoot(inventory);
        this.ensureNoMutableHead(inventory.getId(), objectRoot.path());
        String versionPath = this.objectVersionPath(inventory, inventory.getHead());
        boolean isFirstVersion = this.isFirstVersion(inventory);
        try {
            if (isFirstVersion) {
                this.storage.createDirectories(objectRoot.path());
                this.writeObjectNamasteFile(inventory.getType().getOcflVersion(), objectRoot.path());
            }
            this.moveToVersionDirectory(inventory, stagingDir, versionPath);
            try {
                this.verifyPriorInventory(inventory, objectRoot.inventorySidecar());
                this.copyInventoryToRootWithRollback(inventory, versionPath);
            }
            catch (RuntimeException e2) {
                try {
                    this.storage.deleteDirectory(versionPath);
                }
                catch (RuntimeException e1) {
                    LOG.error("Failed to rollback the creation of object {} version {}. The object may be corrupted.", inventory.getId(), inventory.getHead(), e1);
                }
                throw e2;
            }
        }
        catch (RuntimeException e3) {
            if (isFirstVersion) {
                try {
                    this.purgeObject(inventory.getId());
                }
                catch (RuntimeException e1) {
                    LOG.error("Failed to rollback object {} creation", (Object)inventory.getId(), (Object)e1);
                }
            }
            throw e3;
        }
        this.upgradeOcflSpecVersion(inventory, objectRoot, upgradeOcflVersion);
    }

    private void storeNewMutableHeadVersion(Inventory inventory, Path stagingDir) {
        ObjectPaths.ObjectRoot objectRoot = ObjectPaths.objectRoot(inventory);
        String destinationDir = objectRoot.headVersion().contentRoot().headRevisionPath();
        boolean isNewMutableHead = false;
        if (this.hasMutableHead(inventory.getObjectRootPath())) {
            this.ensureRootObjectHasNotChanged(inventory);
        } else {
            this.copyRootInventorySidecarToMutableHead(objectRoot);
            isNewMutableHead = true;
        }
        String revisionMarker = null;
        try {
            revisionMarker = this.createRevisionMarker(inventory, objectRoot);
            this.moveToRevisionDirectory(inventory, objectRoot, stagingDir, destinationDir);
            try {
                this.verifyPriorInventoryMutable(inventory, objectRoot, isNewMutableHead);
                this.storeMutableHeadInventory(inventory, objectRoot, stagingDir);
            }
            catch (RuntimeException e2) {
                try {
                    this.storage.deleteDirectory(destinationDir);
                }
                catch (RuntimeException e1) {
                    LOG.error("Failed to rollback the creation of object {} version {} revision {}. The object may be corrupted.", inventory.getId(), inventory.getHead(), inventory.getRevisionNum(), e1);
                }
                throw e2;
            }
        }
        catch (RuntimeException e3) {
            if (isNewMutableHead) {
                try {
                    this.storage.deleteDirectory(objectRoot.mutableHeadExtensionPath());
                }
                catch (RuntimeException e1) {
                    LOG.error("Failed to rollback the creation of a new mutable HEAD in object {}", (Object)inventory.getId(), (Object)e1);
                }
            } else if (revisionMarker != null) {
                try {
                    this.storage.deleteFile(revisionMarker);
                }
                catch (RuntimeException e1) {
                    LOG.error("Failed to rollback mutable HEAD revision marker in object {}", (Object)inventory.getId(), (Object)e1);
                }
            }
            throw e3;
        }
        try {
            this.deleteMutableHeadFilesNotInManifest(inventory, objectRoot);
        }
        catch (RuntimeException e4) {
            LOG.error("Failed to cleanup outdated mutable HEAD content files in object {}", (Object)inventory.getId(), (Object)e4);
        }
        try {
            this.storage.deleteEmptyDirsDown(objectRoot.headVersion().contentPath());
        }
        catch (RuntimeException e5) {
            LOG.error("Failed to cleanup empty mutable HEAD content directories in object {}", (Object)inventory.getId(), (Object)e5);
        }
    }

    private void moveToRevisionDirectory(Inventory inventory, ObjectPaths.ObjectRoot objectRoot, Path stagingDir, String destination) {
        this.storage.createDirectories(objectRoot.headVersion().contentPath());
        try {
            this.storage.moveDirectoryInto(stagingDir.resolve(inventory.resolveContentDirectory()).resolve(inventory.getRevisionNum().toString()), destination);
        }
        catch (OcflFileAlreadyExistsException e2) {
            throw new ObjectOutOfSyncException(String.format("Failed to update mutable HEAD of object %s. Changes are out of sync with the current object state.", inventory.getId()));
        }
    }

    private void moveToVersionDirectory(Inventory inventory, Path stagingDir, String destination) {
        try {
            this.storage.moveDirectoryInto(stagingDir, destination);
        }
        catch (OcflFileAlreadyExistsException e2) {
            throw new ObjectOutOfSyncException(String.format("Failed to create a new version of object %s. Changes are out of sync with the current object state.", inventory.getId()));
        }
    }

    private void moveMutableHeadToVersionDirectory(Inventory inventory, String destination) {
        try {
            this.storage.moveDirectoryInternal(ObjectPaths.mutableHeadVersionPath(inventory.getObjectRootPath()), destination);
        }
        catch (OcflFileAlreadyExistsException e2) {
            throw new ObjectOutOfSyncException(String.format("Failed to create a new version of object %s. Changes are out of sync with the current object state.", inventory.getId()));
        }
    }

    private void rollbackMutableHeadVersionInstall(Inventory inventory, ObjectPaths.ObjectRoot objectRoot, String versionPath) {
        try {
            this.storage.moveDirectoryInternal(versionPath, objectRoot.headVersionPath());
        }
        catch (RuntimeException e2) {
            LOG.error("Failed to rollback new version installation in object {} at {}. It must be cleaned up manually.", inventory.getId(), inventory.getHead(), e2);
        }
    }

    private void storeMutableHeadInventory(Inventory inventory, ObjectPaths.ObjectRoot objectRoot, Path sourcePath) {
        Failsafe.with(this.invRetry, (Policy[])new RetryPolicy[0]).run(() -> {
            this.storage.copyFileInto(ObjectPaths.inventoryPath(sourcePath), objectRoot.headVersion().inventoryFile(), MEDIA_TYPE_JSON);
            this.storage.copyFileInto(ObjectPaths.inventorySidecarPath(sourcePath, inventory), objectRoot.headVersion().inventorySidecar(), MEDIA_TYPE_TEXT);
        });
    }

    private void copyInventoryToRootWithRollback(Inventory inventory, ObjectPaths.ObjectRoot objectRoot, Path stagingDir) {
        try {
            Failsafe.with(this.invRetry, (Policy[])new RetryPolicy[0]).run(() -> {
                this.storage.copyFileInto(ObjectPaths.inventoryPath(stagingDir), objectRoot.inventoryFile(), MEDIA_TYPE_JSON);
                this.storage.copyFileInto(ObjectPaths.inventorySidecarPath(stagingDir, inventory), objectRoot.inventorySidecar(), MEDIA_TYPE_TEXT);
            });
        }
        catch (RuntimeException e2) {
            if (!this.isFirstVersion(inventory)) {
                this.rollbackInventory(inventory);
            }
            throw e2;
        }
    }

    private void copyInventoryToRootWithRollback(Inventory inventory, String versionPath) {
        try {
            this.copyInventoryInternal(inventory, versionPath, inventory.getObjectRootPath());
        }
        catch (RuntimeException e2) {
            this.rollbackInventory(inventory);
            throw e2;
        }
    }

    private void rollbackInventory(Inventory inventory) {
        if (!this.isFirstVersion(inventory)) {
            try {
                String previousVersionPath = this.objectVersionPath(inventory, inventory.getHead().previousVersionNum());
                this.copyInventoryInternal(inventory, previousVersionPath, inventory.getObjectRootPath());
            }
            catch (RuntimeException e2) {
                LOG.error("Failed to rollback inventory at {} in object {}. Object must be fixed manually.", ObjectPaths.inventoryPath(inventory.getObjectRootPath()), inventory.getId(), e2);
            }
        }
    }

    private void copyInventoryInternal(Inventory inventory, String sourcePath, String destinationPath) {
        Failsafe.with(this.invRetry, (Policy[])new RetryPolicy[0]).run(() -> {
            this.storage.copyFileInternal(ObjectPaths.inventoryPath(sourcePath), ObjectPaths.inventoryPath(destinationPath));
            this.storage.copyFileInternal(ObjectPaths.inventorySidecarPath(sourcePath, inventory), ObjectPaths.inventorySidecarPath(destinationPath, inventory));
        });
    }

    private void copyRootInventorySidecarToMutableHead(ObjectPaths.ObjectRoot objectRoot) {
        String rootSidecarPath = objectRoot.inventorySidecar();
        String sidecarName = rootSidecarPath.substring(rootSidecarPath.lastIndexOf(47) + 1);
        String destination = FileUtil.pathJoinFailEmpty(objectRoot.mutableHeadExtensionPath(), "root-" + sidecarName);
        this.storage.createDirectories(objectRoot.mutableHeadExtensionPath());
        this.storage.copyFileInternal(rootSidecarPath, destination);
    }

    private void verifyPriorInventoryMutable(Inventory inventory, ObjectPaths.ObjectRoot objectRoot, boolean isNewMutableHead) {
        String sidecarPath = isNewMutableHead ? objectRoot.inventorySidecar() : objectRoot.headVersion().inventorySidecar();
        this.verifyPriorInventory(inventory, sidecarPath);
    }

    private void verifyPriorInventory(Inventory inventory, String sidecarPath) {
        if (inventory.getPreviousDigest() != null) {
            String actualDigest = this.getDigestFromSidecar(sidecarPath);
            if (!actualDigest.equalsIgnoreCase(inventory.getPreviousDigest())) {
                throw new ObjectOutOfSyncException(String.format("Cannot update object %s because the update is out of sync with the current object state. The digest of the current inventory is %s, but the digest %s was expected.", inventory.getId(), actualDigest, inventory.getPreviousDigest()));
            }
        } else if (!inventory.getHead().equals(VersionNum.V1)) {
            LOG.debug("Cannot verify prior inventory for object {} because its digest is unknown.", (Object)inventory.getId());
        }
    }

    private Inventory parseAndVerifyInventory(String objectId, DigestAlgorithm digestAlgorithm, String objectRootPath) {
        Inventory inventory;
        block10: {
            String inventoryPath = ObjectPaths.inventoryPath(objectRootPath);
            InputStream stream = this.storage.read(inventoryPath);
            try {
                String expectedDigest;
                Inventory inventory2 = this.inventoryMapper.read(objectRootPath, digestAlgorithm, stream);
                if (this.verifyInventoryDigest && !(expectedDigest = this.getDigestFromSidecar(ObjectPaths.inventorySidecarPath(objectRootPath, inventory2))).equalsIgnoreCase(inventory2.getInventoryDigest())) {
                    throw new CorruptObjectException(String.format("Invalid root inventory in object %s", objectId));
                }
                inventory = inventory2;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OcflNoSuchFileException e2) {
                    throw new CorruptObjectException(String.format("Object %s is missing its root inventory", objectId), e2);
                }
                catch (IOException e3) {
                    throw new OcflIOException(e3);
                }
            }
            stream.close();
        }
        return inventory;
    }

    private Inventory parseAndVerifyMutableInventory(String objectId, DigestAlgorithm digestAlgorithm, String objectRootPath) {
        Inventory inventory;
        block10: {
            String inventoryPath = ObjectPaths.mutableHeadInventoryPath(objectRootPath);
            InputStream stream = this.storage.read(inventoryPath);
            try {
                String expectedDigest;
                RevisionNum revisionNum = this.identifyLatestRevision(objectRootPath);
                Inventory inventory2 = this.inventoryMapper.readMutableHead(objectRootPath, revisionNum, digestAlgorithm, stream);
                if (this.verifyInventoryDigest && !(expectedDigest = this.getDigestFromSidecar(ObjectPaths.mutableHeadInventorySidecarPath(objectRootPath, inventory2))).equalsIgnoreCase(inventory2.getInventoryDigest())) {
                    throw new CorruptObjectException(String.format("Invalid mutable HEAD inventory in object %s", objectId));
                }
                inventory = inventory2;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OcflNoSuchFileException e2) {
                    throw new CorruptObjectException(String.format("Object %s is missing its mutable HEAD inventory", objectId), e2);
                }
                catch (IOException e3) {
                    throw new OcflIOException(e3);
                }
            }
            stream.close();
        }
        return inventory;
    }

    private Inventory parseInventory(String objectRootPath) {
        Inventory inventory;
        block8: {
            String inventoryPath = ObjectPaths.inventoryPath(objectRootPath);
            InputStream stream = this.storage.read(inventoryPath);
            try {
                inventory = this.inventoryMapper.readNoDigest(objectRootPath, stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new OcflIOException(e2);
                }
            }
            stream.close();
        }
        return inventory;
    }

    private String createRevisionMarker(Inventory inventory, ObjectPaths.ObjectRoot objectRoot) {
        String revision = inventory.getRevisionNum().toString();
        String revisionsDir = objectRoot.mutableHeadRevisionsPath();
        String revisionPath = FileUtil.pathJoinFailEmpty(revisionsDir, revision);
        this.storage.createDirectories(revisionsDir);
        try {
            this.storage.write(revisionPath, revision.getBytes(StandardCharsets.UTF_8), MEDIA_TYPE_TEXT);
            return revisionPath;
        }
        catch (OcflFileAlreadyExistsException e2) {
            throw new ObjectOutOfSyncException(String.format("Failed to update mutable HEAD of object %s. Changes are out of sync with the current object state.", inventory.getId()));
        }
    }

    private RevisionNum identifyLatestRevision(String objectRootPath) {
        List<Listing> revisions;
        String revisionsPath = ObjectPaths.mutableHeadRevisionsPath(objectRootPath);
        try {
            revisions = this.storage.listDirectory(revisionsPath);
        }
        catch (OcflNoSuchFileException e2) {
            throw new CorruptObjectException("Object has a mutable head, but has not specified any revision numbers.", e2);
        }
        Optional<RevisionNum> result = revisions.stream().filter(Listing::isFile).map(Listing::getRelativePath).filter(RevisionNum::isRevisionNum).map(RevisionNum::fromString).max(Comparator.naturalOrder());
        if (result.isEmpty()) {
            throw new CorruptObjectException("Object has a mutable head, but has not specified any revision numbers.");
        }
        return result.get();
    }

    private void deleteMutableHeadFilesNotInManifest(Inventory inventory, ObjectPaths.ObjectRoot objectRoot) {
        List<Object> files;
        try {
            files = this.storage.listRecursive(objectRoot.headVersion().contentPath());
        }
        catch (OcflNoSuchFileException e2) {
            files = Collections.emptyList();
        }
        String prefix = FileUtil.pathJoinFailEmpty("extensions/0005-mutable-head/head", inventory.resolveContentDirectory());
        List<String> toDelete = files.stream().filter(Listing::isFile).map(file -> FileUtil.pathJoinFailEmpty(prefix, file.getRelativePath())).filter(contentPath -> inventory.getFileId((String)contentPath) == null).map(file -> FileUtil.pathJoinFailEmpty(inventory.getObjectRootPath(), file)).collect(Collectors.toList());
        this.storage.deleteFiles(toDelete);
    }

    private Stream<String> findOcflObjectRootDirs() {
        OcflObjectRootDirIterator iterator = this.storage.iterateObjects();
        try {
            Spliterator<String> spliterator = Spliterators.spliteratorUnknownSize(iterator, 1041);
            return (Stream)StreamSupport.stream(spliterator, false).onClose(iterator::close);
        }
        catch (RuntimeException e2) {
            iterator.close();
            throw e2;
        }
    }

    private void ensureNoMutableHead(String objectId, String objectRootPath) {
        if (this.hasMutableHead(objectRootPath)) {
            throw new OcflStateException(String.format("Cannot create a new version of object %s because it has an active mutable HEAD.", objectId));
        }
    }

    private boolean hasMutableHead(String objectRootPath) {
        return this.storage.fileExists(ObjectPaths.inventoryPath(ObjectPaths.mutableHeadVersionPath(objectRootPath)));
    }

    private void ensureRootObjectHasNotChanged(Inventory inventory) {
        String rootDigest;
        String savedDigest = this.getDigestFromSidecar(FileUtil.pathJoinFailEmpty(ObjectPaths.mutableHeadExtensionRoot(inventory.getObjectRootPath()), "root-inventory.json." + inventory.getDigestAlgorithm().getOcflName()));
        if (!savedDigest.equalsIgnoreCase(rootDigest = this.getDigestFromSidecar(ObjectPaths.inventorySidecarPath(inventory.getObjectRootPath(), inventory)))) {
            throw new ObjectOutOfSyncException(String.format("The mutable HEAD of object %s is out of sync with the root object state.", inventory.getId()));
        }
    }

    private String getDigestFromSidecar(String sidecarPath) {
        try {
            String sidecarContents = this.storage.readToString(sidecarPath);
            String[] parts = WHITESPACE.split(sidecarContents);
            if (parts.length == 0) {
                throw new CorruptObjectException("Invalid inventory sidecar file: " + sidecarPath);
            }
            return parts[0];
        }
        catch (OcflNoSuchFileException e2) {
            throw new CorruptObjectException("Missing inventory sidecar: " + sidecarPath, e2);
        }
    }

    private String objectVersionPath(Inventory inventory, VersionNum versionNum) {
        return FileUtil.pathJoinFailEmpty(inventory.getObjectRootPath(), versionNum.toString());
    }

    private boolean isFirstVersion(Inventory inventory) {
        return inventory.getVersions().size() == 1;
    }

    private void writeObjectNamasteFile(OcflVersion ocflVersion, String objectRootPath) {
        NamasteTypeFile namasteFile = new NamasteTypeFile(ocflVersion.getOcflObjectVersion());
        String namastePath = FileUtil.pathJoinFailEmpty(objectRootPath, namasteFile.fileName());
        this.storage.write(namastePath, namasteFile.fileContent().getBytes(StandardCharsets.UTF_8), MEDIA_TYPE_TEXT);
    }

    private void upgradeOcflSpecVersion(Inventory inventory, ObjectPaths.ObjectRoot objectRoot, boolean upgradeOcflVersion) {
        if (upgradeOcflVersion) {
            LOG.info("Upgrading object {} to OCFL spec version {}", (Object)inventory.getId(), (Object)inventory.getType().getOcflVersion().getRawVersion());
            try {
                ObjectProperties objectProps = this.examineObject(objectRoot.path());
                String namasteFile = new NamasteTypeFile(objectProps.getOcflVersion().getOcflObjectVersion()).fileName();
                String namasteFullPath = FileUtil.pathJoinFailEmpty(objectRoot.path(), namasteFile);
                this.writeObjectNamasteFile(inventory.getType().getOcflVersion(), objectRoot.path());
                this.storage.deleteFile(namasteFullPath);
            }
            catch (RuntimeException e2) {
                LOG.error("Failed to upgrade object {} to OCFL spec version {}. Manual intervention may be necessary.", (Object)inventory.getId(), (Object)inventory.getType().getOcflVersion().getRawVersion());
            }
        }
    }

    private ObjectProperties examineObject(String objectRootPath) {
        List<Listing> files;
        ObjectProperties properties = new ObjectProperties();
        try {
            files = this.storage.listDirectory(objectRootPath);
        }
        catch (OcflNoSuchFileException e2) {
            return properties;
        }
        for (Listing file : files) {
            if (file.isFile()) {
                if (file.getRelativePath().startsWith("inventory.json.")) {
                    properties.setDigestAlgorithm(SidecarMapper.getDigestAlgorithmFromSidecar(file.getRelativePath()));
                } else if (file.getRelativePath().startsWith("0=ocfl_object_")) {
                    properties.setOcflVersion(OcflVersion.fromOcflObjectVersionFilename(file.getRelativePath()));
                }
            } else if (file.isDirectory() && "extensions".equals(file.getRelativePath())) {
                properties.setExtensions(true);
            }
            if (properties.getOcflVersion() == null || properties.getDigestAlgorithm() == null || !properties.hasExtensions()) continue;
            break;
        }
        return properties;
    }

    private Set<String> loadObjectExtensions(String objectRoot) {
        try {
            return this.storage.listDirectory(ObjectPaths.extensionsPath(objectRoot)).stream().filter(Listing::isDirectory).map(Listing::getRelativePath).filter(this.supportEvaluator::checkSupport).collect(Collectors.toSet());
        }
        catch (OcflNoSuchFileException e2) {
            return Collections.emptySet();
        }
    }
}

