/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.util;

import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.FileChange;
import edu.wisc.library.ocfl.api.model.FileChangeHistory;
import edu.wisc.library.ocfl.api.model.FileChangeType;
import edu.wisc.library.ocfl.api.model.FileDetails;
import edu.wisc.library.ocfl.api.model.ObjectDetails;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.VersionDetails;
import edu.wisc.library.ocfl.api.model.VersionInfo;
import edu.wisc.library.ocfl.api.model.VersionNum;
import edu.wisc.library.ocfl.core.model.Inventory;
import edu.wisc.library.ocfl.core.model.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ResponseMapper {
    public ObjectDetails mapInventory(Inventory inventory) {
        ObjectDetails details = new ObjectDetails().setId(inventory.getId()).setDigestAlgorithm(inventory.getDigestAlgorithm()).setObjectOcflVersion(inventory.getType().getOcflVersion()).setHeadVersionNum(inventory.getHead());
        Map<VersionNum, VersionDetails> versionMap = inventory.getVersions().entrySet().stream().map(entry -> this.mapVersion(inventory, (VersionNum)entry.getKey(), (Version)entry.getValue())).collect(Collectors.toMap(VersionDetails::getVersionNum, Function.identity()));
        details.setVersions(versionMap);
        return details;
    }

    public VersionDetails mapVersion(Inventory inventory, VersionNum versionNum, Version version2) {
        return new VersionDetails().setObjectVersionId(ObjectVersionId.version(inventory.getId(), versionNum)).setObjectOcflVersion(inventory.getType().getOcflVersion()).setCreated(version2.getCreated()).setMutable(inventory.hasMutableHead() && inventory.getHead().equals(versionNum)).setFileMap(this.mapFileDetails(inventory, version2)).setVersionInfo(this.versionInfo(version2));
    }

    public FileChangeHistory fileChangeHistory(Inventory inventory, String logicalPath) {
        ArrayList<FileChange> changes = new ArrayList<FileChange>();
        String lastFileId = null;
        for (Map.Entry<VersionNum, Version> entry : inventory.getVersions().entrySet()) {
            VersionNum versionNum = entry.getKey();
            Version version2 = entry.getValue();
            String fileId = version2.getFileId(logicalPath);
            if (fileId != null && !Objects.equals(lastFileId, fileId)) {
                lastFileId = fileId;
                String contentPath = inventory.ensureContentPath(fileId);
                Map<DigestAlgorithm, String> fixity = inventory.getFixityForContentPath(contentPath);
                fixity.put(inventory.getDigestAlgorithm(), fileId);
                changes.add(new FileChange().setChangeType(FileChangeType.UPDATE).setObjectVersionId(ObjectVersionId.version(inventory.getId(), versionNum)).setPath(logicalPath).setTimestamp(version2.getCreated()).setVersionInfo(this.versionInfo(version2)).setStorageRelativePath(inventory.storagePath(fileId)).setFixity(fixity));
                continue;
            }
            if (fileId != null || lastFileId == null) continue;
            lastFileId = null;
            changes.add(new FileChange().setChangeType(FileChangeType.REMOVE).setObjectVersionId(ObjectVersionId.version(inventory.getId(), versionNum)).setPath(logicalPath).setTimestamp(version2.getCreated()).setVersionInfo(this.versionInfo(version2)).setFixity(Collections.emptyMap()));
        }
        return new FileChangeHistory().setPath(logicalPath).setFileChanges(changes);
    }

    private Map<String, FileDetails> mapFileDetails(Inventory inventory, Version version2) {
        HashMap<String, FileDetails> fileDetailsMap = new HashMap<String, FileDetails>();
        DigestAlgorithm digestAlgorithm = inventory.getDigestAlgorithm();
        version2.getState().forEach((digest, paths) -> paths.forEach(path -> {
            String contentPath = inventory.getContentPath((String)digest);
            FileDetails details = new FileDetails().setPath((String)path).setStorageRelativePath(inventory.storagePath((String)digest)).addDigest(digestAlgorithm, (String)digest);
            Map<DigestAlgorithm, String> digests = inventory.getFixityForContentPath(contentPath);
            digests.forEach(details::addDigest);
            fileDetailsMap.put((String)path, details);
        }));
        return fileDetailsMap;
    }

    private VersionInfo versionInfo(Version version2) {
        VersionInfo versionInfo = new VersionInfo().setMessage(version2.getMessage()).setCreated(version2.getCreated());
        if (version2.getUser() != null) {
            versionInfo.setUser(version2.getUser().getName(), version2.getUser().getAddress());
        }
        return versionInfo;
    }
}

