/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import org.apache.jena.graph.Triple;
import org.apache.jena.mem.HashCommon;
import org.apache.jena.mem.TripleBunch;
import org.apache.jena.util.iterator.ExtendedIterator;

public class HashedTripleBunch
extends HashCommon<Triple>
implements TripleBunch {
    public HashedTripleBunch(TripleBunch b) {
        super(HashedTripleBunch.nextSize((int)((double)b.size() / 0.5)));
        ExtendedIterator<Triple> it = b.iterator();
        while (it.hasNext()) {
            this.add((Triple)it.next());
        }
        this.changes = 0;
    }

    protected Triple[] newKeyArray(int size) {
        return new Triple[size];
    }

    @Override
    public boolean contains(Triple t2) {
        return this.findSlot(t2) < 0;
    }

    protected int findSlotBySameValueAs(Triple key) {
        int index = this.initialIndexFor(key);
        Triple current;
        while ((current = ((Triple[])this.keys)[index]) != null) {
            if (key.matches(current)) {
                return ~index;
            }
            if (--index >= 0) continue;
            index += this.capacity;
        }
        return index;
    }

    @Override
    public boolean containsBySameValueAs(Triple t2) {
        return this.findSlotBySameValueAs(t2) < 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int currentCapacity() {
        return this.capacity;
    }

    @Override
    public void add(Triple t2) {
        ((Triple[])this.keys)[this.findSlot(t2)] = t2;
        ++this.changes;
        if (++this.size > this.threshold) {
            this.grow();
        }
    }

    protected void grow() {
        Object[] oldContents = this.keys;
        int oldCapacity = this.capacity;
        this.growCapacityAndThreshold();
        this.keys = new Triple[this.capacity];
        Triple[] newKeys = this.keys;
        for (int i = 0; i < oldCapacity; ++i) {
            Triple t2 = (Triple)oldContents[i];
            if (t2 == null) continue;
            newKeys[this.findSlot(t2)] = t2;
        }
    }

    @Override
    public void remove(Triple t2) {
        super.remove(t2);
        ++this.changes;
    }

    @Override
    public ExtendedIterator<Triple> iterator() {
        return this.iterator(HashCommon.NotifyEmpty.ignore);
    }

    @Override
    public ExtendedIterator<Triple> iterator(HashCommon.NotifyEmpty container2) {
        return this.keyIterator(container2);
    }
}

