/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmloutput.impl;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.jena.ext.xerces.util.XMLChar;
import org.apache.jena.iri.IRI;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.rdfxml.xmloutput.impl.Abbreviated;
import org.apache.jena.rdfxml.xmloutput.impl.BaseXMLWriter;
import org.apache.jena.rdfxml.xmloutput.impl.Relation;
import org.apache.jena.shared.BrokenException;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.LazyIterator;
import org.apache.jena.util.iterator.Map1Iterator;
import org.apache.jena.util.iterator.MapFilter;
import org.apache.jena.util.iterator.MapFilterIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.util.iterator.SingletonIterator;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Unparser {
    private static Property LI = new PropertyImpl(RDF.getURI(), "li");
    private static Property DESCRIPTION = new PropertyImpl(RDF.getURI(), "Description");
    protected static Logger logger = LoggerFactory.getLogger(Unparser.class);
    private String xmlBase;
    private static final String rdfns = RDF.type.getNameSpace();
    private static final Integer one = 1;
    private String localName;
    private Map<Resource, Integer> objectTable;
    private Model model;
    private PrintWriter out;
    private Set<Resource> doing = new HashSet<Resource>();
    private Set<Statement> doneSet = new HashSet<Statement>();
    private Set<Resource> haveReified = new HashSet<Resource>();
    private Resource[] pleasingTypes = null;
    private Set<Resource> pleasingTypeSet = new HashSet<Resource>();
    private final Abbreviated prettyWriter;
    private boolean avoidExplicitReification = true;
    Map<Resource, Statement> res2statement;
    Map<Statement, Resource> statement2res;
    private static int RDF_HASH = RDF.getURI().length();
    private WType wdesc = new WType(){

        @Override
        void wTypeStart(Resource u) {
            Unparser.this.print(Unparser.this.prettyWriter.rdfEl(u.getURI().substring(RDF_HASH)));
        }

        @Override
        void wTypeEnd(Resource u) {
            Unparser.this.print(Unparser.this.prettyWriter.rdfEl(u.getURI().substring(RDF_HASH)));
        }
    };
    private WType wtype = new WType(){

        @Override
        void wTypeStart(Resource u) {
            Unparser.this.print(Unparser.this.prettyWriter.startElementTag(u.getURI()));
        }

        @Override
        void wTypeEnd(Resource u) {
            Unparser.this.print(Unparser.this.prettyWriter.endElementTag(u.getURI()));
        }
    };
    private Set<Resource> idDone = new HashSet<Resource>();
    int[] codeCoverage = new int[8];
    private int indentLevel = 0;
    private int currentColumn = 0;
    private Set<Resource> infinite;
    private Set<ResIterator> openResIterators = new HashSet<ResIterator>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Unparser(Abbreviated parent, String localName, Model m4, PrintWriter w) {
        this.setLocalName(localName);
        this.prettyWriter = parent;
        this.out = w;
        this.model = m4;
        this.addTypeNameSpaces();
        this.objectTable = new HashMap<Resource, Integer>();
        try (StmtIterator ss = m4.listStatements();){
            while (ss.hasNext()) {
                Statement s2 = ss.nextStatement();
                RDFNode rn = s2.getObject();
                if (!(rn instanceof Resource)) continue;
                this.increaseObjectCount((Resource)rn);
            }
        }
        try {
            this.res2statement = new HashMap<Resource, Statement>();
            this.statement2res = new HashMap<Statement, Resource>();
            MapFilterIterator<Resource, Resource> reified = new MapFilterIterator<Resource, Resource>(new MapFilter<Resource, Resource>(){

                @Override
                public Resource accept(Resource o) {
                    Resource r = o;
                    return r.hasProperty(RDF.subject) && r.hasProperty(RDF.object) && r.hasProperty(RDF.predicate) ? r : null;
                }
            }, this.model.listResourcesWithProperty(RDF.type, RDF.Statement));
            while (reified.hasNext()) {
                Resource r = (Resource)reified.next();
                try {
                    Statement subj = r.getRequiredProperty(RDF.subject);
                    Statement pred = r.getRequiredProperty(RDF.predicate);
                    Statement obj = r.getRequiredProperty(RDF.object);
                    RDFNode nobj = obj.getObject();
                    Resource rsubj = (Resource)subj.getObject();
                    Resource rpred = (Resource)pred.getObject();
                    Property ppred = this.model.createProperty(rpred.getURI());
                    Statement statement = this.model.createStatement(rsubj, ppred, nobj);
                    this.res2statement.put(r, statement);
                    this.statement2res.put(statement, r);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            ss.close();
        }
    }

    private void setLocalName(String uri) {
        if (uri == null || uri.equals("")) {
            this.localName = "";
        } else {
            IRI u = BaseXMLWriter.factory.create(uri);
            u = u.create("");
            this.localName = u.toString();
        }
    }

    void write() {
        this.prettyWriter.workOutNamespaces();
        this.wRDF();
    }

    void setTopLevelTypes(Resource[] types) {
        this.pleasingTypes = types;
        this.pleasingTypeSet = new HashSet<Resource>(Arrays.asList(types));
    }

    void setXMLBase(String b) {
        this.xmlBase = b;
    }

    private void wRDF() {
        this.tab();
        this.print("<");
        this.print(this.prettyWriter.rdfEl("RDF"));
        this.indentPlus();
        this.printNameSpaceDefn();
        if (this.xmlBase != null) {
            this.setLocalName(this.xmlBase);
            this.tab();
            this.print("xml:base=" + this.quote(this.xmlBase));
        }
        this.print(">");
        this.wObjStar();
        this.indentMinus();
        this.tab();
        this.print("</");
        this.print(this.prettyWriter.rdfEl("RDF"));
        this.print(">");
        this.tab();
    }

    private void wObjStar() {
        Iterator<Resource> rs = this.listSubjects();
        while (rs.hasNext()) {
            Resource r = rs.next();
            this.increaseObjectCount(r);
            this.wObj(r, true);
        }
        this.closeAllResIterators();
    }

    private boolean wPropertyElt(WType wt, Property prop, Statement s2, RDFNode val) {
        return this.wPropertyEltCompact(wt, prop, s2, val) || this.wPropertyEltCollection(wt, prop, s2, val) || this.wPropertyEltLiteral(wt, prop, s2, val) || this.wPropertyEltResource(wt, prop, s2, val) || this.wPropertyEltDatatype(wt, prop, s2, val) || this.wPropertyEltValue(wt, prop, s2, val);
    }

    private boolean wPropertyEltCompact(WType wt, Property prop, Statement s2, RDFNode val) {
        if (!(val instanceof Resource)) {
            return false;
        }
        Resource r = (Resource)val;
        if (!this.allPropsAreAttr(r) && !this.doing.contains(r)) {
            return false;
        }
        if (!this.hasProperties(r) && this.isGenuineAnon(r)) {
            return false;
        }
        this.done(s2);
        this.tab();
        this.print("<");
        wt.wTypeStart(prop);
        this.indentPlus();
        this.wIdRefAttrOpt(s2, r);
        if (!this.doing.contains(r)) {
            this.wPropAttrAll(r);
        } else if (this.isGenuineAnon(r)) {
            this.error("Genuine anon resource in cycle?");
        }
        this.indentMinus();
        this.print("/>");
        return true;
    }

    private boolean wPropertyEltLiteral(WType wt, Property prop, Statement s2, RDFNode r) {
        if (this.prettyWriter.sParseTypeLiteralPropertyElt) {
            return false;
        }
        if (!(r instanceof Literal) || !((Literal)r).isWellFormedXML()) {
            return false;
        }
        this.done(s2);
        this.tab();
        this.print("<");
        wt.wTypeStart(prop);
        this.wIdAttrReified(s2);
        this.maybeNewline();
        this.wParseLiteral();
        this.maybeNewline();
        this.print(">");
        this.print(((Literal)r).getLexicalForm());
        this.print("</");
        wt.wTypeEnd(prop);
        this.print(">");
        return true;
    }

    private boolean wPropertyEltDatatype(WType wt, Property prop, Statement s2, RDFNode r) {
        if (!(r instanceof Literal)) {
            return false;
        }
        Literal lit = (Literal)r;
        if (Util.isSimpleString(lit)) {
            return false;
        }
        if (Util.isLangString(lit)) {
            return false;
        }
        this.done(s2);
        this.tab();
        this.print("<");
        wt.wTypeStart(prop);
        this.wIdAttrReified(s2);
        this.maybeNewline();
        this.wDatatype(((Literal)r).getDatatypeURI());
        this.maybeNewline();
        this.print(">");
        this.print(Util.substituteEntitiesInElementContent(((Literal)r).getLexicalForm()));
        this.print("</");
        wt.wTypeEnd(prop);
        this.print(">");
        return true;
    }

    private boolean wPropertyEltResource(WType wt, Property prop, Statement s2, RDFNode r) {
        if (this.prettyWriter.sParseTypeResourcePropertyElt) {
            return false;
        }
        if (r instanceof Literal) {
            return false;
        }
        Resource res = (Resource)r;
        if (!this.isGenuineAnon(res)) {
            return false;
        }
        if (this.getType(res) != null) {
            return false;
        }
        this.done(s2);
        this.tab();
        this.print("<");
        wt.wTypeStart(prop);
        this.indentPlus();
        this.wIdAttrReified(s2);
        this.wParseResource();
        this.print(">");
        this.wPropertyEltStar(res);
        this.indentMinus();
        this.tab();
        this.print("</");
        wt.wTypeEnd(prop);
        this.print(">");
        return true;
    }

    private boolean wPropertyEltValue(WType wt, Property prop, Statement s2, RDFNode r) {
        return this.wPropertyEltValueString(wt, prop, s2, r) || this.wPropertyEltValueObj(wt, prop, s2, r);
    }

    private boolean wPropertyEltValueString(WType wt, Property prop, Statement s2, RDFNode r) {
        if (r instanceof Literal) {
            this.done(s2);
            Literal lt = (Literal)r;
            String lang = lt.getLanguage();
            this.tab();
            this.print("<");
            wt.wTypeStart(prop);
            this.wIdAttrReified(s2);
            this.maybeNewline();
            if (lang != null && lang.length() > 0) {
                this.print(" xml:lang=" + this.q(lang));
            }
            this.maybeNewline();
            this.print(">");
            this.wValueString(lt);
            this.print("</");
            wt.wTypeEnd(prop);
            this.print(">");
            return true;
        }
        return false;
    }

    private void wValueString(Literal lt) {
        String val = lt.getString();
        this.print(Util.substituteEntitiesInElementContent(val));
    }

    private boolean wPropertyEltValueObj(WType wt, Property prop, Statement s2, RDFNode r) {
        if (r instanceof Resource && !this.prettyWriter.sResourcePropertyElt) {
            Resource res = (Resource)r;
            this.done(s2);
            this.tab();
            this.print("<");
            wt.wTypeStart(prop);
            this.wIdAttrReified(s2);
            this.print(">");
            this.tab();
            this.indentPlus();
            this.wObj(res, false);
            this.indentMinus();
            this.tab();
            this.print("</");
            wt.wTypeEnd(prop);
            this.print(">");
            return true;
        }
        return false;
    }

    private boolean wPropertyEltCollection(WType wt, Property prop, Statement s2, RDFNode r) {
        Statement[][] list = this.getRDFList(r);
        if (list == null) {
            return false;
        }
        this.done(s2);
        for (Statement[] aList1 : list) {
            this.done(aList1[0]);
            this.done(aList1[1]);
        }
        this.tab();
        this.print("<");
        wt.wTypeStart(prop);
        this.indentPlus();
        this.wIdAttrReified(s2);
        this.wParseCollection();
        this.print(">");
        for (Statement[] aList : list) {
            this.wObj((Resource)aList[0].getObject(), false);
        }
        this.indentMinus();
        this.tab();
        this.print("</");
        wt.wTypeEnd(prop);
        this.print(">");
        return true;
    }

    private void wPropAttrAll(Resource r) {
        this.wPropAttrSome(r);
        if (this.hasProperties(r)) {
            this.error("Bad call to wPropAttrAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wPropAttrSome(Resource r) {
        try (ExtendedIterator<Statement> ss = this.listProperties(r);){
            HashSet<Property> seen = new HashSet<Property>();
            while (ss.hasNext()) {
                Statement s2 = (Statement)ss.next();
                if (!this.canBeAttribute(s2, seen)) continue;
                this.done(s2);
                this.wPropAttr(s2.getPredicate(), s2.getObject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wObj(Resource r, boolean topLevel) {
        try {
            this.doing.add(r);
            Statement typeStatement = this.getType(r);
            if (typeStatement != null) {
                Resource t2 = typeStatement.getResource();
                if (!topLevel && this.pleasingTypeSet.contains(t2) && !this.isGenuineAnon(r)) {
                    boolean bl = this.wTypedNodeNoProperties(r);
                    return bl;
                }
                boolean bl = this.wTypedNode(r) || this.wDescription(r);
                return bl;
            }
            boolean bl = this.wDescription(r);
            return bl;
        }
        finally {
            this.doing.remove(r);
        }
    }

    private boolean wDescription(Resource r) {
        return this.wTypedNodeOrDescription(this.wdesc, DESCRIPTION, r);
    }

    private boolean wTypedNode(Resource r) {
        Statement st = this.getType(r);
        if (st == null) {
            return false;
        }
        Resource type = st.getResource();
        this.done(st);
        return this.wTypedNodeOrDescription(this.wtype, type, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wTypedNodeOrDescription(WType wt, Resource ty, Resource r) {
        Vector<Statement> found = new Vector<Statement>();
        try (ExtendedIterator<Statement> ss = this.listProperties(r);){
            int greatest = 0;
            if (!this.prettyWriter.sListExpand) {
                while (ss.hasNext()) {
                    Statement s2 = (Statement)ss.next();
                    int ix = s2.getPredicate().getOrdinal();
                    if (ix == 0) continue;
                    if (ix > greatest) {
                        found.setSize(ix);
                        greatest = ix;
                    }
                    found.set(ix - 1, s2);
                }
            }
        }
        int last = found.indexOf(null);
        Vector<Statement> li = last == -1 ? found : found.subList(0, last);
        return this.wTypedNodeOrDescriptionCompact(wt, ty, r, li) || this.wTypedNodeOrDescriptionLong(wt, ty, r, li);
    }

    private boolean wTypedNodeOrDescriptionCompact(WType wt, Resource ty, Resource r, List<Statement> li) {
        if (!li.isEmpty() || !this.allPropsAreAttr(r)) {
            return false;
        }
        this.tab();
        this.print("<");
        wt.wTypeStart(ty);
        this.indentPlus();
        this.wIdAboutAttrOpt(r);
        this.wPropAttrAll(r);
        this.print("/>");
        this.indentMinus();
        return true;
    }

    private boolean wTypedNodeNoProperties(Resource r) {
        if (this.isGenuineAnon(r)) {
            return false;
        }
        Statement st = this.getType(r);
        if (st == null) {
            return false;
        }
        Resource type = st.getResource();
        this.done(st);
        this.tab();
        this.print("<");
        this.wtype.wTypeStart(type);
        this.indentPlus();
        this.wIdAboutAttrOpt(r);
        this.print("/>");
        this.indentMinus();
        return true;
    }

    private boolean wTypedNodeOrDescriptionLong(WType wt, Resource ty, Resource r, List<Statement> li) {
        Iterator<Statement> it = li.iterator();
        while (it.hasNext()) {
            this.done(it.next());
        }
        this.tab();
        this.print("<");
        wt.wTypeStart(ty);
        this.indentPlus();
        this.wIdAboutAttrOpt(r);
        this.wPropAttrSome(r);
        this.print(">");
        this.wLiEltStar(li.iterator());
        this.wPropertyEltStar(r);
        this.indentMinus();
        this.tab();
        this.print("</");
        wt.wTypeEnd(ty);
        this.print(">");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wPropertyEltStar(Resource r) {
        try (ExtendedIterator<Statement> ss = this.listProperties(r);){
            while (ss.hasNext()) {
                Statement s2 = (Statement)ss.next();
                this.wPropertyElt(this.wtype, s2.getPredicate(), s2, s2.getObject());
            }
        }
    }

    private void wLiEltStar(Iterator<Statement> ss) {
        while (ss.hasNext()) {
            Statement s2 = ss.next();
            this.wPropertyElt(this.wdesc, LI, s2, s2.getObject());
        }
    }

    private boolean wIdAboutAttrOpt(Resource r) {
        return this.wIdAttrOpt(r) || this.wNodeIDAttr(r) || this.wAboutAttr(r);
    }

    private boolean wIdAttrOpt(Resource r) {
        if (this.isGenuineAnon(r)) {
            return true;
        }
        if (this.prettyWriter.sIdAttr) {
            return false;
        }
        if (r.isAnon()) {
            return false;
        }
        if (this.isLocalReference(r)) {
            if (this.wantReification(r)) {
                return false;
            }
            if (this.idDone.contains(r)) {
                return false;
            }
            this.idDone.add(r);
            this.print(" ");
            this.printRdfAt("ID");
            this.print("=");
            this.print(this.quote(this.getXMLLocalName(r)));
            return true;
        }
        return false;
    }

    private boolean wAboutAttr(Resource r) {
        this.print(" ");
        this.printRdfAt("about");
        this.print("=");
        this.wURIreference(r);
        return true;
    }

    private void wURIreference(String s2) {
        this.print(this.quote(this.prettyWriter.relativize(s2)));
    }

    private void wURIreference(Resource r) {
        this.wURIreference(r.getURI());
    }

    private void wIdRefAttrOpt(Statement s2, Resource r) {
        this.wIdAttrReified(s2);
        if (!this.isGenuineAnon(r)) {
            this.wResourceNodeIDAttr(r);
        }
    }

    private void wIdAttrReified(Statement s2) {
        if (this.wantReification(s2)) {
            Statement[] reify = this.reification(s2);
            Resource res = this.statement2res.get(s2);
            this.idDone.add(res);
            for (int i = 0; i < reify.length; ++i) {
                this.done(reify[i]);
            }
            this.print(" ");
            this.printRdfAt("ID");
            this.print("=");
            this.print(this.quote(this.getXMLLocalName(res)));
            this.haveReified.add(res);
        }
    }

    private boolean wResourceNodeIDAttr(Resource r) {
        return this.wNodeIDAttr(r) || this.wResourceAttr(r);
    }

    private boolean wNodeIDAttr(Resource r) {
        if (!r.isAnon()) {
            return false;
        }
        this.print(" ");
        this.printRdfAt("nodeID");
        this.print("=");
        this.print(this.q(this.prettyWriter.anonId(r)));
        return true;
    }

    private boolean wResourceAttr(Resource r) {
        if (r.isAnon()) {
            return false;
        }
        this.print(" ");
        this.printRdfAt("resource");
        this.print("=");
        this.wURIreference(r);
        return true;
    }

    private void wQNameAttr(Property p) {
        this.print(this.prettyWriter.attributeTag(p.getURI()));
    }

    private void printRdfAt(String s2) {
        this.print(this.prettyWriter.rdfAt(s2));
    }

    private void wPropAttr(Property p, RDFNode n) {
        this.tab();
        if (p.equals(RDF.type)) {
            this.wTypeAttr((Resource)n);
        } else {
            this.wPropAttrString(p, (Literal)n);
        }
    }

    private void wTypeAttr(Resource r) {
        this.print(" ");
        this.printRdfAt("type");
        this.print("=");
        this.wURIreference(r);
    }

    private void wPropAttrString(Property p, Literal l) {
        this.print(" ");
        this.wQNameAttr(p);
        this.print("=" + this.quote(l.getLexicalForm()));
    }

    private void wParseCollection() {
        this.print(" ");
        this.printRdfAt("parseType");
        this.print("=" + this.q("Collection"));
    }

    private void wParseLiteral() {
        this.print(" ");
        this.printRdfAt("parseType");
        this.print("=" + this.q("Literal"));
    }

    private void wDatatype(String dtURI) {
        this.print(" ");
        this.printRdfAt("datatype");
        this.print("=");
        this.maybeNewline();
        this.wURIreference(dtURI);
    }

    private void wParseResource() {
        this.print(" ");
        this.printRdfAt("parseType");
        this.print("=" + this.q("Resource"));
    }

    private void printNameSpaceDefn() {
        this.print(this.prettyWriter.xmlnsDecl());
    }

    private static String filler(int lgth) {
        char[] rslt = new char[lgth];
        Arrays.fill(rslt, ' ');
        return new String(rslt);
    }

    private void tab() {
        int desiredColumn = this.prettyWriter.tabSize * this.indentLevel;
        if (desiredColumn > this.prettyWriter.width) {
            desiredColumn = 4 + (desiredColumn - 4) % this.prettyWriter.width;
        }
        if (desiredColumn == 0 && this.currentColumn == 0 || desiredColumn > this.currentColumn) {
            String spaces = Unparser.filler(desiredColumn - this.currentColumn);
            this.out.print(spaces);
        } else {
            this.out.println();
            this.out.print(Unparser.filler(desiredColumn));
        }
        this.currentColumn = desiredColumn;
    }

    private void maybeNewline() {
        if (this.currentColumn > this.prettyWriter.width) {
            this.tab();
        }
    }

    private String quote(String str2) {
        return this.prettyWriter.substitutedAttribute(str2);
    }

    private String q(String str2) {
        return this.prettyWriter.attributeQuoted(str2);
    }

    private void print(String s2) {
        this.out.print(s2);
        int ix = s2.lastIndexOf(10);
        this.currentColumn = ix == -1 ? (this.currentColumn += s2.length()) : s2.length() - ix - 1;
    }

    private void indentPlus() {
        ++this.indentLevel;
    }

    private void indentMinus() {
        --this.indentLevel;
    }

    private void error(String msg) {
        BrokenException e2 = new BrokenException("Internal error in Unparser: " + msg);
        this.prettyWriter.fatalError(e2);
        throw e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTypeNameSpaces() {
        try (NodeIterator nn = this.model.listObjectsOfProperty(RDF.type);){
            while (nn.hasNext()) {
                RDFNode obj = nn.nextNode();
                int split = this.isOKType(obj);
                if (split == -1) continue;
                this.prettyWriter.addNameSpace(((Resource)obj).getURI().substring(0, split));
            }
        }
    }

    private String getXMLNameSpace(Resource r) {
        if (r.isAnon()) {
            logger.error("Internal error - Unparser.getNameSpace; giving up");
            throw new BrokenException("Internal error: getNameSpace(bNode)");
        }
        String uri = r.getURI();
        int split = Util.splitNamespaceXML(uri);
        return uri.substring(0, split);
    }

    private boolean isGenuineAnon(Resource r) {
        if (!r.isAnon()) {
            return false;
        }
        Integer v = this.objectTable.get(r);
        return v == null || !this.prettyWriter.sResourcePropertyElt && v <= 1 && !this.haveReified.contains(r);
    }

    private boolean isLocalReference(Resource r) {
        return !r.isAnon() && this.getXMLNameSpace(r).equals(this.localName + "#") && XMLChar.isValidNCName(this.getXMLLocalName(r));
    }

    private String getXMLLocalName(Resource r) {
        if (r.isAnon()) {
            logger.error("Internal error - giving up - Unparser.getLocalName");
            throw new BrokenException("Internal error: getLocalName(bNode)");
        }
        String uri = r.getURI();
        int split = Util.splitNamespaceXML(uri);
        return uri.substring(split);
    }

    private void increaseObjectCount(Resource r) {
        Integer cnt = this.objectTable.get(r);
        cnt = cnt == null ? one : Integer.valueOf(cnt + 1);
        this.objectTable.put(r, cnt);
    }

    private boolean wantReification(Statement s2) {
        return this.wantReification(s2, this.statement2res.get(s2));
    }

    private boolean wantReification(Resource res) {
        return this.wantReification(this.res2statement.get(res), res);
    }

    private boolean wantReification(Statement s2, Resource ref) {
        if (s2 == null || ref == null || ref.isAnon() || this.prettyWriter.sReification) {
            return false;
        }
        if (!this.isLocalReference(ref)) {
            return false;
        }
        Statement[] reify = this.reification(s2);
        for (int i = 0; i < reify.length; ++i) {
            if (!this.doneSet.contains(reify[i]) && this.model.contains(reify[i])) continue;
            return false;
        }
        return true;
    }

    private Statement[] reification(Statement s2) {
        Model m4 = s2.getModel();
        Resource r = this.statement2res.get(s2);
        return new Statement[]{m4.createStatement(r, RDF.type, RDF.Statement), m4.createStatement(r, RDF.subject, s2.getSubject()), m4.createStatement(r, RDF.predicate, s2.getPredicate()), m4.createStatement(r, RDF.object, s2.getObject())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasProperties(Resource r) {
        ExtendedIterator<Statement> ss = this.listProperties(r);
        if (this.avoidExplicitReification && !r.isAnon() && this.isLocalReference(r) && this.res2statement.containsKey(r)) {
            ss = new MapFilterIterator<Statement, Statement>(new MapFilter<Statement, Statement>(){

                @Override
                public Statement accept(Statement o) {
                    Statement s2 = o;
                    Property p = s2.getPredicate();
                    return !p.getNameSpace().equals(rdfns) || (!RDF.type.equals(p) || !s2.getObject().equals(RDF.Statement)) && !RDF.object.equals(p) && !RDF.predicate.equals(p) && !RDF.subject.equals(p) ? o : null;
                }
            }, ss);
        }
        try {
            boolean bl = ss.hasNext();
            return bl;
        }
        finally {
            ss.close();
        }
    }

    private ExtendedIterator<Statement> listProperties(Resource r) {
        return new MapFilterIterator<Statement, Statement>(new MapFilter<Statement, Statement>(){

            @Override
            public Statement accept(Statement o) {
                return Unparser.this.doneSet.contains(o) ? null : o;
            }
        }, r.listProperties());
    }

    private boolean canBeAttribute(Statement s2, Set<Property> seen) {
        Property p = s2.getPredicate();
        if (this.prettyWriter.sPropertyAttr || seen.contains(p)) {
            return false;
        }
        seen.add(p);
        if (p.equals(RDF.type)) {
            RDFNode n = s2.getObject();
            return n.isURIResource();
        }
        if (s2.getObject() instanceof Literal) {
            Literal l = s2.getLiteral();
            if (!Util.isSimpleString(l) && l.getDatatypeURI() != null) {
                return false;
            }
            if (l.getLanguage().equals("")) {
                if (this.prettyWriter.isDefaultNamespace(this.getXMLNameSpace(p))) {
                    return false;
                }
                String str2 = l.getString();
                if (str2.length() < 40) {
                    char[] buf;
                    for (char aBuf : buf = str2.toCharArray()) {
                        if (aBuf > ' ' && aBuf != '\uffff' && aBuf != '\ufffe') continue;
                        return false;
                    }
                    return !this.wantReification(s2);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean allPropsAreAttr(Resource r) {
        HashSet<Property> seen = new HashSet<Property>();
        try (ExtendedIterator<Statement> ss = this.listProperties(r);){
            while (ss.hasNext()) {
                Statement s2 = (Statement)ss.next();
                if (this.canBeAttribute(s2, seen)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private void done(Statement s2) {
        this.doneSet.add(s2);
    }

    private Statement[][] getRDFList(RDFNode r) {
        return this.prettyWriter.sParseTypeCollectionPropertyElt ? null : this.getList(r, null, RDF.first, RDF.rest, RDF.nil);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement[][] getList(RDFNode r, Resource list, Property first, Property rest, Resource nil) {
        Vector<Statement[]> rslt = new Vector<Statement[]>();
        HashSet<RDFNode> seen = new HashSet<RDFNode>();
        RDFNode next = r;
        while (!next.equals(nil)) {
            Statement[] elt = new Statement[list == null ? 2 : 3];
            if (next instanceof Literal) {
                return null;
            }
            Resource res = (Resource)next;
            if (!this.isGenuineAnon(res)) {
                return null;
            }
            if (seen.contains(next)) {
                return null;
            }
            seen.add(next);
            try (StmtIterator ss = res.listProperties();){
                while (ss.hasNext()) {
                    int ix;
                    Statement s2 = ss.nextStatement();
                    Property p = s2.getPredicate();
                    RDFNode obj = s2.getObject();
                    if (this.doneSet.contains(s2)) {
                        Statement[][] statementArray = null;
                        return statementArray;
                    }
                    if (!(obj instanceof Resource)) {
                        Statement[][] statementArray = null;
                        return statementArray;
                    }
                    if (p.equals(RDF.type)) {
                        ix = 2;
                        if (!obj.equals(list)) {
                            Statement[][] statementArray = null;
                            return statementArray;
                        }
                    } else if (p.equals(first)) {
                        ix = 0;
                    } else if (p.equals(rest)) {
                        ix = 1;
                        next = obj;
                    } else {
                        Statement[][] statementArray = null;
                        return statementArray;
                    }
                    if (elt[ix] != null) {
                        Statement[][] statementArray = null;
                        return statementArray;
                    }
                    elt[ix] = s2;
                }
            }
            for (Statement anElt : elt) {
                if (anElt != null) continue;
                return null;
            }
            rslt.add(elt);
        }
        if (rslt.size() == 0) {
            return null;
        }
        Statement[][] array = new Statement[rslt.size()][];
        rslt.copyInto((Object[])array);
        return array;
    }

    private Statement getType(Resource r) {
        Statement rslt;
        try {
            if (r instanceof Statement) {
                rslt = ((Statement)((Object)r)).getStatementProperty(RDF.type);
                if (rslt == null || !rslt.getObject().equals(RDF.Statement)) {
                    this.error("Statement type problem");
                }
            } else {
                rslt = r.getRequiredProperty(RDF.type);
            }
        }
        catch (PropertyNotFoundException rdfe) {
            if (r instanceof Statement) {
                this.error("Statement type problem");
            }
            rslt = null;
        }
        if (rslt == null || this.isOKType(rslt.getObject()) == -1) {
            return null;
        }
        return rslt;
    }

    private int isOKType(RDFNode n) {
        if (!(n instanceof Resource)) {
            return -1;
        }
        if (((Resource)n).isAnon()) {
            return -1;
        }
        String uri = ((Resource)n).getURI();
        int split = Util.splitNamespaceXML(uri);
        if (split == 0 || split == uri.length()) {
            return -1;
        }
        return split;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findInfiniteCycles() {
        Relation<Resource> relation = new Relation<Resource>();
        try (StmtIterator ss = this.model.listStatements();){
            while (ss.hasNext()) {
                RDFNode rn;
                Statement s2 = ss.nextStatement();
                if (this.doneSet.contains(s2) || !((rn = s2.getObject()) instanceof Resource)) continue;
                relation.set(s2.getSubject(), (Resource)rn);
            }
        }
        relation.transitiveClosure();
        this.infinite = relation.getDiagonal();
    }

    private ExtendedIterator<Resource> allInfiniteLeft() {
        return new LazyIterator<Resource>(){

            @Override
            public ExtendedIterator<Resource> create() {
                return WrappedIterator.create(Unparser.this.infinite.iterator());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<Resource> pleasingTypeIterator() {
        if (this.pleasingTypes == null) {
            return NullIterator.instance();
        }
        HashMap<Resource, Set> buckets = new HashMap<Resource, Set>();
        Set[] bucketArray = new Set[this.pleasingTypes.length];
        for (int i = 0; i < this.pleasingTypes.length; ++i) {
            bucketArray[i] = new HashSet();
            buckets.put(this.pleasingTypes[i], bucketArray[i]);
        }
        try (ResIterator rs = this.model.listSubjects();){
            while (rs.hasNext()) {
                Integer v;
                Set bucket;
                Resource r = rs.nextResource();
                Statement s2 = this.getType(r);
                if (s2 == null || (bucket = (Set)buckets.get(s2.getObject())) == null || this.isGenuineAnon(r) && (v = this.objectTable.get(r)) != null && v == 1) continue;
                bucket.add(r);
            }
        }
        return WrappedIterator.createIteratorIterator(new Map1Iterator<Set, Iterator>(bkt -> bkt.iterator(), Arrays.asList(bucketArray).iterator()));
    }

    private Iterator<Resource> listSubjects() {
        SingletonIterator<Resource> currentFile = new SingletonIterator<Resource>(this.model.createResource(this.localName));
        Iterator<Resource> pleasing = this.pleasingTypeIterator();
        NullIterator<Resource> fakeStopPleasing = new NullIterator<Resource>(){

            @Override
            public boolean hasNext() {
                Unparser.this.pleasingTypeSet = new HashSet<Resource>();
                return false;
            }
        };
        ExtendedIterator<Resource> nonObjects = this.modelListSubjects().filterKeep(o -> !this.objectTable.containsKey(o) && !this.wantReification((Resource)o));
        NullIterator<Resource> fakeLazyEvaluator = new NullIterator<Resource>(){

            @Override
            public boolean hasNext() {
                Unparser.this.findInfiniteCycles();
                return false;
            }
        };
        ExtendedIterator<Resource> firstChoiceCyclic = this.allInfiniteLeft().filterKeep(r -> {
            this.codeCoverage[4] = this.codeCoverage[4] + 1;
            if (r.isAnon()) {
                return false;
            }
            Integer cnt = this.objectTable.get(r);
            return cnt != null && cnt > 1;
        });
        ExtendedIterator<Resource> nonAnonInfinite = this.allInfiniteLeft().filterKeep(r -> {
            this.codeCoverage[5] = this.codeCoverage[5] + 1;
            return !this.isGenuineAnon((Resource)r);
        });
        ExtendedIterator<Resource> inf = this.allInfiniteLeft();
        NullIterator<Resource> anotherFake = new NullIterator<Resource>(){

            @Override
            public boolean hasNext() {
                Unparser.this.avoidExplicitReification = false;
                return false;
            }
        };
        ExtendedIterator<Resource> reifications = this.allInfiniteLeft().filterKeep(r -> {
            this.codeCoverage[6] = this.codeCoverage[6] + 1;
            return this.res2statement.containsKey(r);
        });
        ResIterator backStop = this.modelListSubjects();
        Iterator[] all = new Iterator[]{currentFile, pleasing, fakeStopPleasing, nonObjects, fakeLazyEvaluator, firstChoiceCyclic, nonAnonInfinite, inf, anotherFake, reifications, new NullIterator<Resource>(){

            @Override
            public boolean hasNext() {
                if (Unparser.this.modelListSubjects().hasNext()) {
                    Unparser.this.codeCoverage[7] = Unparser.this.codeCoverage[7] + 1;
                }
                return false;
            }
        }, backStop};
        ExtendedIterator<Resource> allAsOne = WrappedIterator.createIteratorIterator(Arrays.asList(all).iterator());
        return allAsOne.filterKeep(this::hasProperties);
    }

    private synchronized void closeAllResIterators() {
        Iterator<ResIterator> members = this.openResIterators.iterator();
        while (members.hasNext()) {
            members.next().close();
        }
        this.openResIterators = new HashSet<ResIterator>();
    }

    private ResIterator modelListSubjects() {
        ResIterator resIt = this.model.listSubjects();
        this.openResIterators.add(resIt);
        return resIt;
    }

    private abstract class WType {
        private WType() {
        }

        abstract void wTypeStart(Resource var1);

        abstract void wTypeEnd(Resource var1);
    }
}

