/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;

public class TransformUnionQuery
extends TransformCopy {
    Deque<Node> currentGraph = new ArrayDeque<Node>();

    public static Op transform(Op op) {
        TransformUnionQuery t2 = new TransformUnionQuery();
        Op op2 = Transformer.transform(t2, op, new Pusher(t2.currentGraph), new Popper(t2.currentGraph));
        return op2;
    }

    public TransformUnionQuery() {
        this.currentGraph.push(Quad.defaultGraphNodeGenerated);
    }

    @Override
    public Op transform(OpQuadPattern quadPattern) {
        if (quadPattern.isDefaultGraph() || quadPattern.isUnionGraph()) {
            OpBGP opBGP = new OpBGP(quadPattern.getBasicPattern());
            return this.union(opBGP);
        }
        return super.transform(quadPattern);
    }

    @Override
    public Op transform(OpBGP opBGP) {
        Node current = this.currentGraph.peek();
        if (current == Quad.defaultGraphNodeGenerated || current == Quad.unionGraph) {
            return this.union(opBGP);
        }
        return super.transform(opBGP);
    }

    private Op union(OpBGP opBGP) {
        Var v = Var.ANON;
        Op op = new OpGraph(v, opBGP);
        op = OpDistinct.create(op);
        return op;
    }

    @Override
    public Op transform(OpGraph opGraph, Op x) {
        return super.transform(opGraph, x);
    }

    static class Popper
    extends OpVisitorBase {
        private Deque<Node> stack;

        Popper(Deque<Node> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            Node n = this.stack.pop();
            if (!opGraph.getNode().equals(n)) {
                throw new ARQInternalErrorException();
            }
        }
    }

    static class Pusher
    extends OpVisitorBase {
        private Deque<Node> stack;

        Pusher(Deque<Node> stack) {
            this.stack = stack;
        }

        @Override
        public void visit(OpGraph opGraph) {
            this.stack.push(opGraph.getNode());
        }
    }
}

