/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraphBase;
import org.apache.jena.sparql.core.Quad;

public abstract class DatasetGraphBaseFind
extends DatasetGraphBase {
    protected DatasetGraphBaseFind() {
    }

    @Override
    public Iterator<Quad> find(Node g2, Node s2, Node p, Node o) {
        if (Quad.isDefaultGraph(g2)) {
            return this.findInDftGraph(s2, p, o);
        }
        if (!DatasetGraphBaseFind.isWildcard(g2)) {
            return this.findNG(g2, s2, p, o);
        }
        return this.findAny(s2, p, o);
    }

    @Override
    public Iterator<Quad> findNG(Node g2, Node s2, Node p, Node o) {
        Iterator<Quad> qIter = Quad.isUnionGraph(g2) ? this.findQuadsInUnionGraph(s2, p, o) : (DatasetGraphBaseFind.isWildcard(g2) ? this.findInAnyNamedGraphs(s2, p, o) : (Quad.isDefaultGraph(g2) ? this.findInDftGraph(s2, p, o) : this.findInSpecificNamedGraph(g2, s2, p, o)));
        if (qIter == null) {
            return Iter.nullIterator();
        }
        return qIter;
    }

    protected Iterator<Quad> findAny(Node s2, Node p, Node o) {
        Iterator<Quad> iter2;
        Iterator<Quad> iter1 = this.findInDftGraph(s2, p, o);
        if (!iter1.hasNext()) {
            iter1 = null;
        }
        if (!(iter2 = this.findInAnyNamedGraphs(s2, p, o)).hasNext()) {
            iter2 = null;
        }
        return Iter.append(iter1, iter2);
    }

    protected abstract Iterator<Quad> findInDftGraph(Node var1, Node var2, Node var3);

    public Iterator<Triple> findInUnionGraph(Node s2, Node p, Node o) {
        return this.findUnionGraphTriples(s2, p, o).iterator();
    }

    public Iterator<Quad> findQuadsInUnionGraph(Node s2, Node p, Node o) {
        return this.findUnionGraphTriples(s2, p, o).map(t2 -> new Quad(Quad.unionGraph, (Triple)t2)).iterator();
    }

    private Stream<Triple> findUnionGraphTriples(Node s2, Node p, Node o) {
        return Iter.asStream(this.findInAnyNamedGraphs(s2, p, o)).map(Quad::asTriple).distinct();
    }

    protected abstract Iterator<Quad> findInSpecificNamedGraph(Node var1, Node var2, Node var3, Node var4);

    protected abstract Iterator<Quad> findInAnyNamedGraphs(Node var1, Node var2, Node var3);
}

