/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapStd;
import org.apache.jena.shared.LockMRPlusSW;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.DatasetGraphTriplesQuads;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.mem.HexTable;
import org.apache.jena.sparql.core.mem.QuadTable;
import org.apache.jena.sparql.core.mem.TriTable;
import org.apache.jena.sparql.core.mem.TripleTable;
import org.apache.jena.system.Txn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphInMemory
extends DatasetGraphTriplesQuads
implements Transactional {
    private static final Logger log = LoggerFactory.getLogger(DatasetGraphInMemory.class);
    private final PrefixMap prefixes = new PrefixMapStd();
    private final org.apache.jena.shared.Lock transactionLock = new LockMRPlusSW();
    private final ReentrantLock systemLock = new ReentrantLock(true);
    private final AtomicLong generation = new AtomicLong(0L);
    private final ThreadLocal<Long> version = ThreadLocal.withInitial(() -> 0L);
    private final ThreadLocal<Boolean> isInTransaction = ThreadLocal.withInitial(() -> false);
    private final ThreadLocal<TxnType> transactionType = ThreadLocal.withInitial(() -> null);
    private final ThreadLocal<ReadWrite> transactionMode = ThreadLocal.withInitial(() -> null);
    private final QuadTable quadsIndex;
    private final TripleTable defaultGraph;
    private final Consumer<Graph> removeGraph = g2 -> g2.find().forEachRemaining(g2::delete);

    @Override
    public boolean isInTransaction() {
        return this.isInTransaction.get();
    }

    protected void isInTransaction(boolean b) {
        this.isInTransaction.set(b);
    }

    @Override
    public ReadWrite transactionMode() {
        return this.transactionMode.get();
    }

    @Override
    public TxnType transactionType() {
        return this.transactionType.get();
    }

    private void transactionMode(ReadWrite readWrite) {
        this.transactionMode.set(readWrite);
    }

    private QuadTable quadsIndex() {
        return this.quadsIndex;
    }

    private TripleTable defaultGraph() {
        return this.defaultGraph;
    }

    public DatasetGraphInMemory() {
        this(new HexTable(), new TriTable());
    }

    public DatasetGraphInMemory(QuadTable i, TripleTable t2) {
        this.quadsIndex = i;
        this.defaultGraph = t2;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return true;
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.begin(TxnType.convert(readWrite));
    }

    @Override
    public void begin(TxnType txnType) {
        if (this.isInTransaction()) {
            throw new JenaTransactionException("Transactions cannot be nested!");
        }
        this.transactionType.set(txnType);
        this._begin(txnType, TxnType.initial(txnType));
    }

    private void _begin(TxnType txnType, ReadWrite readWrite) {
        this.startTransaction(txnType, readWrite);
        DatasetGraphInMemory.withLock(this.systemLock, () -> {
            this.quadsIndex().begin(readWrite);
            this.defaultGraph().begin(readWrite);
            this.version.set(this.generation.get());
        });
    }

    private void startTransaction(TxnType txnType, ReadWrite mode) {
        this.transactionLock.enterCriticalSection(mode.equals((Object)ReadWrite.READ));
        this.transactionType.set(txnType);
        this.transactionMode(mode);
        this.isInTransaction(true);
    }

    private void finishTransaction() {
        this.isInTransaction.remove();
        this.transactionType.remove();
        this.transactionMode.remove();
        this.version.remove();
        this.transactionLock.leaveCriticalSection();
    }

    @Override
    public boolean promote(Transactional.Promote promoteMode) {
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Tried to promote outside a transaction!");
        }
        if (this.transactionMode().equals((Object)ReadWrite.WRITE)) {
            return true;
        }
        if (this.transactionType() == TxnType.READ) {
            return false;
        }
        boolean readCommitted = promoteMode == Transactional.Promote.READ_COMMITTED;
        try {
            this._promote(readCommitted);
            return true;
        }
        catch (JenaTransactionException ex) {
            return false;
        }
    }

    private void _promote(boolean readCommited) {
        if (!readCommited && this.version.get().longValue() != this.generation.get()) {
            throw new JenaTransactionException("Dataset changed - can't promote");
        }
        this.transactionLock.enterCriticalSection(false);
        if (!readCommited && this.version.get().longValue() != this.generation.get()) {
            this.transactionLock.leaveCriticalSection();
            throw new JenaTransactionException("Concurrent writer changed the dataset : can't promote");
        }
        this.transactionMode(ReadWrite.WRITE);
        this._begin(this.transactionType(), ReadWrite.WRITE);
    }

    @Override
    public void commit() {
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Tried to commit outside a transaction!");
        }
        if (this.transactionMode().equals((Object)ReadWrite.WRITE)) {
            this._commit();
        }
        this.finishTransaction();
    }

    private void _commit() {
        DatasetGraphInMemory.withLock(this.systemLock, () -> {
            this.quadsIndex().commit();
            this.defaultGraph().commit();
            this.quadsIndex().end();
            this.defaultGraph().end();
            if (this.transactionMode().equals((Object)ReadWrite.WRITE)) {
                if (this.version.get().longValue() != this.generation.get()) {
                    throw new InternalErrorException(String.format("Version=%d, Generation=%d", this.version.get(), this.generation.get()));
                }
                this.generation.incrementAndGet();
            }
        });
    }

    @Override
    public void abort() {
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Tried to abort outside a transaction!");
        }
        if (this.transactionMode().equals((Object)ReadWrite.WRITE)) {
            this._abort();
        }
        this.finishTransaction();
    }

    private void _abort() {
        DatasetGraphInMemory.withLock(this.systemLock, () -> {
            this.quadsIndex().abort();
            this.defaultGraph().abort();
            this.quadsIndex().end();
            this.defaultGraph().end();
        });
    }

    @Override
    public void close() {
        if (this.isInTransaction()) {
            this.abort();
        }
    }

    @Override
    public void end() {
        if (this.isInTransaction()) {
            if (this.transactionMode().equals((Object)ReadWrite.WRITE)) {
                String msg = "end() called for WRITE transaction without commit or abort having been called. This causes a forced abort.";
                this._abort();
                this.finishTransaction();
                throw new JenaTransactionException(msg);
            }
            this._end();
            this.finishTransaction();
        }
    }

    private void _end() {
        DatasetGraphInMemory.withLock(this.systemLock, () -> {
            this.quadsIndex().end();
            this.defaultGraph().end();
        });
    }

    private static void withLock(Lock lock, Runnable action) {
        lock.lock();
        try {
            action.run();
        }
        finally {
            lock.unlock();
        }
    }

    private <T> T access(Supplier<T> source) {
        return (T)(this.isInTransaction() ? source.get() : Txn.calculateRead(this, source::get));
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.access(() -> this.quadsIndex().listGraphNodes().iterator());
    }

    private Iterator<Quad> quadsFinder(Node g2, Node s2, Node p, Node o) {
        if (Quad.isUnionGraph(g2)) {
            return this.findInUnionGraph$(s2, p, o);
        }
        return this.quadsIndex().find(g2, s2, p, o).iterator();
    }

    private Iterator<Quad> findInUnionGraph$(Node s2, Node p, Node o) {
        return this.access(() -> this.quadsIndex().findInUnionGraph(s2, p, o).iterator());
    }

    private Iterator<Quad> triplesFinder(Node s2, Node p, Node o) {
        return G.triples2quadsDftGraph(this.defaultGraph().find(s2, p, o).iterator());
    }

    @Override
    public void setDefaultGraph(Graph g2) {
        this.mutate(graph -> {
            this.defaultGraph().clear();
            graph.find().forEachRemaining(this.defaultGraph()::add);
        }, g2);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph(this, graphNode);
    }

    @Override
    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph(this);
    }

    @Override
    public Graph getUnionGraph() {
        return GraphView.createUnionGraph(this);
    }

    private Consumer<Graph> addGraph(Node name) {
        return g2 -> g2.find().mapWith(t2 -> new Quad(name, (Triple)t2)).forEachRemaining(this::add);
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        this.mutate(this.addGraph(graphName), graph);
    }

    @Override
    public void removeGraph(Node graphName) {
        this.mutate(this.removeGraph, this.getGraph(graphName));
    }

    private <T> void mutate(Consumer<T> mutator, T payload) {
        if (this.isInTransaction()) {
            if (!this.transactionMode().equals((Object)ReadWrite.WRITE)) {
                TxnType mode = this.transactionType.get();
                switch (mode) {
                    case WRITE: {
                        break;
                    }
                    case READ: {
                        throw new JenaTransactionException("Tried to write inside a READ transaction!");
                    }
                    case READ_COMMITTED_PROMOTE: 
                    case READ_PROMOTE: {
                        boolean readCommitted = mode == TxnType.READ_COMMITTED_PROMOTE;
                        this._promote(readCommitted);
                    }
                }
            }
            mutator.accept(payload);
        } else {
            Txn.executeWrite(this, () -> mutator.accept(payload));
        }
    }

    @Override
    public PrefixMap prefixes() {
        return this.prefixes;
    }

    @Override
    public long size() {
        return this.access(() -> this.quadsIndex().listGraphNodes().count());
    }

    @Override
    public void clear() {
        this.mutate(x -> {
            this.defaultGraph().clear();
            this.quadsIndex().clear();
        }, null);
    }

    @Override
    protected void addToDftGraph(Node s2, Node p, Node o) {
        this.mutate(this.defaultGraph()::add, Triple.create(s2, p, o));
    }

    @Override
    protected void addToNamedGraph(Node g2, Node s2, Node p, Node o) {
        this.mutate(this.quadsIndex()::add, Quad.create(g2, s2, p, o));
    }

    @Override
    protected void deleteFromDftGraph(Node s2, Node p, Node o) {
        this.mutate(this.defaultGraph()::delete, Triple.create(s2, p, o));
    }

    @Override
    protected void deleteFromNamedGraph(Node g2, Node s2, Node p, Node o) {
        this.mutate(this.quadsIndex()::delete, Quad.create(g2, s2, p, o));
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s2, Node p, Node o) {
        return this.access(() -> this.triplesFinder(s2, p, o));
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g2, Node s2, Node p, Node o) {
        return this.access(() -> this.quadsFinder(g2, s2, p, o));
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s2, Node p, Node o) {
        return this.findInSpecificNamedGraph(Node.ANY, s2, p, o);
    }
}

