/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.solver;

import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarAlloc;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterAddTripleTerm;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.util.Context;

class RX_PG {
    RX_PG() {
    }

    private static QueryIterator rdfStarTriple_PG(QueryIterator chain, Triple triple, ExecutionContext execCxt) {
        if (!RX_PG.tripleHasNodeTriple(triple)) {
            return RX_PG.matchData(chain, triple, execCxt);
        }
        return RX_PG.rdfStarTripleSub(chain, triple, execCxt);
    }

    private static QueryIterator rdfStarTripleSub(QueryIterator chain, Triple triple, ExecutionContext execCxt) {
        Pair<QueryIterator, Triple> pair = RX_PG.preprocessForTripleTerms(chain, triple, execCxt);
        QueryIterator chain2 = RX_PG.matchData(pair.getLeft(), pair.getRight(), execCxt);
        return chain2;
    }

    private static QueryIterator findTripleStar(QueryIterator chain, Var var, Triple triple, ExecutionContext execCxt) {
        return RX_PG.matchTripleStar(chain, var, triple, execCxt);
    }

    private static QueryIterator matchTripleStar(QueryIterator chain, Var var, Triple triple, ExecutionContext execCxt) {
        if (RX_PG.tripleHasNodeTriple(triple)) {
            Pair<QueryIterator, Triple> pair = RX_PG.preprocessForTripleTerms(chain, triple, execCxt);
            chain = pair.getLeft();
            triple = pair.getRight();
        }
        QueryIterator qIter = RX_PG.bindTripleTerm(chain, var, triple, execCxt);
        return qIter;
    }

    private static Pair<QueryIterator, Triple> preprocessForTripleTerms(QueryIterator chain, Triple patternTriple, ExecutionContext execCxt) {
        Triple tripleTerm;
        Var var;
        Triple t2;
        Node s2 = patternTriple.getSubject();
        Node p = patternTriple.getPredicate();
        Node o = patternTriple.getObject();
        Node s1 = null;
        Node o1 = null;
        if (s2.isNodeTriple()) {
            t2 = s2.getTriple();
            var = RX_PG.varAlloc(execCxt).allocVar();
            tripleTerm = Triple.create(t2.getSubject(), t2.getPredicate(), t2.getObject());
            chain = RX_PG.matchTripleStar(chain, var, tripleTerm, execCxt);
            s1 = var;
        }
        if (o.isNodeTriple()) {
            t2 = o.getTriple();
            var = RX_PG.varAlloc(execCxt).allocVar();
            tripleTerm = Triple.create(t2.getSubject(), t2.getPredicate(), t2.getObject());
            chain = RX_PG.matchTripleStar(chain, var, tripleTerm, execCxt);
            o1 = var;
        }
        if (s1 == null && o1 == null) {
            return Pair.create(chain, patternTriple);
        }
        if (s1 == null) {
            s1 = s2;
        }
        if (o1 == null) {
            o1 = o;
        }
        Triple triple1 = Triple.create(s1, p, o1);
        return Pair.create(chain, triple1);
    }

    private static QueryIterator bindTripleTerm(QueryIterator chain, Var var, Triple pattern, ExecutionContext execCxt) {
        QueryIterator qIter = RX_PG.matchData(chain, pattern, execCxt);
        QueryIterAddTripleTerm qIter2 = new QueryIterAddTripleTerm(qIter, var, pattern, execCxt);
        return qIter2;
    }

    private static QueryIterator matchData(QueryIterator chain, Triple pattern, ExecutionContext execCxt) {
        return QC.execute(chain, pattern, execCxt);
    }

    private static boolean tripleHasNodeTriple(Triple triple) {
        return triple.getSubject().isNodeTriple() || triple.getObject().isNodeTriple();
    }

    private static VarAlloc varAlloc(ExecutionContext execCxt) {
        Context context2 = execCxt.getContext();
        VarAlloc varAlloc = VarAlloc.get(context2, ARQConstants.sysVarAllocRDFStar);
        if (varAlloc == null) {
            varAlloc = new VarAlloc("~");
            context2.set(ARQConstants.sysVarAllocRDFStar, varAlloc);
        }
        return varAlloc;
    }
}

