/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.solver;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.main.solver.SolverLib;

public class StageMatchData {
    private static int QG = 0;
    private static int QS = 1;
    private static int QP = 2;
    private static int QO = 3;
    private static Function<Quad, Quad> quadsToUnion = quad -> Quad.create(Quad.unionGraph, quad.getSubject(), quad.getPredicate(), quad.getObject());

    static Iterator<Binding> accessQuad(Iterator<Binding> input, Node graphName, Triple pattern, Predicate<Quad> filter, boolean anyGraph, ExecutionContext execCxt) {
        return Iter.flatMap(input, binding -> StageMatchData.accessQuad(binding, graphName, pattern, filter, anyGraph, execCxt));
    }

    static Iterator<Binding> accessQuad(Binding binding, Node graphName, Triple pattern, Predicate<Quad> filter, boolean anyGraph, ExecutionContext execCxt) {
        Iterator<Quad> iterMatches;
        Node g2 = graphName;
        Node s2 = pattern.getSubject();
        Node p = pattern.getPredicate();
        Node o = pattern.getObject();
        Node[] matchConst = new Node[4];
        Var[] vars = new Var[4];
        boolean b = StageMatchData.prepareQuad(binding, graphName, pattern, matchConst, vars);
        if (!b) {
            return Iter.nullIterator();
        }
        Node gm = matchConst[QG];
        Node sm = matchConst[QS];
        Node pm = matchConst[QP];
        Node om = matchConst[QO];
        DatasetGraph dsg = execCxt.getDataset();
        Iterator<Quad> iterator = iterMatches = anyGraph ? dsg.findNG(gm, sm, pm, om) : dsg.find(gm, sm, pm, om);
        if (filter != null) {
            iterMatches = Iter.filter(iterMatches, filter);
        }
        if (anyGraph) {
            iterMatches = Iter.map(iterMatches, quadsToUnion);
            iterMatches = Iter.distinct(iterMatches);
        }
        BindingBuilder bindingBuilder = BindingFactory.builder(binding);
        Function<Quad, Binding> binder = quad -> StageMatchData.quadToBinding(bindingBuilder, quad, matchConst, vars);
        return Iter.iter(iterMatches).map(binder).removeNulls();
    }

    private static Binding quadToBinding(BindingBuilder bindingBuilder, Quad quad, Node[] matchConst, Var[] vars) {
        bindingBuilder.reset();
        if (!StageMatchData.slot(bindingBuilder, vars[QG], quad.getGraph())) {
            return null;
        }
        if (!StageMatchData.slot(bindingBuilder, vars[QS], quad.getSubject())) {
            return null;
        }
        if (!StageMatchData.slot(bindingBuilder, vars[QP], quad.getPredicate())) {
            return null;
        }
        if (!StageMatchData.slot(bindingBuilder, vars[QO], quad.getObject())) {
            return null;
        }
        return bindingBuilder.build();
    }

    private static boolean slot(BindingBuilder bindingBuilder, Var var, Node dataNode) {
        if (var == null) {
            return true;
        }
        Node x = bindingBuilder.get(var);
        if (x != null) {
            return SolverLib.sameTermAs(dataNode, x);
        }
        bindingBuilder.add(var, dataNode);
        return true;
    }

    private static boolean prepareQuad(Binding binding, Node graphName, Triple pattern, Node[] matchConst, Var[] vars) {
        StageMatchData.prepare(QG, binding, graphName, matchConst, vars);
        StageMatchData.prepare(QS, binding, pattern.getSubject(), matchConst, vars);
        StageMatchData.prepare(QP, binding, pattern.getPredicate(), matchConst, vars);
        StageMatchData.prepare(QO, binding, pattern.getObject(), matchConst, vars);
        return true;
    }

    private static void prepare(int i, Binding binding, Node n, Node[] matchConst, Var[] vars) {
        if (Var.isVar(n = StageMatchData.substituteFlat(n, binding))) {
            vars[i] = Var.alloc(n);
        } else {
            matchConst[i] = n;
        }
    }

    private static Node substituteFlat(Node n, Binding binding) {
        return Var.lookup(binding::get, n);
    }
}

